/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputFormat;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlTextRendererBase;

public class HtmlFormatRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlFormatRenderer.class);
    private static final Object[] EMPTY_ARGS = new Object[0];

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component2, UIOutput.class);
        String text = this.getOutputFormatText(facesContext, component2);
        boolean isEscape = component2 instanceof HtmlOutputFormat ? ((HtmlOutputFormat)component2).isEscape() : RendererUtils.getBooleanAttribute(component2, "escape", true);
        HtmlTextRendererBase.renderOutputText(facesContext, component2, text, isEscape);
    }

    private String getOutputFormatText(FacesContext facesContext, UIComponent htmlOutputFormat) {
        Object[] args;
        String pattern = RendererUtils.getStringValue(facesContext, htmlOutputFormat);
        if (htmlOutputFormat.getChildCount() == 0) {
            args = EMPTY_ARGS;
        } else {
            ArrayList<Object> argsList = new ArrayList<Object>();
            for (UIComponent child : htmlOutputFormat.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                argsList.add(((UIParameter)child).getValue());
            }
            args = argsList.toArray(new Object[argsList.size()]);
        }
        MessageFormat format = new MessageFormat(pattern, facesContext.getViewRoot().getLocale());
        try {
            return format.format(args);
        }
        catch (Exception e) {
            log.error((Object)("Error formatting message of component " + htmlOutputFormat.getClientId(facesContext)));
            return "";
        }
    }
}

