/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.ManagedBeanBuilder;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanResolver
extends ELResolver {
    private static final Log log = LogFactory.getLog(ManagedBeanResolver.class);
    private static final String BEANS_UNDER_CONSTRUCTION = "org.apache.myfaces.el.unified.resolver.managedbean.beansUnderConstruction";
    protected static final Map s_standardScopes = new HashMap(16);
    protected final Map _scopes = new HashMap(16);
    private RuntimeConfig runtimeConfig;
    private ManagedBeanBuilder beanBuilder;

    public ManagedBeanResolver() {
        this._scopes.putAll(s_standardScopes);
        this.beanBuilder = new ManagedBeanBuilder();
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        return false;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        ExternalContext extContext = this.externalContext(context);
        if (extContext == null) {
            return null;
        }
        if (extContext.getRequestMap().containsKey(property)) {
            return null;
        }
        if (extContext.getSessionMap().containsKey(property)) {
            return null;
        }
        if (extContext.getApplicationMap().containsKey(property)) {
            return null;
        }
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = (String)property;
        ManagedBean managedBean = this.runtimeConfig(context).getManagedBean(strProperty);
        Object beanInstance = null;
        if (managedBean != null) {
            FacesContext facesContext = this.facesContext(context);
            context.setPropertyResolved(true);
            beanInstance = this.createManagedBean(managedBean, facesContext);
        }
        return beanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createManagedBean(ManagedBean managedBean, FacesContext facesContext) throws ELException {
        String managedBeanName;
        ExternalContext extContext = facesContext.getExternalContext();
        Map<String, Object> requestMap = extContext.getRequestMap();
        ArrayList<String> beansUnderConstruction = (ArrayList<String>)requestMap.get(BEANS_UNDER_CONSTRUCTION);
        if (beansUnderConstruction == null) {
            beansUnderConstruction = new ArrayList<String>();
            requestMap.put(BEANS_UNDER_CONSTRUCTION, beansUnderConstruction);
        }
        if (beansUnderConstruction.contains(managedBeanName = managedBean.getManagedBeanName())) {
            throw new ELException("Detected cyclic reference to managedBean " + managedBeanName);
        }
        beansUnderConstruction.add(managedBeanName);
        Object obj = null;
        try {
            obj = this.beanBuilder.buildManagedBean(facesContext, managedBean);
        }
        finally {
            beansUnderConstruction.remove(managedBeanName);
        }
        this.putInScope(managedBean, extContext, obj);
        return obj;
    }

    private void putInScope(ManagedBean managedBean, ExternalContext extContext, Object obj) {
        String managedBeanName = managedBean.getManagedBeanName();
        if (obj == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Variable '" + managedBeanName + "' could not be resolved."));
            }
        } else {
            String scopeKey = managedBean.getManagedBeanScope();
            Scope scope = (Scope)this._scopes.get(scopeKey);
            if (scope == null) {
                log.error((Object)("Managed bean '" + managedBeanName + "' has illegal scope: " + scopeKey));
            } else {
                scope.put(extContext, managedBeanName, obj);
            }
        }
    }

    private FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    private ExternalContext externalContext(ELContext context) {
        FacesContext facesContext = this.facesContext(context);
        return facesContext != null ? facesContext.getExternalContext() : null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        return null;
    }

    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        Map<String, ManagedBean> managedBeans = this.runtimeConfig(context).getManagedBeans();
        for (String beanName : managedBeans.keySet()) {
            descriptors.add(this.makeDescriptor(beanName, managedBeans.get(beanName)));
        }
        return descriptors.iterator();
    }

    private FeatureDescriptor makeDescriptor(String beanName, ManagedBean managedBean) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setValue("type", managedBean.getManagedBeanClass());
        fd.setName(beanName);
        fd.setDisplayName(beanName);
        fd.setShortDescription(managedBean.getDescription());
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }

    protected RuntimeConfig runtimeConfig(ELContext context) {
        FacesContext facesContext = this.facesContext(context);
        if (this.runtimeConfig == null) {
            this.runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this.runtimeConfig;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return Object.class;
    }

    static {
        s_standardScopes.put("request", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
                extContext.getRequestMap().put(name, obj);
            }
        });
        s_standardScopes.put("session", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
                extContext.getSessionMap().put(name, obj);
            }
        });
        s_standardScopes.put("application", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
                extContext.getApplicationMap().put(name, obj);
            }
        });
        s_standardScopes.put("none", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
            }
        });
    }

    static interface Scope {
        public void put(ExternalContext var1, String var2, Object var3);
    }
}

