/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.shared_impl.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigValidator {
    public static final String VALIDATE_CONTEXT_PARAM = "org.apache.myfaces.VALIDATE";

    private FacesConfigValidator() {
    }

    public static List<String> validate(ExternalContext ctx, String ctxPath) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(ctx);
        Map<String, ManagedBean> managedBeansMap = runtimeConfig.getManagedBeans();
        Iterator<ManagedBean> managedBeans = managedBeansMap == null ? null : (managedBeansMap.values() == null ? null : managedBeansMap.values().iterator());
        Iterator<NavigationRule> navRules = runtimeConfig.getNavigationRules() == null ? null : runtimeConfig.getNavigationRules().iterator();
        return FacesConfigValidator.validate(managedBeans, navRules, ctxPath);
    }

    public static List<String> validate(Iterator managedBeans, Iterator<NavigationRule> navRules, String ctxPath) {
        ArrayList<String> list = new ArrayList<String>();
        if (navRules != null) {
            FacesConfigValidator.validateNavRules(navRules, list, ctxPath);
        }
        if (managedBeans != null) {
            FacesConfigValidator.validateManagedBeans(managedBeans, list);
        }
        return list;
    }

    private static void validateNavRules(Iterator<NavigationRule> navRules, List<String> list, String ctxPath) {
        while (navRules.hasNext()) {
            NavigationRule navRule = navRules.next();
            FacesConfigValidator.validateNavRule(navRule, list, ctxPath);
        }
    }

    private static void validateNavRule(NavigationRule navRule, List<String> list, String ctxPath) {
        String fromId = navRule.getFromViewId();
        String filePath = ctxPath + fromId;
        if (fromId != null && !"*".equals(fromId) && !new File(filePath).exists()) {
            list.add("File for navigation 'from id' does not exist " + filePath);
        }
        Collection cases = navRule.getNavigationCases();
        for (NavigationCase caze : cases) {
            String toViewPath = ctxPath + caze.getToViewId();
            if (new File(toViewPath).exists()) continue;
            list.add("File for navigation 'to id' does not exist " + toViewPath);
        }
    }

    private static void validateManagedBeans(Iterator managedBeans, List<String> list) {
        while (managedBeans.hasNext()) {
            ManagedBean managedBean = (ManagedBean)managedBeans.next();
            FacesConfigValidator.validateManagedBean(managedBean, list);
        }
    }

    private static void validateManagedBean(ManagedBean managedBean, List<String> list) {
        String className = managedBean.getManagedBeanClassName();
        try {
            ClassUtils.classForName(className);
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not locate class " + className + " for managed bean '" + managedBean.getManagedBeanName() + "'";
            list.add(msg);
        }
    }
}

