/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Element;

public abstract class SOAPFactory {
    private static final String SF_PROPERTY = "javax.xml.soap.SOAPFactory";
    private static final String DEFAULT_SF = "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory";
    private static final String META_FACTORY_CLASS_NAME = "javax.xml.soap.SAAJMetaFactory";
    private static Class factoryClass = null;
    private static boolean getMetaFactoryCalled = false;
    private static Object metaFactory = null;
    private static Method newSOAPFactoryMethod = null;
    private static final String ERR_1 = "SOAPFactory could not constructed due to failure in SAAJMetaFactory.newSOAPFactory.";
    private static final String ERR_2 = "SOAPFactory could not constructed because SAAJMetaFactory could not be found.";

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public SOAPElement createElement(QName qName) throws SOAPException {
        return null;
    }

    public SOAPElement createElement(Element element) throws SOAPException {
        return null;
    }

    public abstract Detail createDetail() throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public abstract SOAPFault createFault() throws SOAPException;

    public abstract SOAPFault createFault(String var1, QName var2) throws SOAPException;

    public static synchronized SOAPFactory newInstance() throws SOAPException {
        try {
            Object var0 = null;
            if (metaFactory != null) {
                SOAPFactory sOAPFactory = SOAPFactory.getSOAPFactory(metaFactory, "SOAP 1.1 Protocol");
                if (sOAPFactory == null) {
                    throw new SOAPException(ERR_1);
                }
                return sOAPFactory;
            }
            if (factoryClass == null) {
                Object object;
                Object object2;
                String string = SF_PROPERTY;
                String string2 = DEFAULT_SF;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string3 = System.getProperty(string);
                if (string3 == null) {
                    object2 = "META-INF/services/" + string;
                    object = null;
                    object = classLoader == null ? ClassLoader.getSystemResourceAsStream((String)object2) : classLoader.getResourceAsStream((String)object2);
                    if (object != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                        string3 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                }
                if ((object2 = SOAPFactory.getMetaFactory()) != null) {
                    object = SOAPFactory.getSOAPFactory(object2, "SOAP 1.1 Protocol");
                    if (object == null) {
                        throw new SOAPException(ERR_1);
                    }
                    return object;
                }
                if (string3 == null) {
                    string3 = string2;
                }
                if (string3 == null) {
                    throw new SOAPException("Provider for " + string + " cannot be found", null);
                }
                factoryClass = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
            }
            var0 = factoryClass.newInstance();
            return var0;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.SOAPFactory.newInstance", (String)"251");
            throw new SOAPException("Unable to create SOAP Factory: " + exception.getMessage());
        }
    }

    public static SOAPFactory newInstance(String string) throws SOAPException {
        Object object = SOAPFactory.getMetaFactory();
        if (object == null) {
            throw new SOAPException(ERR_2);
        }
        SOAPFactory sOAPFactory = SOAPFactory.getSOAPFactory(object, string);
        if (sOAPFactory == null) {
            throw new SOAPException(ERR_1);
        }
        return sOAPFactory;
    }

    private static synchronized Object getMetaFactory() {
        if (getMetaFactoryCalled) {
            return metaFactory;
        }
        getMetaFactoryCalled = true;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = null;
            clazz = classLoader == null ? Class.forName(META_FACTORY_CLASS_NAME) : classLoader.loadClass(META_FACTORY_CLASS_NAME);
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            metaFactory = method.invoke(null, new Object[0]);
            Class[] classArray = new Class[]{String.class};
            newSOAPFactoryMethod = clazz.getDeclaredMethod("newSOAPFactory", classArray);
        }
        catch (Exception exception) {
            return null;
        }
        return metaFactory;
    }

    private static SOAPFactory getSOAPFactory(Object object, String string) {
        try {
            return (SOAPFactory)newSOAPFactoryMethod.invoke(object, string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

