/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.TargetedNotification;
import javax.management.remote.rmi.RMIMBeanServerConnection;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public abstract class RMIMBeanServerConnectionImpl
implements RMIMBeanServerConnection {
    private static int listenerID;
    private RMIServerImpl rmiServer;
    private HashMap listeners = new HashMap();
    private HashMap notifications = new HashMap();
    static /* synthetic */ Class class$javax$management$remote$rmi$RMIMBeanServerConnectionImpl;

    public RMIMBeanServerConnectionImpl(RMIServerImpl server, String connectionId, ClassLoader defaultClassLoader, Subject subject) {
        this.rmiServer = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotificationListener(ObjectName name, MarshalledObject filter) throws InstanceNotFoundException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = server.getClassLoaderFor(name);
        NotificationFilter unmarshalled = (NotificationFilter)this.unmarshal(filter, loader);
        Integer id = this.createNotificationListenerID();
        ConnectorServerNotificationListener listener = this.createNotificationListener(unmarshalled, id, name);
        server.addNotificationListener(name, listener, listener.getFilter(), listener.getHandback());
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.put(listener.getHandback(), listener);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, Integer[] listenerIDs) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            for (int i = 0; i < listenerIDs.length; ++i) {
                Integer id = listenerIDs[i];
                ConnectorServerNotificationListener listener = (ConnectorServerNotificationListener)this.listeners.remove(id);
                if (listener == null) {
                    throw new RuntimeException();
                }
                this.rmiServer.getMBeanServer().removeNotificationListener(name, listener, listener.getFilter(), listener.getHandback());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetedNotification[] fetchNotifications() throws RemoteException {
        LinkedList<Integer> ids = new LinkedList<Integer>();
        LinkedList<Notification> notifs = new LinkedList<Notification>();
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Iterator i = this.notifications.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Integer id = (Integer)entry.getKey();
                List nots = (List)entry.getValue();
                for (int j = 0; j < nots.size(); ++j) {
                    Notification notification = (Notification)nots.get(j);
                    ids.add(id);
                    notifs.add(notification);
                }
                i.remove();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.rmiServer.clientClosed(this);
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            Iterator i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ConnectorServerNotificationListener listener = (ConnectorServerNotificationListener)entry.getValue();
                try {
                    this.rmiServer.getMBeanServer().removeNotificationListener(listener.getObservedObjectName(), listener, listener.getFilter(), listener.getHandback());
                }
                catch (InstanceNotFoundException ignored) {
                }
                catch (ListenerNotFoundException ignored) {}
            }
            this.listeners.clear();
        }
        hashMap = this.notifications;
        synchronized (hashMap) {
            this.notifications.clear();
        }
        this.rmiServer = null;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.rmiServer.getMBeanServer().createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, MarshalledObject params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = null;
        Object[] args = (Object[])this.unmarshal(params, loader);
        return server.createMBean(className, name, args, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.rmiServer.getMBeanServer().createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, MarshalledObject params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = null;
        Object[] args = (Object[])this.unmarshal(params, loader);
        return server.createMBean(className, name, loaderName, args, signature);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.rmiServer.getMBeanServer().unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        return this.rmiServer.getMBeanServer().getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, MarshalledObject query) throws IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = null;
        QueryExp exp = (QueryExp)this.unmarshal(query, loader);
        return server.queryMBeans(name, exp);
    }

    public Set queryNames(ObjectName name, MarshalledObject query) throws IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = null;
        QueryExp exp = (QueryExp)this.unmarshal(query, loader);
        return server.queryNames(name, exp);
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        return this.rmiServer.getMBeanServer().isRegistered(name);
    }

    public Integer getMBeanCount() throws IOException {
        return this.rmiServer.getMBeanServer().getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Object value = this.rmiServer.getMBeanServer().getAttribute(name, attribute);
        return value;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList values = this.rmiServer.getMBeanServer().getAttributes(name, attributes);
        return values;
    }

    public void setAttribute(ObjectName name, MarshalledObject attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = server.getClassLoaderFor(name);
        Attribute unmarshalled = (Attribute)this.unmarshal(attribute, loader);
        server.setAttribute(name, unmarshalled);
    }

    public AttributeList setAttributes(ObjectName name, MarshalledObject attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = server.getClassLoaderFor(name);
        AttributeList unmarshalled = (AttributeList)this.unmarshal(attributes, loader);
        AttributeList values = server.setAttributes(name, unmarshalled);
        return values;
    }

    public Object invoke(ObjectName name, String operationName, MarshalledObject params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = server.getClassLoaderFor(name);
        Object[] unmarshalled = (Object[])this.unmarshal(params, loader);
        Object value = server.invoke(name, operationName, unmarshalled, signature);
        return value;
    }

    public String getDefaultDomain() throws IOException {
        return this.rmiServer.getMBeanServer().getDefaultDomain();
    }

    public String[] getDomains() throws IOException {
        return this.rmiServer.getMBeanServer().getDomains();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo info = this.rmiServer.getMBeanServer().getMBeanInfo(name);
        return info;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        return this.rmiServer.getMBeanServer().isInstanceOf(name, className);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback) throws InstanceNotFoundException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = server.getClassLoaderFor(name);
        NotificationFilter unmarshalledFilter = (NotificationFilter)this.unmarshal(filter, loader);
        Object unmarshalledHandback = this.unmarshal(handback, loader);
        server.addNotificationListener(name, listener, unmarshalledFilter, unmarshalledHandback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.rmiServer.getMBeanServer().removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServer server = this.rmiServer.getMBeanServer();
        ClassLoader loader = server.getClassLoaderFor(name);
        NotificationFilter unmarshalledFilter = (NotificationFilter)this.unmarshal(filter, loader);
        Object unmarshalledHandback = this.unmarshal(handback, loader);
        server.removeNotificationListener(name, listener, unmarshalledFilter, unmarshalledHandback);
    }

    public String getConnectionId() {
        return null;
    }

    /*
     * Exception decompiling
     */
    private Object unmarshal(MarshalledObject marshalled, ClassLoader loader) throws UnmarshalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setContextClassLoader(final ClassLoader loader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        });
    }

    private MarshalledObject marshal(Object unmarshalled) throws MarshalException {
        if (unmarshalled == null) {
            return null;
        }
        try {
            return new MarshalledObject<Object>(unmarshalled);
        }
        catch (IOException x) {
            throw new MarshalException("Cannot marshal " + unmarshalled, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer createNotificationListenerID() {
        Class clazz = class$javax$management$remote$rmi$RMIMBeanServerConnectionImpl == null ? (class$javax$management$remote$rmi$RMIMBeanServerConnectionImpl = RMIMBeanServerConnectionImpl.class$("javax.management.remote.rmi.RMIMBeanServerConnectionImpl")) : class$javax$management$remote$rmi$RMIMBeanServerConnectionImpl;
        synchronized (clazz) {
            return new Integer(++listenerID);
        }
    }

    private ConnectorServerNotificationListener createNotificationListener(NotificationFilter filter, Object handback, ObjectName name) {
        return new ConnectorServerNotificationListener(filter, handback, name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectorServerNotificationListener
    implements NotificationListener {
        private NotificationFilter filter;
        private Object handback;
        private ObjectName name;

        public ConnectorServerNotificationListener(NotificationFilter filter, Object handback, ObjectName name) {
            this.filter = filter;
            this.handback = handback;
            this.name = name;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public Object getHandback() {
            return this.handback;
        }

        public ObjectName getObservedObjectName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object handback) {
            HashMap hashMap = RMIMBeanServerConnectionImpl.this.notifications;
            synchronized (hashMap) {
                LinkedList<Notification> notifs = (LinkedList<Notification>)RMIMBeanServerConnectionImpl.this.notifications.get(handback);
                if (notifs == null) {
                    notifs = new LinkedList<Notification>();
                    RMIMBeanServerConnectionImpl.this.notifications.put(handback, notifs);
                }
                notifs.add(notification);
            }
        }
    }
}

