/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.webapp._ErrorPageWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FacesServlet
implements Servlet {
    private static final Log log = LogFactory.getLog(FacesServlet.class);
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private static final String SERVLET_INFO = "FacesServlet of the MyFaces API implementation";
    private static final String ERROR_HANDLING_PARAMETER = "org.apache.myfaces.ERROR_HANDLING";
    private static final String ERROR_HANDLER_PARAMETER = "org.apache.myfaces.ERROR_HANDLER";
    private static final String ERROR_HANDLING_EXCEPTION_LIST = "org.apache.myfaces.errorHandling.exceptionList";
    private ServletConfig _servletConfig;
    private FacesContextFactory _facesContextFactory;
    private Lifecycle _lifecycle;

    public void destroy() {
        this._servletConfig = null;
        this._facesContextFactory = null;
        this._lifecycle = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"destroy");
        }
    }

    public ServletConfig getServletConfig() {
        return this._servletConfig;
    }

    public String getServletInfo() {
        return SERVLET_INFO;
    }

    private String getLifecycleId() {
        String serLifecycleId = this._servletConfig.getInitParameter(LIFECYCLE_ID_ATTR);
        String appLifecycleId = this._servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
        appLifecycleId = serLifecycleId == null ? appLifecycleId : serLifecycleId;
        return appLifecycleId != null ? appLifecycleId : "DEFAULT";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"init begin");
        }
        this._servletConfig = servletConfig;
        this._facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        this._lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        if (log.isTraceEnabled()) {
            log.trace((Object)"init end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo != null && (pathInfo.startsWith("/WEB-INF") || pathInfo.startsWith("/META-INF"))) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(" Someone is trying to access a secure resource : ").append(pathInfo);
            buffer.append("\n remote address is ").append(httpRequest.getRemoteAddr());
            buffer.append("\n remote host is ").append(httpRequest.getRemoteHost());
            buffer.append("\n remote user is ").append(httpRequest.getRemoteUser());
            buffer.append("\n request URI is ").append(httpRequest.getRequestURI());
            log.warn((Object)buffer.toString());
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"service begin");
        }
        FacesContext facesContext = this.prepareFacesContext(request, response);
        try {
            this._lifecycle.execute(facesContext);
            this.handleQueuedExceptions(facesContext);
            this._lifecycle.render(facesContext);
        }
        catch (Exception e) {
            this.handleLifecycleException(facesContext, e);
        }
        finally {
            facesContext.release();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"service end");
        }
    }

    private void handleQueuedExceptions(FacesContext facesContext) throws FacesException {
        List li = (List)facesContext.getExternalContext().getRequestMap().get(ERROR_HANDLING_EXCEPTION_LIST);
        if (li != null && li.size() >= 1) {
            throw (FacesException)li.get(0);
        }
    }

    private void handleLifecycleException(FacesContext facesContext, Exception e) throws IOException, ServletException {
        boolean errorHandling = FacesServlet.getBooleanValue(facesContext.getExternalContext().getInitParameter(ERROR_HANDLING_PARAMETER), true);
        if (errorHandling) {
            String errorHandlerClass = facesContext.getExternalContext().getInitParameter(ERROR_HANDLER_PARAMETER);
            if (errorHandlerClass != null) {
                try {
                    Class<?> clazz = Class.forName(errorHandlerClass);
                    Object errorHandler = clazz.newInstance();
                    Method m = clazz.getMethod("handleException", FacesContext.class, Exception.class);
                    m.invoke(errorHandler, facesContext, e);
                }
                catch (ClassNotFoundException ex) {
                    throw new ServletException("Error-Handler : " + errorHandlerClass + " was not found. Fix your web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ServletException("Constructor of error-Handler : " + errorHandlerClass + " is not accessible. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                }
                catch (InstantiationException ex) {
                    throw new ServletException("Error-Handler : " + errorHandlerClass + " could not be instantiated. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new ServletException("Error-Handler : " + errorHandlerClass + " did not have a method with name : handleException and parameters : javax.faces.context.FacesContext, java.lang.Exception. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new ServletException("Excecution of method handleException in Error-Handler : " + errorHandlerClass + " caused an exception. Error-Handler is specified in web.xml-parameter : " + ERROR_HANDLER_PARAMETER, ex);
                }
            } else {
                _ErrorPageWriter.handleException(facesContext, e);
            }
        } else {
            _ErrorPageWriter.throwException(e);
        }
    }

    private static boolean getBooleanValue(String initParameter, boolean defaultVal) {
        if (initParameter == null || initParameter.trim().length() == 0) {
            return defaultVal;
        }
        return initParameter.equalsIgnoreCase("on") || initParameter.equals("1") || initParameter.equalsIgnoreCase("true");
    }

    private FacesContext prepareFacesContext(ServletRequest request, ServletResponse response) {
        FacesContext facesContext = this._facesContextFactory.getFacesContext(this._servletConfig.getServletContext(), request, response, this._lifecycle);
        return facesContext;
    }
}

