/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputLinkRenderer
extends LinkRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTPUTLINK);

    public void decode(FacesContext context, UIComponent component2) {
        this.rendererParamsNotNull(context, component2);
    }

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        UIOutput output = (UIOutput)component2;
        boolean componentDisabled = false;
        if (output.getAttributes().get("disabled") != null && output.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if (componentDisabled) {
            this.renderAsDisabled(context, output);
        } else {
            this.renderAsActive(context, output);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncodeChildren(component2)) {
            return;
        }
        if (component2.getChildCount() > 0) {
            for (UIComponent kid : component2.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (Boolean.TRUE.equals(component2.getAttributes().get("disabled"))) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Object getValue(UIComponent component2) {
        if (Util.componentIsDisabled(component2)) {
            return null;
        }
        return ((UIOutput)component2).getValue();
    }

    protected void renderAsActive(FacesContext context, UIComponent component2) throws IOException {
        String hrefVal = this.getCurrentValue(context, component2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Value to be rendered " + hrefVal);
        }
        if (!component2.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component2.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("a", component2);
        String writtenId = this.writeIdAttributeIfNecessary(context, writer, component2);
        if (null != writtenId) {
            writer.writeAttribute("name", writtenId, "name");
        }
        if (null == hrefVal || 0 == hrefVal.length()) {
            hrefVal = "";
        }
        HtmlBasicRenderer.Param[] paramList = this.getParamList(component2);
        StringBuffer sb = new StringBuffer();
        sb.append(hrefVal);
        boolean paramWritten = false;
        int len = paramList.length;
        for (int i = 0; i < len; ++i) {
            String pn = paramList[i].name;
            if (pn == null || pn.length() == 0) continue;
            String pv = paramList[i].value;
            sb.append(paramWritten ? (char)'&' : '?');
            sb.append(pn);
            sb.append('=');
            if (pv != null && pv.length() != 0) {
                sb.append(pv);
            }
            paramWritten = true;
        }
        writer.writeURIAttribute("href", context.getExternalContext().encodeResourceURL(sb.toString()), "href");
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component2);
        String target = (String)component2.getAttributes().get("target");
        if (target != null && target.trim().length() != 0) {
            writer.writeAttribute("target", target, "target");
        }
        this.writeCommonLinkAttributes(writer, component2);
        writer.flush();
    }
}

