/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.RIConstants;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuRenderer
extends HtmlBasicInputRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTMANYMENU);

    public Object convertSelectManyValue(FacesContext context, UISelectMany uiSelectMany, String[] newValues) throws ConverterException {
        ValueExpression valueExpression = uiSelectMany.getValueExpression("value");
        Object result = newValues;
        boolean throwException = false;
        if (null != valueExpression) {
            Object value;
            Class<?> modelType = valueExpression.getType(context.getELContext());
            if (modelType != null) {
                result = this.convertSelectManyValuesForModel(context, uiSelectMany, modelType, newValues);
            }
            if (result == null && (value = valueExpression.getValue(context.getELContext())) != null) {
                result = this.convertSelectManyValuesForModel(context, uiSelectMany, value.getClass(), newValues);
            }
            if (result == null) {
                throwException = true;
            }
        } else {
            result = this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues);
        }
        if (throwException) {
            StringBuffer values = new StringBuffer();
            if (null != newValues) {
                for (int i = 0; i < newValues.length; ++i) {
                    if (i == 0) {
                        values.append(newValues[i]);
                        continue;
                    }
                    values.append(' ').append(newValues[i]);
                }
            }
            Object[] params = new Object[]{values.toString(), valueExpression.getExpressionString()};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectMany Component  " + uiSelectMany.getId() + " convertedValues " + result);
        }
        return result;
    }

    public Object convertSelectOneValue(FacesContext context, UISelectOne uiSelectOne, String newValue) throws ConverterException {
        if (RIConstants.NO_VALUE.equals(newValue)) {
            return null;
        }
        if (newValue == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No conversion necessary for SelectOne Component  " + uiSelectOne.getId() + " since the new value is null ");
            }
            return null;
        }
        Object convertedValue = super.getConvertedValue(context, uiSelectOne, newValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectOne Component  " + uiSelectOne.getId() + " convertedValue " + convertedValue);
        }
        return convertedValue;
    }

    @Override
    public void decode(FacesContext context, UIComponent component2) {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldDecode(component2)) {
            return;
        }
        String clientId = component2.getClientId(context);
        assert (clientId != null);
        if (component2 instanceof UISelectMany) {
            Map<String, String[]> requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap();
            if (requestParameterValuesMap.containsKey(clientId)) {
                Object[] newValues = requestParameterValuesMap.get(clientId);
                this.setSubmittedValue(component2, newValues);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted values for UISelectMany component " + component2.getId() + " after decoding " + Arrays.toString(newValues));
                }
            } else {
                this.setSubmittedValue(component2, new String[0]);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set empty array for UISelectMany component " + component2.getId() + " after decoding ");
                }
            }
        } else {
            Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
            if (requestParameterMap.containsKey(clientId)) {
                String newValue = requestParameterMap.get(clientId);
                this.setSubmittedValue(component2, newValue);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted value for UISelectOne component " + component2.getId() + " after decoding " + newValue);
                }
            } else {
                this.setSubmittedValue(component2, RIConstants.NO_VALUE);
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        this.renderSelect(context, component2);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component2, Object submittedValue) throws ConverterException {
        if (component2 instanceof UISelectMany) {
            Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
            requestMap.put("com.sun.faces.ComponentForValue", component2);
            return this.convertSelectManyValue(context, (UISelectMany)component2, (String[])submittedValue);
        }
        return this.convertSelectOneValue(context, (UISelectOne)component2, (String)submittedValue);
    }

    protected Object convertSelectManyValuesForModel(FacesContext context, UISelectMany uiSelectMany, Class modelType, String[] newValues) {
        ArrayList<Object> result = null;
        if (modelType.isArray()) {
            result = this.convertSelectManyValues(context, uiSelectMany, modelType, newValues);
        } else if (List.class.isAssignableFrom(modelType)) {
            Object[] values = (Object[])this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues);
            ArrayList<Object> l = new ArrayList<Object>(values.length);
            for (Object v : values) {
                l.add(v);
            }
            result = l;
        }
        return result;
    }

    protected Object convertSelectManyValues(FacesContext context, UISelectMany uiSelectMany, Class arrayClass, String[] newValues) throws ConverterException {
        Object result;
        int len = null != newValues ? newValues.length : 0;
        Class<?> elementType = arrayClass.getComponentType();
        if (elementType.equals(String.class)) {
            return newValues;
        }
        try {
            result = Array.newInstance(elementType, len);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        if (null == newValues) {
            return result;
        }
        Converter converter = uiSelectMany.getConverter();
        if (null == converter && null == (converter = Util.getConverterForClass(elementType, context))) {
            if (elementType.equals(Object.class)) {
                return newValues;
            }
            StringBuffer valueStr = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    valueStr.append(newValues[i]);
                    continue;
                }
                valueStr.append(' ').append(newValues[i]);
            }
            Object[] params = new Object[]{valueStr.toString(), "null Converter"};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        assert (null != result);
        if (elementType.isPrimitive()) {
            for (int i = 0; i < len; ++i) {
                if (elementType.equals(Boolean.TYPE)) {
                    Array.setBoolean(result, i, (Boolean)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Byte.TYPE)) {
                    Array.setByte(result, i, (Byte)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Double.TYPE)) {
                    Array.setDouble(result, i, (Double)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Float.TYPE)) {
                    Array.setFloat(result, i, ((Float)converter.getAsObject(context, uiSelectMany, newValues[i])).floatValue());
                    continue;
                }
                if (elementType.equals(Integer.TYPE)) {
                    Array.setInt(result, i, (Integer)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Character.TYPE)) {
                    Array.setChar(result, i, ((Character)converter.getAsObject(context, uiSelectMany, newValues[i])).charValue());
                    continue;
                }
                if (elementType.equals(Short.TYPE)) {
                    Array.setShort(result, i, (Short)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (!elementType.equals(Long.TYPE)) continue;
                Array.setLong(result, i, (Long)converter.getAsObject(context, uiSelectMany, newValues[i]));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    Object converted = converter.getAsObject(context, uiSelectMany, newValues[i]);
                    logger.fine("String value: " + newValues[i] + " converts to : " + converted);
                }
                Array.set(result, i, converter.getAsObject(context, uiSelectMany, newValues[i]));
            }
        }
        return result;
    }

    protected void renderOption(FacesContext context, UIComponent component2, Converter converter, SelectItem curItem) throws IOException {
        String labelClass;
        Object newValue;
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.writeText("\t", component2, null);
        writer.startElement("option", component2);
        String valueString = this.getFormattedValue(context, component2, curItem.getValue(), converter);
        writer.writeAttribute("value", valueString, "value");
        Object[] submittedValues = this.getSubmittedSelectedValues(component2);
        Class type = String.class;
        if (submittedValues != null) {
            boolean containsValue = this.containsaValue(submittedValues);
            if (containsValue) {
                valuesArray = submittedValues;
                itemValue = valueString;
            } else {
                valuesArray = this.getCurrentSelectedValues(component2);
                itemValue = curItem.getValue();
            }
        } else {
            valuesArray = this.getCurrentSelectedValues(component2);
            itemValue = curItem.getValue();
        }
        if (valuesArray != null) {
            type = valuesArray.getClass().getComponentType();
        }
        Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
        requestMap.put("com.sun.faces.ComponentForValue", component2);
        try {
            newValue = context.getApplication().getExpressionFactory().coerceToType(itemValue, type);
        }
        catch (ELException ele) {
            newValue = itemValue;
        }
        catch (IllegalArgumentException iae) {
            newValue = itemValue;
        }
        boolean isSelected = this.isSelected(newValue, valuesArray);
        if (isSelected) {
            writer.writeAttribute("selected", true, "selected");
        }
        Boolean disabledAttr = (Boolean)component2.getAttributes().get("disabled");
        boolean componentDisabled = false;
        if (disabledAttr != null && disabledAttr.equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if (!componentDisabled && curItem.isDisabled()) {
            writer.writeAttribute("disabled", true, "disabled");
        }
        if ((labelClass = componentDisabled || curItem.isDisabled() ? (String)component2.getAttributes().get("disabledClass") : (String)component2.getAttributes().get("enabledClass")) != null) {
            writer.writeAttribute("class", labelClass, "labelClass");
        }
        if (curItem.isEscape()) {
            String label = curItem.getLabel();
            if (label == null) {
                label = valueString;
            }
            writer.writeText(label, component2, "label");
        } else {
            writer.write(curItem.getLabel());
        }
        writer.endElement("option");
        writer.writeText("\n", component2, null);
    }

    protected void writeDefaultSize(ResponseWriter writer, int itemCount) throws IOException {
        writer.writeAttribute("size", "1", "size");
    }

    protected boolean containsaValue(Object valueArray) {
        if (null != valueArray) {
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (value == null || value.equals(RIConstants.NO_VALUE)) continue;
                return true;
            }
        }
        return false;
    }

    protected Object getCurrentSelectedValues(UIComponent component2) {
        if (component2 instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component2;
            Object value = select.getValue();
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                int size = list.size();
                if (size > 0) {
                    return list.toArray((Object[])Array.newInstance(list.iterator().next().getClass(), size));
                }
                return ((Collection)value).toArray();
            }
            if (value != null && !value.getClass().isArray()) {
                logger.warning("The UISelectMany value should be an array or a collection type, the actual type is " + value.getClass().getName());
            }
            return value;
        }
        UISelectOne select = (UISelectOne)component2;
        Object returnObject = select.getValue();
        if (null != returnObject) {
            Object ret = Array.newInstance(returnObject.getClass(), 1);
            Array.set(ret, 0, returnObject);
            return ret;
        }
        return null;
    }

    protected String getMultipleText(UIComponent component2) {
        if (component2 instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    protected int getOptionNumber(FacesContext context, UIComponent component2, List<SelectItem> selectItems) {
        int itemCount = 0;
        if (!selectItems.isEmpty()) {
            Iterator<SelectItem> items = selectItems.iterator();
            while (items.hasNext()) {
                ++itemCount;
                SelectItem item = items.next();
                if (!(item instanceof SelectItemGroup)) continue;
                int optionsLength = ((SelectItemGroup)item).getSelectItems().length;
                itemCount += optionsLength;
            }
        }
        return itemCount;
    }

    protected Object[] getSubmittedSelectedValues(UIComponent component2) {
        if (component2 instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component2;
            return (Object[])select.getSubmittedValue();
        }
        UISelectOne select = (UISelectOne)component2;
        Object returnObject = select.getSubmittedValue();
        if (null != returnObject) {
            return new Object[]{returnObject};
        }
        return null;
    }

    protected boolean isSelected(Object itemValue, Object valueArray) {
        if (null != valueArray) {
            if (!valueArray.getClass().isArray()) {
                logger.warning("valueArray is not an array, the actual type is " + valueArray.getClass());
                return valueArray.equals(itemValue);
            }
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (!(value == null ? itemValue == null : value.equals(itemValue))) continue;
                return true;
            }
        }
        return false;
    }

    protected void renderOptions(FacesContext context, UIComponent component2, List<SelectItem> items) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        Converter converter = null;
        if (component2 instanceof ValueHolder) {
            converter = ((ValueHolder)((Object)component2)).getConverter();
        }
        if (!items.isEmpty()) {
            for (SelectItem item : items) {
                if (item instanceof SelectItemGroup) {
                    writer.startElement("optgroup", component2);
                    writer.writeAttribute("label", item.getLabel(), "label");
                    SelectItem[] itemsArray = ((SelectItemGroup)item).getSelectItems();
                    for (int i = 0; i < itemsArray.length; ++i) {
                        this.renderOption(context, component2, converter, itemsArray[i]);
                    }
                    writer.endElement("optgroup");
                    continue;
                }
                this.renderOption(context, component2, converter, item);
            }
        }
    }

    protected void renderSelect(FacesContext context, UIComponent component2) throws IOException {
        Integer size;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Rendering 'select'");
        }
        writer.startElement("select", component2);
        this.writeIdAttributeIfNecessary(context, writer, component2);
        writer.writeAttribute("name", component2.getClientId(context), "clientId");
        String styleClass = (String)component2.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        if (!this.getMultipleText(component2).equals("")) {
            writer.writeAttribute("multiple", true, "multiple");
        }
        List<SelectItem> items = RenderKitUtils.getSelectItems(context, component2);
        int itemCount = this.getOptionNumber(context, component2, items);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Rendering " + itemCount + " options");
        }
        if ((size = (Integer)component2.getAttributes().get("size")) == null || size == Integer.MIN_VALUE) {
            size = itemCount;
        }
        this.writeDefaultSize(writer, size);
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component2);
        this.renderOptions(context, component2, items);
        writer.endElement("select");
    }
}

