/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class FormRenderer
extends HtmlBasicRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.FORMFORM);
    private boolean writeStateAtEnd;

    public FormRenderer() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.writeStateAtEnd = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.WriteStateAtFormEnd);
    }

    public void decode(FacesContext context, UIComponent component2) {
        this.rendererParamsNotNull(context, component2);
        String clientId = component2.getClientId(context);
        Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "UIForm with client ID {0}, submitted", clientId);
            }
            ((UIForm)component2).setSubmitted(true);
        } else {
            ((UIForm)component2).setSubmitted(false);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        String acceptcharset;
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = component2.getClientId(context);
        writer.write(10);
        writer.startElement("form", component2);
        writer.writeAttribute("id", clientId, "clientId");
        writer.writeAttribute("name", clientId, "name");
        writer.writeAttribute("method", "post", null);
        writer.writeAttribute("action", FormRenderer.getActionStr(context), null);
        String styleClass = (String)component2.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        if ((acceptcharset = (String)component2.getAttributes().get("acceptcharset")) != null) {
            writer.writeAttribute("accept-charset", acceptcharset, "acceptcharset");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        writer.writeText("\n", component2, null);
        writer.startElement("input", component2);
        writer.writeAttribute("type", "hidden", "type");
        writer.writeAttribute("name", clientId, "clientId");
        writer.writeAttribute("value", clientId, "value");
        writer.endElement("input");
        writer.write(10);
        if (!this.writeStateAtEnd) {
            context.getApplication().getViewHandler().writeState(context);
            writer.write(10);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (this.writeStateAtEnd) {
            context.getApplication().getViewHandler().writeState(context);
        }
        writer.writeText("\n", component2, null);
        writer.endElement("form");
    }

    private static String getActionStr(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(actionURL);
    }
}

