/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.util.ToolsUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DigesterFactory {
    private static final Logger logger = ToolsUtil.getLogger("javax.enterprise.resource.webcontainer.jsf.config");
    private static final String XERCES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String XERCES_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String XERCES_SCHEMA_CONSTRAINT_VALIDATION = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final JsfEntityResolver RESOLVER = new JsfEntityResolver();
    private static final JsfErrorHandler ERROR_HANDLER = new JsfErrorHandler();
    private boolean validating;
    private static ThreadLocal versionListener = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    private DigesterFactory(boolean isValidating) {
        this.validating = isValidating;
    }

    public static DigesterFactory newInstance() {
        return DigesterFactory.newInstance(false);
    }

    public static DigesterFactory newInstance(boolean isValidating) {
        DigesterFactory result = new DigesterFactory(isValidating);
        return result;
    }

    public static DigesterFactory newInstance(boolean isValidating, VersionListener listener) {
        DigesterFactory result = new DigesterFactory(isValidating);
        if (null != listener) {
            RESOLVER.setVersionListener(listener);
            versionListener.set(listener);
        }
        return result;
    }

    public static VersionListener getVersionListener() {
        return (VersionListener)versionListener.get();
    }

    public static void releaseDigester(Digester toRelease) {
        RESOLVER.setVersionListener(null);
        versionListener.set(null);
    }

    public Digester createDigester() {
        Digester digester = new Digester();
        this.configureDigester(digester);
        return digester;
    }

    private void configureDigester(Digester digester) {
        digester.setNamespaceAware(true);
        digester.setUseContextClassLoader(true);
        digester.setEntityResolver((EntityResolver)RESOLVER);
        digester.setErrorHandler((ErrorHandler)ERROR_HANDLER);
        digester.setLogger((Log)new NoOpLog());
        if (this.validating) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Attempting to configure Digester to perform document validation.");
            }
            try {
                digester.setFeature(XERCES_VALIDATION, true);
                digester.setFeature(XERCES_SCHEMA_VALIDATION, true);
                digester.setFeature(XERCES_SCHEMA_CONSTRAINT_VALIDATION, true);
                digester.setValidating(true);
            }
            catch (SAXNotSupportedException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Attempt to set supported feature on XMLReader, but the value provided was not accepted.  Validation will be disabledb.");
                }
                digester.setValidating(false);
            }
            catch (SAXNotRecognizedException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Attempt to set unsupported feature on XMLReader necessary for validation.  Validation will bedisabled.");
                }
                digester.setValidating(false);
            }
            catch (ParserConfigurationException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Digester unable to configure underlying parser.  Validation will be disabled.");
                }
                digester.setValidating(false);
            }
        } else {
            digester.setValidating(false);
        }
    }

    private static class JsfErrorHandler
    implements ErrorHandler {
        private JsfErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static class JsfEntityResolver
    extends DefaultHandler {
        private static final String[][] DTD_SCHEMA_INFO = new String[][]{{"web-facesconfig_1_0.dtd", "/com/sun/faces/web-facesconfig_1_0.dtd"}, {"web-facesconfig_1_1.dtd", "/com/sun/faces/web-facesconfig_1_1.dtd"}, {"web-facesconfig_1_2.xsd", "/com/sun/faces/web-facesconfig_1_2.xsd"}, {"javaee_5.xsd", "/com/sun/faces/javaee_5.xsd"}, {"javaee_web_services_client_1_2.xsd", "/com/sun/faces/javaee_web_services_client_1_2.xsd"}, {"xml.xsd", "/com/sun/faces/xml.xsd"}};
        private HashMap<String, String> entities = new HashMap();
        private VersionListener versionListener;

        public JsfEntityResolver() {
            for (String[] aDTD_SCHEMA_INFO : DTD_SCHEMA_INFO) {
                URL url = this.getClass().getResource(aDTD_SCHEMA_INFO[1]);
                if (url == null) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "Unable to locate local resource '" + aDTD_SCHEMA_INFO[1] + "'.  Standard entity " + "resolution will be used when request " + "is present for '" + aDTD_SCHEMA_INFO[0] + '\'');
                    continue;
                }
                this.entities.put(aDTD_SCHEMA_INFO[0], url.toString());
            }
        }

        public void setVersionListener(VersionListener listener) {
            this.versionListener = listener;
        }

        public VersionListener getVersionListener() {
            return this.versionListener;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource source;
            String entityURL;
            if (systemId == null) {
                InputSource result;
                try {
                    result = super.resolveEntity(publicId, systemId);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
                return result;
            }
            String grammarName = systemId.substring(systemId.lastIndexOf(47) + 1);
            if (null != this.getVersionListener()) {
                this.getVersionListener().takeActionOnGrammar(grammarName);
            }
            if ((entityURL = this.entities.get(grammarName)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Unknown entity, deferring to superclass.");
                }
                try {
                    source = super.resolveEntity(publicId, systemId);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            try {
                source = new InputSource(new URL(entityURL).openStream());
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Unable to create InputSource for URL '" + entityURL + "'");
                }
                source = null;
            }
            if (source != null) {
                source.setSystemId(entityURL);
                if (publicId != null) {
                    source.setPublicId(publicId);
                }
            }
            return source;
        }
    }

    public static interface VersionListener {
        public void takeActionOnGrammar(String var1);

        public void takeActionOnArtifact(String var1);
    }
}

