/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(UsernameTokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UsernameTokenConsumer.class.getName();
    private boolean _initialized = false;
    public static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "], " + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + tokenConsumerConfig + "]."));
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = 0;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][n];
        String string2 = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][n];
        NonceManager nonceManager = (NonceManager)map.remove(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The NonceManager is " + (nonceManager == null ? "null." : "not null,")));
        }
        if (node.getNodeType() == 1) {
            UsernameToken usernameToken;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            UsernameToken usernameToken2;
            Element element = (Element)node;
            String string3 = null;
            String string4 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + string4 + "]."));
            }
            if (string4 != null) {
                string3 = element.getAttribute(string4);
            }
            Boolean bl = (Boolean)tokenConsumerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
            boolean bl2 = true;
            if (bl != null) {
                bl2 = bl;
            }
            Element element2 = null;
            element2 = !bl2 ? element : DOMUtil.clone((Element)element);
            final UsernameToken usernameToken3 = usernameToken2 = new UsernameToken(string3, null, null, element2);
            final TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    usernameToken3.setUsedTokenConsumer(tokenConsumerConfig2);
                    return null;
                }
            });
            UsernameTokenConsumer.setTokenToSubject(map, usernameToken2);
            QName qName = tokenConsumerConfig.getType();
            if (!com.ibm.ws.webservices.wssecurity.Constants.UNTOKEN.equals(qName)) {
                throw new SoapSecurityException("Unsupported value type: " + qName);
            }
            Element element3 = DOMUtil.getOneElement((Element)element, (String)string, (String)"Username");
            String string5 = null;
            if (element3 != null) {
                string5 = DOMUtil.getStringValue((Node)element3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Username [" + string5 + "]."));
            }
            element3 = DOMUtil.getOneElement((Element)element, (String)string, (String)"Password");
            char[] cArray = null;
            if (element3 != null) {
                Object object5;
                object4 = element3.getAttribute("Type");
                if (object4 != null && ((String)object4).length() > 0 && NamespaceUtil.equals((QName)(object5 = DOMUtil.getQName((Element)element3, (String)object4, (int)n)), (QName)com.ibm.ws.webservices.wssecurity.Constants.PASSWORD_DIGEST)) {
                    throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.UNSUPPORTED_SECURITY_TOKEN, "security.wssecurity.UsernameTokenConsumer.s01");
                }
                object5 = DOMUtil.getStringValue((Node)element3);
                if (object5 != null) {
                    cArray = ((String)object5).toCharArray();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(cArray == null ? "Password is null." : "Password is not null."));
            }
            object4 = UsernameTokenConsumer.checkNonce(element, tokenConsumerConfig, string, string2, nonceManager);
            usernameToken2.setDate((Date)object4);
            boolean bl3 = false;
            boolean bl4 = false;
            if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
                boolean bl5 = bl3 = tokenConsumerConfig.getTrustedIDEvaluator().evaluate(string5);
                object3 = usernameToken2;
                if (!bl3) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string5});
                }
                AccessController.doPrivileged(new PrivilegedAction((UsernameToken)object3, bl5){
                    final /* synthetic */ UsernameToken val$tokenPriv;
                    final /* synthetic */ boolean val$trustedPriv;
                    {
                        this.val$tokenPriv = usernameToken;
                        this.val$trustedPriv = bl;
                    }

                    public Object run() {
                        this.val$tokenPriv.setTrusted(this.val$trustedPriv);
                        return null;
                    }
                });
            }
            if (!bl3) {
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                object3 = wSSConsumerConfig.getCallers();
                object2 = com.ibm.ws.webservices.wssecurity.Constants.UNTOKEN;
                if (object3 != null) {
                    object = object3.iterator();
                    while (object.hasNext()) {
                        WSSConsumerConfig.CallerConfig callerConfig = (WSSConsumerConfig.CallerConfig)object.next();
                        QName qName2 = callerConfig.getTokenType();
                        WSSConsumerConfig.CallerConfig callerConfig2 = callerConfig.getTrustMethod();
                        if (!qName2.equals(object2) || callerConfig2 != null) continue;
                        bl4 = true;
                        break;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("delayLogin=" + bl4));
            }
            if ((usernameToken = UsernameTokenConsumer.invokeLoginModule(tokenConsumerConfig, string5, cArray, sOAPMessageContext, map, bl4)) != null) {
                string5 = usernameToken.getUsername();
                object3 = usernameToken;
                cArray = (char[])AccessController.doPrivileged(new PrivilegedAction((UsernameToken)object3){
                    final /* synthetic */ UsernameToken val$retTokenPriv;
                    {
                        this.val$retTokenPriv = usernameToken;
                    }

                    public Object run() {
                        return this.val$retTokenPriv.getPassword();
                    }
                });
            }
            object3 = usernameToken2;
            object2 = string5;
            object = cArray;
            AccessController.doPrivileged(new PrivilegedAction((UsernameToken)object3, (String)object2, (char[])object){
                final /* synthetic */ UsernameToken val$tokenSetUsernamePriv;
                final /* synthetic */ String val$usernamePriv;
                final /* synthetic */ char[] val$passwordPriv;
                {
                    this.val$tokenSetUsernamePriv = usernameToken;
                    this.val$usernamePriv = string;
                    this.val$passwordPriv = cArray;
                }

                public Object run() {
                    this.val$tokenSetUsernamePriv.setUsername(this.val$usernamePriv);
                    this.val$tokenSetUsernamePriv.setPassword(this.val$passwordPriv);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + usernameToken2 + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + node.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target, Map context)");
        }
    }

    protected static UsernameToken invokeLoginModule(TokenConsumerConfig tokenConsumerConfig, String string, char[] cArray, SOAPMessageContext sOAPMessageContext, Map map, boolean bl) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invokeLoginModule(TokenConsumerConfig config,String username[" + string + "]," + "char[] password[" + (cArray == null ? "null" : "not null") + "]," + "SOAPMessageContext messageContext," + "Map context," + "boolean delayLogin[" + bl + "])"));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (sOAPMessageContext != null) {
            hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
        }
        if (bl) {
            hashMap.put(_DISABLE_REGISTRY_CHECK, "true");
        }
        if (tokenConsumerConfig.getJAASConfigProperties() != null) {
            hashMap.putAll(tokenConsumerConfig.getJAASConfigProperties());
        }
        final String string2 = tokenConsumerConfig.getJAASConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JAAS config name is " + string2 + "."));
        }
        if (string2 == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurityJAAS Config entry is missing. Check your configuration.");
        }
        final WSCallbackHandlerFactoryImpl wSCallbackHandlerFactoryImpl = new WSCallbackHandlerFactoryImpl();
        final String string3 = string;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                wSCallbackHandlerFactoryImpl.setUsername(string3);
                return null;
            }
        });
        if (cArray != null) {
            object = cArray;
            AccessController.doPrivileged(new PrivilegedAction((char[])object){
                final /* synthetic */ char[] val$passwordPriv;
                {
                    this.val$passwordPriv = cArray;
                }

                public Object run() {
                    wSCallbackHandlerFactoryImpl.setPassword(this.val$passwordPriv);
                    return null;
                }
            });
        }
        wSCallbackHandlerFactoryImpl.setProperties(hashMap);
        object = wSCallbackHandlerFactoryImpl.newCallbackHandler();
        if (tc.isDebugEnabled()) {
            if (object != null) {
                Tr.debug((TraceComponent)tc, (String)("Callback handler (" + object.getClass().getName() + ") is [" + object + "]."));
            } else {
                Tr.debug((TraceComponent)tc, (String)"Callback handler is null");
            }
        }
        LoginContext loginContext = null;
        final Map map2 = map;
        try {
            loginContext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction((CallbackHandler)object){
                final /* synthetic */ CallbackHandler val$handler;
                {
                    this.val$handler = callbackHandler;
                }

                public Object run() throws LoginException {
                    Subject subject = (Subject)map2.get("com.ibm.wsspi.wssecurity.core.subject");
                    return new LoginContext(string2, subject, this.val$handler);
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to construct the login context.");
            }
            loginContext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to login.");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Object object2;
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                object2 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_PRIVILEDGE_ACTION_EXCEPTION, privilegedActionException.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object2, "AuthnType", tokenConsumerConfig.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData((Map)object2, string2, "FAILURE");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
            }
            object2 = (LoginException)privilegedActionException.getCause();
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s01", (Throwable)object2);
        }
        catch (LoginException loginException) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                Map map3 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, loginException.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map3, "AuthnType", tokenConsumerConfig.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData(map3, string2, "SUCCESS");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
            }
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s02", (Throwable)loginException);
        }
        UsernameToken usernameToken = (UsernameToken)hashMap.get(Constants.WSSECURITY_TOKEN_LOGININFO);
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            Map map4 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map4, "AuthnType", tokenConsumerConfig.getType().toString());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map4, "TokenId", usernameToken.getId());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map4, "Username", string);
            WSSAuditEventGeneratorImpl.getInstance().addProviderData(map4, string2, "SUCCESS");
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("invokeLoginModule(TokenConsumerConfig config,UsernameToken token,SOAPMessageContext messageContext,Map context,boolean delayLogin) returns UsernameToken [" + usernameToken + "]"));
        }
        return usernameToken;
    }

    private static void setTokenToSubject(Map map, UsernameToken usernameToken) {
        TokenManager.setToken((Map)map, (Token)usernameToken);
    }

    protected static Date checkNonce(Element element, TokenConsumerConfig tokenConsumerConfig, String string, String string2, NonceManager nonceManager) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkNonce(Element target[" + DOMUtil.getDisplayName((Node)element) + "], " + "TokenConsumerConfig config," + "String nsWsse," + "String nsWsu," + "NonceManager nmanager)"));
        }
        Map map = tokenConsumerConfig.getProperties();
        boolean bl = false;
        Object v = map.get(Constants.WSSECURITY_VERIFY_TIMESTAMP);
        if (v != null) {
            bl = ConfigUtil.isTrue((String)v.toString());
        }
        boolean bl2 = false;
        v = map.get(Constants.WSSECURITY_VERIFY_NONCE);
        if (v != null) {
            bl2 = ConfigUtil.isTrue((String)v.toString());
        }
        int n = -1;
        v = map.get(Constants.WSSECURITY_NONCE_MAX_AGE);
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        int n2 = -1;
        v = map.get(Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        if (v != null && v instanceof Long) {
            n2 = (Integer)v;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isTimestampRequired is [" + bl + "]."));
            Tr.debug((TraceComponent)tc, (String)("isNonceRequired is [" + bl2 + "]."));
            Tr.debug((TraceComponent)tc, (String)("nonceMaxAge is [" + n + "]."));
            Tr.debug((TraceComponent)tc, (String)("nonceClockSkew is [" + n2 + "]."));
        }
        Date date = null;
        if (bl) {
            element2 = DOMUtil.getChildElement((Element)element, (String)string2, (String)"Created");
            date = NonceUtil.checkNonceTimestamp((Element)element2, (String)string2, (int)n, (int)n2);
        }
        if (bl2) {
            element2 = DOMUtil.getChildElement((Element)element, (String)string, (String)"Nonce");
            NonceUtil.checkNonce((Element)element2, (String)string, (NonceManager)nonceManager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkNonce(Element target, TokenConsumerConfig config,String nsWsse,String nsWsu,NonceManager nmanager) returns Date[" + date + "]"));
        }
        return date;
    }
}

