/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(LTPATokenGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        boolean bl;
        Object object;
        Object object2;
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        TokenGeneratorConfig tokenGeneratorConfig = (TokenGeneratorConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenGeneratorConfig [" + tokenGeneratorConfig + "]."));
        }
        if ((qName = tokenGeneratorConfig.getType()) == null) {
            qName = com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No token value type defined in the Token Generator configuration, defualt [" + com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN.toString() + "] is used."));
            }
        } else if (!qName.equals(com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN) && !qName.equals(com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN_PROPAGATION)) {
            String string = com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN.toString() + ", " + com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN_PROPAGATION.toString();
            throw SoapSecurityException.format("security.wssecurity.WSEC0160E", new String[]{qName.toString(), clsName, string});
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = 0;
        Object object32 = null;
        object32 = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (object32 != null && object32 instanceof Integer) {
            n = (Integer)object32;
        }
        boolean bl2 = tokenGeneratorConfig.isStandAlone();
        CallbackHandlerConfig callbackHandlerConfig = tokenGeneratorConfig.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + tokenGeneratorConfig + "]."));
        }
        byte[] byArray = null;
        if (callbackHandlerConfig != null) {
            Serializable serializable;
            Object object4;
            Object object5;
            Callback[] callbackArray;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoking callback handler...");
            }
            object2 = new HashMap<String, Object>();
            String string = callbackHandlerConfig.getClassName();
            object = callbackHandlerConfig.getInstance();
            if (object == null) {
                block29: {
                    try {
                        callbackArray = callbackHandlerConfig.getUserId();
                        object5 = callbackHandlerConfig.getUserPassword();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Default username is [" + (String)callbackArray + "]."));
                            Tr.debug((TraceComponent)tc, (String)"password is [XXXXXXXX].");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Instantiating the callback handler [" + (String)string + "]..."));
                        }
                        object4 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        serializable = null;
                        serializable = object4 != null ? ((ClassLoader)object4).loadClass(string) : Class.forName(string);
                        if (CallbackHandler.class.isAssignableFrom((Class<?>)serializable)) {
                            object2.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", callbackHandlerConfig);
                            Constructor<?> constructor = ((Class)serializable).getConstructor(String.class, char[].class, Map.class);
                            object = (CallbackHandler)constructor.newInstance(callbackArray, object5, object2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Succeeded to Instantiate the callback handler [" + (String)string + "]."));
                            }
                            break block29;
                        }
                        throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", string, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        throw soapSecurityException;
                    }
                    catch (Exception exception) {
                        Tr.processException((Throwable)exception, (String)(clsName + ".invoke"), (String)"237");
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s01", (Object)new Object[]{string, exception});
                        throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", string, (Throwable)exception);
                    }
                }
                callbackHandlerConfig.setInstance((CallbackHandler)object);
            }
            object2 = new HashMap();
            if (sOAPMessageContext != null) {
                object2.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
                object2.put("com.ibm.ws.webservices.wssecurity.constants.wssecurityContext", map);
                object2.put("com.ibm.ws.webservices.wssecurity.constants.tokenType", qName);
            }
            callbackArray = new Callback[]{new BinaryTokenCallback("BinaryTokenCallback: "), new PropertyCallback((Map)object2)};
            try {
                object5 = object;
                AccessController.doPrivileged(new PrivilegedExceptionAction((CallbackHandler)object5, callbackArray){
                    final /* synthetic */ CallbackHandler val$_handler;
                    final /* synthetic */ Callback[] val$callbacks;
                    {
                        this.val$_handler = callbackHandler;
                        this.val$callbacks = callbackArray;
                    }

                    public Object run() throws PrivilegedActionException {
                        try {
                            this.val$_handler.handle(this.val$callbacks);
                        }
                        catch (Exception exception) {
                            throw new PrivilegedActionException(exception);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                object4 = privilegedActionException;
                if (((Throwable)object4).getCause() != null && ((Throwable)(object4 = ((Throwable)object4).getCause())).getCause() != null) {
                    object4 = ((Throwable)object4).getCause();
                }
                Tr.processException((Throwable)privilegedActionException, (String)(clsName + ".invoke"), (String)"289");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{string, object4});
                serializable = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", string, (Throwable)object4);
                ((Throwable)serializable).initCause(privilegedActionException);
                throw serializable;
            }
            byArray = ((BinaryTokenCallback)callbackArray[0]).getCredToken();
        }
        if (byArray == null || byArray.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSEC0161E");
        }
        map.remove(Constants.WSSECURITY_KEY_EMBID);
        map.remove(Constants.WSSECURITY_KEY_REFERENCE);
        map.remove(Constants.WSSECURITY_KEY_ID);
        map.remove(Constants.WSSECURITY_KEY_NAME);
        map.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        map.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        object2 = null;
        if (bl2 && sOAPMessageContext != null && (object32 = sOAPMessageContext.getProperty(Constants.WSSECURITY_TOKEN_PROPERGATION)) != null && object32 instanceof Set) {
            for (Object object32 : (Set)object32) {
                if (!(object32 instanceof TokenId) || !qName.equals((object = (TokenId)object32).getType())) continue;
                if (object2 == null) {
                    object2 = object.getId();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("More than one TokenId objects are found. Since the runtime tentatively uses the first identifier + \"" + (String)object2 + "\"," + " it neglects the identifier \"" + object.getId() + "\"."));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenIdentifier [" + object2 + "]."));
        }
        if (!(bl = LTPATokenGenerator.checkToken(map, tokenGeneratorConfig, byArray))) {
            object = LTPATokenGenerator.createTokenElement(document, element, tokenGeneratorConfig, byArray, object2, n);
            object = (Element)element.insertBefore((Node)object, element.getFirstChild());
            LTPATokenGenerator.setTokenToSubject(map, tokenGeneratorConfig, byArray, object2, (Element)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static boolean checkToken(Map map, TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkToken(Map context,TokenGeneratorConfig config,byte[] credToken)");
        }
        boolean bl = false;
        Set set = TokenManager.getTokens((Map)map);
        if (set != null && set.size() > 0) {
            int n = 0;
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                n = 31 * n + byArray[i];
            }
            String string = String.valueOf(n);
            for (Object e : set) {
                LTPAToken lTPAToken;
                if (!(e instanceof LTPAToken) || !(lTPAToken = (LTPAToken)e).getUsedTokenGenerator().equals(tokenGeneratorConfig) || !lTPAToken.getUniqueID().equals(string)) continue;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,byte[] credToken) returns boolean[" + bl + "]"));
        }
        return bl;
    }

    private static Element createTokenElement(Document document, Element element, TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray, String string, int n) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTokenElement(Document doc[" + document + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "TokenGeneratorConfig config," + "byte[] credToken," + "String id[" + string + "]," + "int wssVersion[" + n + "])"));
        }
        String string2 = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][n];
        String string3 = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][n];
        boolean bl = false;
        String string4 = null;
        if (element != null) {
            string4 = DOMUtil.getNamespacePrefix((Element)element, (String)string2);
        }
        if (string4 == null) {
            bl = true;
            string4 = "wsse:";
        } else if (string4.length() > 0) {
            string4 = string4 + ":";
        }
        Element element2 = document.createElementNS(string2, string4 + "BinarySecurityToken");
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string2);
        }
        if (string != null) {
            bl = false;
            object = DOMUtil.getNamespacePrefix((Element)element, (String)string3);
            if (object == null) {
                bl = true;
                object = "wsu:";
            } else if (string4.length() > 0) {
                object = (String)object + ":";
            }
            if (bl) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", string3);
            }
            element2.setAttributeNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSU, (String)object + "Id", string);
        }
        if ((object = tokenGeneratorConfig.getType()) == null) {
            object = com.ibm.ws.webservices.wssecurity.Constants.LTPA_TOKEN;
        }
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsst", ((QName)object).getNamespaceURI());
        DOMUtil.setQNameAttr((Element)element2, null, (String)"ValueType", (QName)object, (int)n);
        String string5 = Base64.encode((byte[])byArray);
        element2.appendChild(document.createTextNode(string5));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTokenElement(Document doc,Element parent,TokenGeneratorConfig config,byte[] credToken,String id,int wssVersion) returns Element[" + element2 + "]"));
        }
        return element2;
    }

    private static void setTokenToSubject(Map map, TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray, String string, Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenToSubject(Map context,TokenGeneratorConfig config,byte[] credToken[" + byArray + "]," + "String id[" + string + "]," + "Element elem[" + DOMUtil.getDisplayName((Node)element) + "])"));
        }
        LTPAToken lTPAToken = new LTPAToken(string, byArray);
        lTPAToken.setElement(element);
        lTPAToken.setReferenced(!tokenGeneratorConfig.isStandAlone());
        lTPAToken.setUsedTokenGenerator(tokenGeneratorConfig);
        TokenManager.setToken((Map)map, (Token)lTPAToken);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenToSubject(Map context,TokenGeneratorConfig config,byte[] credToken,String id,Element elem)");
        }
    }
}

