/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.Registry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;

public abstract class EndpointReferenceManager
extends com.ibm.websphere.wsaddressing.EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.wsspi.wsaddressing.EndpointReferenceManager";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceManager.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    protected static final EndpointReferenceManager _endpointReferenceManager;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";

    protected abstract EndpointReference createConcreteEndpointReference(SOAPElement var1) throws EndpointReferenceCreationException;

    protected static EndpointReferenceManager getWsspiEPRManager() {
        return _endpointReferenceManager;
    }

    public static EndpointReference createEndpointReference(SOAPElement sOAPElement) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", sOAPElement);
        }
        EndpointReference endpointReference = null;
        if (com.ibm.websphere.wsaddressing.EndpointReferenceManager.getEPRManager() != null) {
            endpointReference = EndpointReferenceManager.getWsspiEPRManager().createConcreteEndpointReference(sOAPElement);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    public static URI getURIForEndpoint(QName qName, String string) throws URIGenerationException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string};
            Tr.entry(TRACE_COMPONENT, "getURIForEndpoint", objectArray);
        }
        objectArray = null;
        if (com.ibm.websphere.wsaddressing.EndpointReferenceManager.getEPRManager() != null) {
            objectArray = EndpointReferenceManager.getWsspiEPRManager().getConcreteURIForEndpoint(qName, string);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getURIForEndpoint", objectArray);
        }
        return objectArray;
    }

    public static EndpointReference createEndpointReference(URI uRI) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", uRI);
        }
        EndpointReference endpointReference = null;
        endpointReference = EndpointReferenceManager.getWsspiEPRManager().createConcreteEndpointReference(uRI);
        Object[] objectArray = new Object[]{endpointReference};
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", objectArray);
        }
        return endpointReference;
    }

    public static EndpointReference createEndpointReference(AttributedURI attributedURI) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", attributedURI);
        }
        EndpointReference endpointReference = null;
        endpointReference = EndpointReferenceManager.getWsspiEPRManager().createConcreteEndpointReference(attributedURI);
        Object[] objectArray = new Object[]{endpointReference};
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", objectArray);
        }
        return endpointReference;
    }

    public static SOAPElement getSOAPElementReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", qName);
        }
        SOAPElement sOAPElement = Registry.getCombinedReferenceParameterReader().getSOAPElementReferenceParameterFromMessageContext(qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", sOAPElement);
        }
        return sOAPElement;
    }

    protected abstract EndpointReference createConcreteEndpointReference(URI var1) throws EndpointReferenceCreationException;

    protected abstract EndpointReference createConcreteEndpointReference(AttributedURI var1) throws EndpointReferenceCreationException;

    protected abstract URI getConcreteURIForEndpoint(QName var1, String var2) throws URIGenerationException;

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new concrete EndpointReferenceManager instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"1:1.16:285");
    }

    static {
        EndpointReferenceManager endpointReferenceManager = null;
        try {
            endpointReferenceManager = (EndpointReferenceManager)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            EndpointReferenceManager.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            EndpointReferenceManager.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            EndpointReferenceManager.traceAndFFDCException(classNotFoundException);
        }
        _endpointReferenceManager = endpointReferenceManager;
    }
}

