/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.ByteBufferWriter;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedServletOutputStream
extends WSServletOutputStream
implements ByteBufferWriter {
    protected OutputStream out;
    protected byte[] buf = new byte[0];
    protected int count;
    protected int total;
    protected int limit;
    protected IResponse response;
    protected int length = -1;
    protected IOutputStreamObserver obs;
    protected boolean _hasWritten;
    protected boolean _hasFlushed;
    protected IOException except;
    protected boolean committed;
    private int bufferSize;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.BufferedServletOutputStream";
    private boolean closeOnClose = false;
    private List<IOutputStreamObserver> obsList;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public BufferedServletOutputStream(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "BufferedServletOutputStream", "Constructor --> " + size);
        }
        this.buf = new byte[size];
        this.bufferSize = size;
        this._hasWritten = false;
        this._hasFlushed = false;
    }

    public BufferedServletOutputStream() {
        this(1024);
    }

    public void init(OutputStream out, int bufSize) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "init", out);
        }
        this.initNewBuffer(out, bufSize);
    }

    void initNewBuffer(OutputStream out, int bufSize) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "initNewBuffer --> " + bufSize);
        }
        this.out = out;
        if (bufSize != this.buf.length) {
            this.bufferSize = bufSize;
            this.buf = new byte[this.bufferSize];
        }
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "finish", "finish");
        }
        if (this.length == -1 && this.total != 0) {
            this.length = this.total;
        }
        this.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "reset", "reset");
        }
        this.out = null;
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.committed = false;
        this._hasWritten = false;
        this._hasFlushed = false;
        this.except = null;
        this.response = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setObserver(IOutputStreamObserver obs) {
        this.obs = obs;
        this.limit = -1;
    }

    public void addObserver(IOutputStreamObserver obs) {
        if (obs == null) {
            this.obs = obs;
        } else {
            if (this.obsList == null) {
                this.obsList = new ArrayList<IOutputStreamObserver>();
            }
            this.obsList.add(obs);
        }
    }

    public boolean isCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "isCommitted: " + this.committed);
        }
        return this.committed;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    public void write(int b) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "write --> " + b);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            if (this.obsList != null) {
                for (int i = 0; i < this.obsList.size(); ++i) {
                    this.obsList.get(i).alertFirstWrite();
                }
            } else {
                this.obs.alertFirstWrite();
            }
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (this.count == this.buf.length) {
            this.response.setFlushMode(false);
            this.flushBytes();
            this.response.setFlushMode(true);
        }
        this.buf[this.count++] = (byte)b;
        ++this.total;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "write len --> " + len);
        }
        if (len < 0) {
            logger.logp(Level.SEVERE, CLASS_NAME, "write", "Illegal.Argument.Trying.to.write.chars");
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            if (this.obsList != null) {
                for (int i = 0; i < this.obsList.size(); ++i) {
                    this.obsList.get(i).alertFirstWrite();
                }
            } else {
                this.obs.alertFirstWrite();
            }
        }
        if (this.limit > -1 && this.total + len > this.limit) {
            len = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        if (len >= this.buf.length) {
            this.response.setFlushMode(false);
            this.flushBytes();
            this.total += len;
            this.writeOut(b, off, len);
            this.response.setFlushMode(true);
            this.check();
            return;
        }
        int avail = this.buf.length - this.count;
        if (len > avail) {
            this.response.setFlushMode(false);
            this.flushBytes();
            this.response.setFlushMode(true);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
        this.total += len;
        this.check();
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flush", "flush");
        }
        this.flushBytes();
    }

    protected void flushBytes() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flushBytes", "flushBytes");
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            if (this.obsList != null) {
                for (int i = 0; i < this.obsList.size(); ++i) {
                    this.obsList.get(i).alertFirstFlush();
                }
            } else {
                this.obs.alertFirstFlush();
            }
        }
        this.committed = true;
        if (this.count > 0) {
            this.writeOut(this.buf, 0, this.count);
            this.count = 0;
        } else if (this.count == 0) {
            if (this.response != null && this.response.getFlushMode()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "flushBytes", "Count 0 still flush mode is true , forceful flush");
                }
                this.response.flushBufferedContent();
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "flushBytes", "flush mode is false");
            }
        }
    }

    public void print(String s) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "print", "print --> " + s);
        }
        if (s != null) {
            if (!this._hasWritten && this.obs != null) {
                this._hasWritten = true;
                if (this.obsList != null) {
                    for (int i = 0; i < this.obsList.size(); ++i) {
                        this.obsList.get(i).alertFirstWrite();
                    }
                } else {
                    this.obs.alertFirstWrite();
                }
            }
            int len = s.length();
            if (this.limit > -1 && this.total + len > this.limit) {
                len = this.limit - this.total;
                this.except = new WriteBeyondContentLengthException();
            }
            int off = 0;
            while (len > 0) {
                int n = this.buf.length - this.count;
                if (n == 0) {
                    this.response.setFlushMode(false);
                    this.flushBytes();
                    this.response.setFlushMode(true);
                    n = this.buf.length - this.count;
                }
                if (n > len) {
                    n = len;
                }
                s.getBytes(off, off + n, this.buf, this.count);
                this.count += n;
                this.total += n;
                off += n;
                len -= n;
            }
            this.check();
        }
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "close", "close");
        }
        this.finish();
        try {
            this.out.close();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.webcontainer.srt.BufferedServletOutputStream.close", (String)"415", (Object)this);
        }
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public void setResponse(IResponse resp) {
        this.response = resp;
    }

    protected void writeOut(byte[] buf, int offset, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "writeOut", "writeOut len --> " + len);
        }
        this.out.write(buf, offset, len);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setBufferSize", "setBufferSize --> " + size);
        }
        if (this.total > 0) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setBufferSize", "setBufferSize(): illegal state--> already wrote " + this.total + " bytes");
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, size);
    }

    public void clearBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clearBuffer", "clearBuffer");
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "clearBuffer", "clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException("clearBuffer(): illegal state--> stream is committed ");
        }
        this.total = 0;
        this.count = 0;
        this._hasWritten = false;
    }

    public void flushBuffer() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "flushBuffer");
        }
        this.flush();
    }

    public void writeByteBuffer(WsByteBuffer[] buf) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "writeByteBuffer");
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            this.obs.alertFirstFlush();
        }
        this.committed = true;
        ((ByteBufferWriter)((Object)this.out)).writeByteBuffer(buf);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "writeByteBuffer");
        }
    }
}

