/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.profile.prereqtree.OperatorExpressionTree;
import com.ibm.ws.profile.prereqtree.WSProfileDisabledAction;
import com.ibm.ws.profile.prereqtree.WSProfileTemplateExpressionTree;
import com.ibm.ws.profile.prereqtree.WSProfileTemplatePrereqData;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.PrereqTreeUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileEmptyTemplate;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.prereqtree.GenericExpressionTree;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileTemplate {
    protected File m_fileTemplatePath = null;
    protected File m_fileTemplateMetadata = null;
    protected File m_fileResourceBundleJarPath = null;
    protected ResourceBundle m_resourceBundle = null;
    protected Date m_buildDate = null;
    protected String m_sNameKey = null;
    protected String m_sShortDescriptionKey = null;
    protected String m_sLongDescriptionKey = null;
    protected String m_sType = null;
    protected String m_sVersion = null;
    protected boolean m_fIsAugmentTemplate = false;
    protected boolean m_fIsCreateTemplate = false;
    protected boolean m_fIsRepeatable = true;
    protected boolean m_fIsUnaugmentable = false;
    protected boolean m_fIsDisplayed = true;
    protected boolean m_fIsStrictlyValidated = false;
    protected int m_iSize;
    protected Vector<String> m_vNameParms = null;
    protected Vector<String> m_vShortDescriptionParms = null;
    protected Vector<String> m_vLongDescriptionParms = null;
    protected Vector<String> m_vDisabledActions = null;
    private GenericExpressionTree m_expTreePrereqData = null;
    private GenericExpressionTree m_completePrereqExpressionTree = null;
    private static final String S_DATE_FORMAT = "MM/dd/yy";
    private static final String S_JAR_FILE_PATTERN = "^.*\\.jar$";
    private static final int N_ONE = 1;
    private static final int N_MAX_PARMS_PER_MESSAGE_KEY = 10;
    private static final String S_WAS_HOME_REGEX_TOKEN = "\\$\\{WAS_HOME\\}";
    private static final String S_TAG_RESOURCE_BUNDLE = "resourceBundle";
    private static final String S_TAG_JAR_PATH = "path";
    private static final String S_TAG_RESOURCE_BUNDLE_NAME = "baseName";
    private static final String S_TAG_NAME_KEY = "name";
    private static final String S_TAG_TYPE = "type";
    private static final String S_TAG_VERSION = "version";
    private static final String S_TAG_SHORT_DESCRIPTION_KEY = "shortDescription";
    private static final String S_TAG_LONG_DESCRIPTION_KEY = "longDescription";
    private static final String S_TAG_BUILD_DATE = "buildDate";
    private static final String S_TAG_IS_CREATE_TEMPLATE = "isCreateTemplate";
    private static final String S_TAG_IS_AUGMENT_TEMPLATE = "isAugmentTemplate";
    private static final String S_TAG_IS_REPEATABLE = "isRepeatable";
    private static final String S_TAG_IS_UNAUGMENTABLE = "isUnaugmentable";
    private static final String S_TAG_IS_DISPLAYED = "isDisplayed";
    private static final String S_TAG_IS_STRICTLY_VALIDATED = "enableStrictArgumentValidation";
    private static final String S_TAG_SIZE = "size";
    private static final String S_TAG_MSG_KEY_ARG_PREFIX = "arg";
    private static final String S_TAG_TEMPLATE_PREREQ = "prerequisiteTemplate";
    private static final String S_TAG_TEMPLATE_PATH = "template";
    private static final String S_TAG_DISABLE_ACTION = "disableAction";
    private static final String[] OPTIONAL_ARGUMENTS = new String[]{"prerequisiteTemplate", "isRepeatable", "enableStrictArgumentValidation", "isUnaugmentable", "isDisplayed"};
    private static final String S_TEMPLATE_NOT_FOUND = "Profile template not found: ";
    private static final String S_TEMPLATE_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.templateNotFound";
    private static final String S_TEMPLATE_METADATA_NOT_FOUND = "Profile template metadata not found. ";
    private static final String S_TEMPLATE_METADATA_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.templateMetadataNotFound";
    private static final String S_TEMPLATE_BUNDLE_NOT_FOUND = "Template resource bundle not found: ";
    private static final String S_TEMPLATE_BUNDLE_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.bundleNotFound";
    private static final String S_REQUIRED_ARGUMENT_NOT_FOUND = "Required argument not found: ";
    private static final String S_REQUIRED_ARGUMENT_NOT_FOUND_KEY = "WSProfile.WSProfileTemplate.requiredArgumentNotFound";
    private static final String S_DOCUMENT_READ_TAG_ERROR = "Error reading template information: ";
    private static final String S_DOCUMENT_READ_TAG_ERROR_KEY = "WSProfile.WSProfileTemplate.documentReadTagError";
    private static final String S_METADATA_PARSING_ERROR = "Error while parsing template metadata.";
    private static final String S_METADATA_PARSING_ERROR_KEY = "WSProfile.WSProfileTemplate.metadataParsingError";
    private static final String S_TEMPLATE_UNABLE_TO_LOAD_JAR = "Unable to load the specified Jar file.";
    private static final String S_TEMPLATE_UNABLE_TO_LOAD_JAR_KEY = "WSProfile.WSProfileTemplate.unableToLoadJar";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileTemplate.class);
    private static final String S_CLASS_NAME = WSProfileTemplate.class.getName();

    public WSProfileTemplate(File fileTemplatePath) throws WSProfileException {
        this.m_fileTemplatePath = FileUtils.getNormalizedPath(fileTemplatePath);
        this.m_fileTemplateMetadata = new File(FileUtils.getNormalizedPath(fileTemplatePath), "templateMetadata.xml");
        this.validateProfileTemplateOnFileSystem();
        this.parseTemplateMetadata();
    }

    public WSProfileTemplate(String sTemplatePath) throws WSProfileException {
        this(new File(sTemplatePath));
    }

    protected WSProfileTemplate() {
    }

    public String toString() {
        return this.getType();
    }

    public File getProfileTemplatePath() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getProfileTemplatePath");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getProfileTemplatePath");
        return this.m_fileTemplatePath;
    }

    public Date getBuildDate() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getBuildDate");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getBuildDate");
        return this.m_buildDate;
    }

    public String getShortDescription() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getShortDescription");
        String sShortDescription = null;
        if (this.m_vShortDescriptionParms.isEmpty()) {
            sShortDescription = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sShortDescriptionKey, this.m_resourceBundle);
        } else {
            String[] saParms = this.m_vShortDescriptionParms.toArray(new String[this.m_vShortDescriptionParms.size()]);
            sShortDescription = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sShortDescriptionKey, saParms, this.m_resourceBundle);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getShortDescription");
        return sShortDescription;
    }

    public String getLongDescription() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getLongDescription");
        String sLongDescription = null;
        if (this.m_vLongDescriptionParms.isEmpty()) {
            sLongDescription = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sLongDescriptionKey, this.m_resourceBundle);
        } else {
            String[] saParms = this.m_vLongDescriptionParms.toArray(new String[this.m_vLongDescriptionParms.size()]);
            sLongDescription = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sLongDescriptionKey, saParms, this.m_resourceBundle);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getLongDescription");
        return sLongDescription;
    }

    public String getName() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getName");
        String sName = null;
        if (this.m_vNameParms.isEmpty()) {
            sName = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sNameKey, this.m_resourceBundle);
        } else {
            String[] saParms = this.m_vNameParms.toArray(new String[this.m_vNameParms.size()]);
            sName = ResourceBundleUtils.getResourceBundleLocaleString(this.m_sNameKey, saParms, this.m_resourceBundle);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getName");
        return sName;
    }

    public String getType() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getType");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getType");
        return this.m_sType;
    }

    public String getVersion() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getVersion");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getVersion");
        return this.m_sVersion;
    }

    public int getSize() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getSize");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getSize");
        return this.m_iSize;
    }

    public File getPrereqTemplatePath() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
        GenericExpressionTree prereqTree = this.getPrereqTemplateTree();
        if (prereqTree == null) {
            LOGGER.exiting(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
            return null;
        }
        Vector<GenericExpressionTree> v_ANDTrees = PrereqTreeUtils.getAllANDExpressionTrees(prereqTree = PrereqTreeUtils.convertToDNF(prereqTree));
        if (v_ANDTrees == null || v_ANDTrees.size() == 0) {
            LOGGER.exiting(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
            return null;
        }
        Vector<GenericExpressionTree> v_leafs = PrereqTreeUtils.getLeafsAsNodes(v_ANDTrees.get(0));
        if (v_leafs == null || v_leafs.size() <= 0) {
            LOGGER.exiting(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
            return null;
        }
        GenericExpressionTree expObj = v_leafs.get(v_leafs.size() - 1);
        if (expObj instanceof WSProfileTemplateExpressionTree) {
            LOGGER.exiting(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
            return FileUtils.getNormalizedPath(((WSProfileTemplateExpressionTree)expObj).getData());
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getPrereqTemplatePath");
        return null;
    }

    public Vector<String> getDisabledActions() {
        return this.m_vDisabledActions;
    }

    public void setDisabledActions(Vector<String> disabledActions) {
        this.m_vDisabledActions = disabledActions;
    }

    public boolean isAugmentTemplate() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_AUGMENT_TEMPLATE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_AUGMENT_TEMPLATE);
        return this.m_fIsAugmentTemplate;
    }

    public boolean isCreateTemplate() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_CREATE_TEMPLATE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_CREATE_TEMPLATE);
        return this.m_fIsCreateTemplate;
    }

    public boolean isRepeatable() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_REPEATABLE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_REPEATABLE);
        return this.m_fIsRepeatable;
    }

    public boolean isDisplayed() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_DISPLAYED);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_DISPLAYED);
        return this.m_fIsDisplayed;
    }

    public boolean isUnaugmentable() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_UNAUGMENTABLE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_UNAUGMENTABLE);
        return this.m_fIsUnaugmentable;
    }

    public boolean isStrictCLIValidationFlagEnabled() {
        LOGGER.entering(WSProfileTemplate.class.getName(), S_TAG_IS_REPEATABLE);
        LOGGER.exiting(WSProfileTemplate.class.getName(), S_TAG_IS_REPEATABLE);
        return this.m_fIsStrictlyValidated;
    }

    public String getResourceBundleClassname() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        return this.m_resourceBundle.getClass().getName();
    }

    public ResourceBundle getResourceBundle() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        return this.m_resourceBundle;
    }

    public File getResourceBundlePath() {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getResourceBundleClassname");
        return this.m_fileResourceBundleJarPath;
    }

    public boolean equals(Object o) {
        boolean fReturn;
        block3: {
            fReturn = false;
            try {
                if (o instanceof WSProfileTemplate) {
                    WSProfileTemplate wsptAnother = (WSProfileTemplate)o;
                    fReturn = this.getProfileTemplatePath().getCanonicalFile().equals(wsptAnother.getProfileTemplatePath().getCanonicalFile());
                }
            }
            catch (IOException ioe) {
                if (!(o instanceof WSProfileTemplate)) break block3;
                WSProfileTemplate wsptAnother = (WSProfileTemplate)o;
                fReturn = this.getProfileTemplatePath().equals(wsptAnother.getProfileTemplatePath());
            }
        }
        return fReturn;
    }

    public boolean isEmptyTemplate() {
        return this instanceof WSProfileEmptyTemplate;
    }

    private void parseTemplateMetadata() throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "parseTemplateMetadata");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = docBuilderFactory.newDocumentBuilder().parse(this.m_fileTemplateMetadata);
            this.unmarshallResourceBundleMetadata(document);
            this.unmarshallNameKey(document);
            this.unmarshallType(document);
            this.unmarshallVersion(document);
            this.unmarshallShortDescriptionKey(document);
            this.unmarshallLongDescriptionKey(document);
            this.unmarshallBuildDate(document);
            this.unmarshallIsCreateTemplate(document);
            this.unmarshallIsAugmentTemplate(document);
            this.unmarshallIsStrictValidationFlag(document);
            this.unmarshallIsRepeatable(document);
            this.unmarshallPrerequisites(document);
            this.unmarshallSize(document);
            this.unmarshallIsUnaugmentable(document);
            this.unmarshallIsDisplayed(document);
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + e.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        catch (SAXException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + e.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        catch (ParserConfigurationException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + e.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        catch (Exception e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "parseTemplateMetadata", "Unexpected exception caught!");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "parseTemplateMetadata", "Exception caught while parsing template metadata: " + e.getMessage());
            throw new WSProfileException(S_METADATA_PARSING_ERROR, ResourceBundleUtils.getLocaleString(S_METADATA_PARSING_ERROR_KEY));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "parseTemplateMetadata");
    }

    private NodeList getNodeList(Document document, String[] sa_parents, String sTag) {
        Node parent = document.getDocumentElement();
        for (int i = 0; i < sa_parents.length; ++i) {
            Node currentNode = this.getChildNode(document, parent, sa_parents[i]);
            if (currentNode.getNodeType() != 1) continue;
            parent = currentNode;
        }
        return this.getChildNode(document, parent, sTag).getChildNodes();
    }

    private Node getChildNode(Document document, Node parent, String sTagChild) {
        if (parent != null && parent.getNodeName().equals(sTagChild)) {
            return parent;
        }
        NodeList childNodes = parent.getChildNodes();
        Node childNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(sTagChild)) continue;
            return childNode;
        }
        return childNode;
    }

    private String unmarshallSingleStringFromDocument(Document document, String sTag) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallSingleStringFromDocument");
        NodeList nodelist = document.getElementsByTagName(sTag);
        String sReturnString = "";
        sReturnString = nodelist.item(0).getChildNodes().item(0).getNodeValue();
        if (sReturnString == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallSingleStringFromDocument", "The tag " + sTag + " was found to be null.");
            throw new WSProfileException(S_DOCUMENT_READ_TAG_ERROR + sTag, ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, sTag));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallSingleStringFromDocument");
        return sReturnString;
    }

    private void unmarshallResourceBundleMetadata(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallResourceBundleMetadata");
        this.validateProfileTemplateArgument(document, S_TAG_RESOURCE_BUNDLE);
        this.validateProfileTemplateArgument(document, S_TAG_JAR_PATH);
        this.validateProfileTemplateArgument(document, S_TAG_RESOURCE_BUNDLE_NAME);
        NodeList nodelistResourceBundle = document.getElementsByTagName(S_TAG_RESOURCE_BUNDLE);
        this.validateNodeListSize(nodelistResourceBundle, S_TAG_RESOURCE_BUNDLE);
        Element elementResourceBundle = (Element)nodelistResourceBundle.item(0);
        NodeList nodelistJarPath = elementResourceBundle.getElementsByTagName(S_TAG_JAR_PATH);
        this.validateNodeListSize(nodelistJarPath, S_TAG_JAR_PATH);
        String sJarPath = nodelistJarPath.item(0).getChildNodes().item(0).getNodeValue();
        NodeList nodelistResourceBundleName = elementResourceBundle.getElementsByTagName(S_TAG_RESOURCE_BUNDLE_NAME);
        this.validateNodeListSize(nodelistResourceBundleName, S_TAG_RESOURCE_BUNDLE_NAME);
        String sResourceBundleName = nodelistResourceBundleName.item(0).getChildNodes().item(0).getNodeValue();
        this.m_fileResourceBundleJarPath = new File(this.getProfileTemplatePath(), sJarPath);
        this.addJarToClasspath(this.m_fileResourceBundleJarPath);
        try {
            this.m_resourceBundle = ResourceBundle.getBundle(sResourceBundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallResourceBundleMetadata", "Resource bundle not found: " + mre.getMessage());
            throw new WSProfileException(S_TEMPLATE_BUNDLE_NOT_FOUND, ResourceBundleUtils.getLocaleString(S_TEMPLATE_BUNDLE_NOT_FOUND_KEY, sResourceBundleName));
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallResourceBundleMetadata", "Resource bundle name cannot be null: " + e.getMessage());
            throw new WSProfileException(S_TEMPLATE_BUNDLE_NOT_FOUND, ResourceBundleUtils.getLocaleString(S_TEMPLATE_BUNDLE_NOT_FOUND_KEY, sResourceBundleName));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallResourceBundleMetadata");
    }

    private void unmarshallNameKey(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallNameKey");
        this.validateProfileTemplateArgument(document, S_TAG_NAME_KEY);
        if (this.isTagPresentInDocument(document, S_TAG_NAME_KEY)) {
            this.m_sNameKey = this.unmarshallSingleStringFromDocument(document, S_TAG_NAME_KEY);
            Node nodeName = this.getNodeFromDocumentForThisTag(document, S_TAG_NAME_KEY);
            this.m_vNameParms = this.unmarshallMessageKeyParameters(nodeName);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallNameKey");
    }

    private void unmarshallType(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallType");
        this.validateProfileTemplateArgument(document, S_TAG_TYPE);
        if (this.isTagPresentInDocument(document, S_TAG_TYPE)) {
            this.m_sType = this.unmarshallSingleStringFromDocument(document, S_TAG_TYPE);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallType");
    }

    private void unmarshallVersion(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallVersion");
        this.validateProfileTemplateArgument(document, S_TAG_VERSION);
        if (this.isTagPresentInDocument(document, S_TAG_VERSION)) {
            this.m_sVersion = this.unmarshallSingleStringFromDocument(document, S_TAG_VERSION);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallVersion");
    }

    private void unmarshallShortDescriptionKey(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallShortDescriptionKey");
        this.validateProfileTemplateArgument(document, S_TAG_SHORT_DESCRIPTION_KEY);
        if (this.isTagPresentInDocument(document, S_TAG_SHORT_DESCRIPTION_KEY)) {
            this.m_sShortDescriptionKey = this.unmarshallSingleStringFromDocument(document, S_TAG_SHORT_DESCRIPTION_KEY);
            Node nodeShortDescription = this.getNodeFromDocumentForThisTag(document, S_TAG_SHORT_DESCRIPTION_KEY);
            this.m_vShortDescriptionParms = this.unmarshallMessageKeyParameters(nodeShortDescription);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallShortDescriptionKey");
    }

    private Vector<String> unmarshallMessageKeyParameters(Node node) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallMessageKeyParameters");
        NamedNodeMap namednodemapAttributes = node.getAttributes();
        Vector<String> vArguments = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            Node nodeAttrThis = namednodemapAttributes.getNamedItem(S_TAG_MSG_KEY_ARG_PREFIX + i);
            if (nodeAttrThis == null) continue;
            String sValueOfThisAttr = nodeAttrThis.getChildNodes().item(0).getNodeValue();
            vArguments.addElement(sValueOfThisAttr);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallMessageKeyParameters");
        return vArguments;
    }

    private void unmarshallLongDescriptionKey(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallLongDescriptionKey");
        this.validateProfileTemplateArgument(document, S_TAG_LONG_DESCRIPTION_KEY);
        if (this.isTagPresentInDocument(document, S_TAG_LONG_DESCRIPTION_KEY)) {
            this.m_sLongDescriptionKey = this.unmarshallSingleStringFromDocument(document, S_TAG_LONG_DESCRIPTION_KEY);
            Node nodeLongDescription = this.getNodeFromDocumentForThisTag(document, S_TAG_LONG_DESCRIPTION_KEY);
            this.m_vLongDescriptionParms = this.unmarshallMessageKeyParameters(nodeLongDescription);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallLongDescriptionKey");
    }

    private void unmarshallBuildDate(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallBuildDate");
        this.validateProfileTemplateArgument(document, S_TAG_BUILD_DATE);
        if (this.isTagPresentInDocument(document, S_TAG_BUILD_DATE)) {
            String sDate = this.unmarshallSingleStringFromDocument(document, S_TAG_BUILD_DATE);
            SimpleDateFormat format = new SimpleDateFormat(S_DATE_FORMAT);
            try {
                this.m_buildDate = format.parse(sDate);
            }
            catch (ParseException pe) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unmarshallBuildDate", "Exception caught while parsing build date:" + pe.getMessage());
                throw new WSProfileException("Error reading template information: buildDate", ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, S_TAG_BUILD_DATE));
            }
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallBuildDate");
    }

    private void unmarshallIsCreateTemplate(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsCreateTemplate");
        this.validateProfileTemplateArgument(document, S_TAG_IS_CREATE_TEMPLATE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_CREATE_TEMPLATE)) {
            String sIsCreateTemplate = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_CREATE_TEMPLATE);
            this.m_fIsCreateTemplate = Boolean.valueOf(sIsCreateTemplate);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsCreateTemplate");
    }

    private void unmarshallIsAugmentTemplate(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsAugmentTemplate");
        this.validateProfileTemplateArgument(document, S_TAG_IS_AUGMENT_TEMPLATE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_AUGMENT_TEMPLATE)) {
            String sIsAugmentTemplate = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_AUGMENT_TEMPLATE);
            this.m_fIsAugmentTemplate = Boolean.valueOf(sIsAugmentTemplate);
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsAugmentTemplate");
    }

    private void unmarshallIsRepeatable(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsRepeatable");
        this.validateProfileTemplateArgument(document, S_TAG_IS_REPEATABLE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_REPEATABLE)) {
            String sIsRepeatable = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_REPEATABLE);
            this.m_fIsRepeatable = Boolean.valueOf(sIsRepeatable);
        } else {
            this.m_fIsRepeatable = false;
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsRepeatable");
    }

    private void unmarshallIsStrictValidationFlag(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsStrictValidationFlag");
        this.validateProfileTemplateArgument(document, S_TAG_IS_STRICTLY_VALIDATED);
        if (this.isTagPresentInDocument(document, S_TAG_IS_STRICTLY_VALIDATED)) {
            String sIsStrict = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_STRICTLY_VALIDATED);
            this.m_fIsStrictlyValidated = Boolean.valueOf(sIsStrict);
        } else {
            this.m_fIsStrictlyValidated = false;
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsStrictValidationFlag");
    }

    private void unmarshallSize(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallSize");
        this.validateProfileTemplateArgument(document, S_TAG_SIZE);
        if (this.isTagPresentInDocument(document, S_TAG_SIZE)) {
            String sSize = this.unmarshallSingleStringFromDocument(document, S_TAG_SIZE);
            try {
                this.m_iSize = Integer.parseInt(sSize);
            }
            catch (NumberFormatException nfe) {
                LogUtils.logException(LOGGER, nfe);
                throw new WSProfileException("Error reading template information: size", ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, S_TAG_SIZE));
            }
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallSize");
    }

    private void unmarshallIsUnaugmentable(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsUnaugmentable");
        this.validateProfileTemplateArgument(document, S_TAG_IS_UNAUGMENTABLE);
        if (this.isTagPresentInDocument(document, S_TAG_IS_UNAUGMENTABLE)) {
            String sIsUnaugmentable = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_UNAUGMENTABLE);
            this.m_fIsUnaugmentable = Boolean.valueOf(sIsUnaugmentable);
        } else {
            this.m_fIsUnaugmentable = false;
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsUnaugmentable");
    }

    private void unmarshallIsDisplayed(Document document) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "unmarshallIsDisplayed");
        this.validateProfileTemplateArgument(document, S_TAG_IS_DISPLAYED);
        if (this.isTagPresentInDocument(document, S_TAG_IS_DISPLAYED)) {
            String sIsDisplayed = this.unmarshallSingleStringFromDocument(document, S_TAG_IS_DISPLAYED);
            this.m_fIsDisplayed = Boolean.valueOf(sIsDisplayed);
        } else {
            this.m_fIsDisplayed = true;
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "unmarshallIsDisplayed");
    }

    private void unmarshallPrerequisites(Document document) throws WSProfileException {
        this.m_expTreePrereqData = this.createPrereqTemplateTree(document);
    }

    public GenericExpressionTree getPrereqTemplateTree() {
        return this.m_expTreePrereqData;
    }

    private GenericExpressionTree createPrereqTemplateTree(Document document) throws WSProfileException {
        NodeList prereqNodeList = this.getNodeList(document, new String[]{document.getDocumentElement().getNodeName()}, S_TAG_TEMPLATE_PREREQ);
        OperatorExpressionTree expTree_root = null;
        if (prereqNodeList != null && prereqNodeList.getLength() != 0) {
            int nNextElementIndex = this.getNextElementNodeIndex(prereqNodeList, 0);
            if (this.getNumberOfElementsInNodeList(prereqNodeList) == 1 && !PrereqTreeUtils.isAnOperator(prereqNodeList.item(nNextElementIndex).getNodeName())) {
                return this.getTreeForNodeInList(prereqNodeList, this.getNextElementNodeIndex(prereqNodeList, 0));
            }
            if (nNextElementIndex == -1) {
                String sPrereqPath = null;
                sPrereqPath = this.formatAndValidateFilePath(prereqNodeList.item(0).getNodeValue());
                Vector<WSProfileDisabledAction> vDisabledActions = new Vector<WSProfileDisabledAction>();
                WSProfileTemplatePrereqData wsptd = new WSProfileTemplatePrereqData(new File(sPrereqPath), vDisabledActions);
                return new WSProfileTemplateExpressionTree(wsptd, null, null);
            }
            int nIndexOfNextElement = 0;
            boolean fReturnLeftChild = false;
            if (this.getNumberOfElementsInNodeList(prereqNodeList) == 1 && PrereqTreeUtils.isAnOperator(prereqNodeList.item(nNextElementIndex).getNodeName())) {
                fReturnLeftChild = true;
            } else {
                expTree_root = new OperatorExpressionTree("AND", null, null);
            }
            nIndexOfNextElement = this.getNextElementNodeIndex(prereqNodeList, 0);
            GenericExpressionTree leftChild = this.getPrereqTree(prereqNodeList.item(nIndexOfNextElement), nIndexOfNextElement);
            if (fReturnLeftChild) {
                return leftChild;
            }
            GenericExpressionTree rightChild = this.getPrereqTree(this.getChildNode(document, document.getDocumentElement(), S_TAG_TEMPLATE_PREREQ), nIndexOfNextElement + 1);
            leftChild.setParent(expTree_root);
            expTree_root.setLeftChild(leftChild);
            rightChild.setParent(expTree_root);
            expTree_root.setRightChild(rightChild);
        }
        return expTree_root;
    }

    private GenericExpressionTree getPrereqTree(Node node, int position) throws WSProfileException {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        if (!PrereqTreeUtils.isAnOperator(node.getNodeName()) && !node.getNodeName().equals(S_TAG_TEMPLATE_PREREQ)) {
            return this.getTreeForNode(node);
        }
        if (children == null || children.getLength() < position) {
            return null;
        }
        children = node.getChildNodes();
        if (children == null) {
            return null;
        }
        int nNextNodeIndex = this.getNextElementNodeIndex(children, position);
        Node nextElement = children.item(nNextNodeIndex);
        if (PrereqTreeUtils.isAnOperator(nextElement.getNodeName()) && nNextNodeIndex == this.indexOfLastElementNode(children)) {
            return this.getPrereqTree(nextElement, 0);
        }
        if (!PrereqTreeUtils.isAnOperator(nextElement.getNodeName()) && nNextNodeIndex == this.indexOfLastElementNode(children)) {
            return this.getTreeForNode(nextElement);
        }
        GenericExpressionTree expTree_root = this.getTreeForNode(node);
        nextElement = children.item(nNextNodeIndex);
        GenericExpressionTree expTree_leftChild = null;
        expTree_leftChild = PrereqTreeUtils.isAnOperator(nextElement.getNodeName()) ? this.getPrereqTree(children.item(nNextNodeIndex), 0) : this.getPrereqTree(children.item(nNextNodeIndex), nNextNodeIndex);
        nNextNodeIndex = this.getNextElementNodeIndex(children, nNextNodeIndex + 1);
        GenericExpressionTree expTree_rightChild = this.getPrereqTree(node, nNextNodeIndex);
        expTree_root.setLeftChild(expTree_leftChild);
        expTree_leftChild.setParent(expTree_root);
        expTree_root.setRightChild(expTree_rightChild);
        expTree_rightChild.setParent(expTree_root);
        return expTree_root;
    }

    private int indexOfLastElementNode(NodeList children) {
        int nIndex = -1;
        if (children != null) {
            for (int i = children.getLength(); i > -1; --i) {
                if (children.item(i) == null || children.item(i).getNodeType() != 1) continue;
                return i;
            }
        }
        return nIndex;
    }

    private int getNextElementNodeIndex(NodeList children, int from) {
        if (children != null && children.getLength() >= from) {
            for (int i = from; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                return i;
            }
        }
        return -1;
    }

    private int getNumberOfElementsInNodeList(NodeList nodeList) {
        int elements = 0;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                ++elements;
            }
        }
        return elements;
    }

    private GenericExpressionTree getTreeForNodeInList(NodeList nodeList, int position) throws WSProfileException {
        if (nodeList.getLength() > position && position > -1) {
            return this.getTreeForNode(nodeList.item(position));
        }
        throw new WSProfileException("Invalid entry: position " + position + " is out of range of list " + nodeList.toString());
    }

    private GenericExpressionTree getTreeForNode(Node node) throws WSProfileException {
        GenericExpressionTree gExpTree;
        String sData = "";
        String sNodeName = node.getNodeName();
        String sNodeValue = node.getChildNodes().item(0).getNodeValue();
        if (PrereqTreeUtils.isAnOperator(sNodeName) || sNodeName.equals(S_TAG_TEMPLATE_PREREQ)) {
            if (sNodeName.equalsIgnoreCase("AND") || sNodeName.equals(S_TAG_TEMPLATE_PREREQ)) {
                sData = "AND";
            } else if (sNodeName.equalsIgnoreCase("OR")) {
                sData = "OR";
            }
            gExpTree = new OperatorExpressionTree(sData, null, null);
        } else if (sNodeName.equalsIgnoreCase(S_TAG_TEMPLATE_PATH)) {
            sNodeValue = this.formatAndValidateFilePath(sNodeValue);
            Vector<WSProfileDisabledAction> disabledActions = this.getDisabledActions(node);
            WSProfileTemplatePrereqData pd = new WSProfileTemplatePrereqData(new File(sNodeValue), disabledActions);
            gExpTree = new WSProfileTemplateExpressionTree(pd, null, null);
        } else {
            throw new WSProfileException("templateMetadata.xml: prerequisiteTemplate is not valid");
        }
        return gExpTree;
    }

    private Vector<WSProfileDisabledAction> getDisabledActions(Node node) throws WSProfileException {
        String sNodeName = node.getNodeName();
        if (!sNodeName.equals(S_TAG_TEMPLATE_PATH)) {
            throw new WSProfileException("templateMetadata.xml: template is not valid");
        }
        Vector<WSProfileDisabledAction> disabledActions = new Vector<WSProfileDisabledAction>();
        NodeList disabledActionsNodeList = ((Element)node).getElementsByTagName(S_TAG_DISABLE_ACTION);
        if (disabledActionsNodeList == null || disabledActionsNodeList.getLength() == 0) {
            return disabledActions;
        }
        for (int i = 0; i < disabledActionsNodeList.getLength(); ++i) {
            String disabledAction = disabledActionsNodeList.item(i).getChildNodes().item(0).getNodeValue();
            disabledActions.add(new WSProfileDisabledAction(disabledAction));
        }
        return disabledActions;
    }

    private String formatAndValidateFilePath(String sPath) throws WSProfileException {
        String sPrereqPath = sPath.trim();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", "Testing " + sPrereqPath + " as an " + "absolute or relative path.");
        File fileFullTemplatePath = new File(WSProfileTemplate.replaceWASHome(sPrereqPath));
        File fileConstructedTemplatePath = new File(this.getProfileTemplatePath(), sPrereqPath);
        if (WSProfileTemplate.isValidWSProfileTemplate(fileFullTemplatePath)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", sPrereqPath + " is a valid full profile template path.");
            return FileUtils.getNormalizedPath(fileFullTemplatePath).getPath();
        }
        if (WSProfileTemplate.isValidWSProfileTemplate(fileConstructedTemplatePath)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", sPrereqPath + " is a valid relative profile template path.");
            return FileUtils.getNormalizedPath(fileConstructedTemplatePath).getPath();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallPrerequisite", sPrereqPath + " is not a valid profile template path.");
        throw new WSProfileException();
    }

    private void addJarToClasspath(File fileJarPath) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "addJarToClasspath");
        try {
            if (WSProfileTemplate.isJarFile(fileJarPath)) {
                ClassPathModifier.addFileToClassPath(fileJarPath.getPath());
            } else {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "addJarToClasspath", fileJarPath + " is not a valid Jar File!");
            }
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "addJarToClasspath", "Unable to add JAR to classpath: " + e.getMessage());
            throw new WSProfileException(S_TEMPLATE_UNABLE_TO_LOAD_JAR, ResourceBundleUtils.getLocaleString(S_TEMPLATE_UNABLE_TO_LOAD_JAR_KEY, fileJarPath.toString()));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "addJarToClasspath");
    }

    private void validateProfileTemplateOnFileSystem() throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "validateProfileTEmplateOnFileSystem");
        if (!this.m_fileTemplatePath.isDirectory()) {
            throw new WSProfileException(S_TEMPLATE_NOT_FOUND + this.m_fileTemplatePath.getPath(), ResourceBundleUtils.getLocaleString(S_TEMPLATE_NOT_FOUND_KEY, this.m_fileTemplatePath.getPath()));
        }
        if (!this.m_fileTemplateMetadata.isFile()) {
            throw new WSProfileException(S_TEMPLATE_METADATA_NOT_FOUND + this.m_fileTemplateMetadata.getPath(), ResourceBundleUtils.getLocaleString(S_TEMPLATE_METADATA_NOT_FOUND_KEY, this.m_fileTemplateMetadata.getPath()));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "validateProfileTEmplateOnFileSystem");
    }

    private void validateProfileTemplateArgument(Document document, String sTag) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "validateProfileTemplateArgument");
        boolean fIsOptional = false;
        for (int i = 0; i < OPTIONAL_ARGUMENTS.length; ++i) {
            if (!sTag.equals(OPTIONAL_ARGUMENTS[i])) continue;
            fIsOptional = true;
            break;
        }
        if (!fIsOptional && !this.isTagPresentInDocument(document, sTag)) {
            throw new WSProfileException(S_REQUIRED_ARGUMENT_NOT_FOUND + sTag, ResourceBundleUtils.getLocaleString(S_REQUIRED_ARGUMENT_NOT_FOUND_KEY, sTag));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "validateProfileTemplateArgument");
    }

    private void validateNodeListSize(NodeList thisNodeList, String sTagName) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "validateNodeListSize");
        if (thisNodeList.getLength() != 1) {
            throw new WSProfileException(S_DOCUMENT_READ_TAG_ERROR, ResourceBundleUtils.getLocaleString(S_DOCUMENT_READ_TAG_ERROR_KEY, sTagName));
        }
        LOGGER.exiting(WSProfileTemplate.class.getName(), "validateNodeListSize");
    }

    private Node getNodeFromDocumentForThisTag(Document document, String sTag) throws WSProfileException {
        LOGGER.entering(WSProfileTemplate.class.getName(), "getNodeFromDocumentForThisTag");
        NodeList nodelist = document.getElementsByTagName(sTag);
        LOGGER.exiting(WSProfileTemplate.class.getName(), "getNodeFromDocumentForThisTag");
        return nodelist.item(0);
    }

    private boolean isTagPresentInDocument(Document document, String sTag) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "isTagPresentInDocument");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "isTagPresentInDocument");
        return document.getElementsByTagName(sTag).getLength() != 0;
    }

    private static boolean isJarFile(File fileJarPath) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "isJarFile");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "isJarFile");
        return fileJarPath.getAbsolutePath().toLowerCase().matches(S_JAR_FILE_PATTERN);
    }

    private static String replaceWASHome(String sFilePath) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "replaceWASHome");
        String sWASHome = null;
        sWASHome = System.getProperty("WAS_HOME");
        if (sWASHome == null) {
            sWASHome = System.getProperty("was.install.root");
        }
        sWASHome = sWASHome.replace('\\', '/');
        String sPath = sFilePath.replaceAll(S_WAS_HOME_REGEX_TOKEN, sWASHome);
        LOGGER.exiting(WSProfileTemplate.class.getName(), "replaceWASHome");
        return new File(sPath).getPath();
    }

    private static boolean isValidWSProfileTemplate(File fileTemplatePath) {
        LOGGER.entering(WSProfileTemplate.class.getName(), "isValidTemplate");
        LOGGER.exiting(WSProfileTemplate.class.getName(), "isValidTemplate");
        boolean fReturn = false;
        fReturn = fileTemplatePath.isDirectory() && new File(fileTemplatePath, "templateMetadata.xml").isFile();
        return fReturn;
    }

    private GenericExpressionTree getCompletePrereqTree(GenericExpressionTree root) throws WSProfileException {
        WSProfileTemplateExpressionTree leaf;
        if (root == null) {
            return root;
        }
        Vector v_leafs = this.getNextLevel(root);
        if (v_leafs != null && v_leafs.size() == 1 && (leaf = (WSProfileTemplateExpressionTree)v_leafs.get(0)).equals(root)) {
            WSProfileTemplate wspt_leafTemplate = new WSProfileTemplate(leaf.getData());
            OperatorExpressionTree newRoot = new OperatorExpressionTree("AND", wspt_leafTemplate.getPrereqTemplateTree(), leaf);
            leaf.setParent(newRoot);
            wspt_leafTemplate.getPrereqTemplateTree().setParent(newRoot);
            root = newRoot;
            v_leafs = this.getNextLevel(newRoot.getLeftChild());
        }
        while (v_leafs != null && v_leafs.size() > 0) {
            for (int i = 0; i < v_leafs.size(); ++i) {
                WSProfileTemplateExpressionTree leaf2 = (WSProfileTemplateExpressionTree)v_leafs.get(i);
                WSProfileTemplate wspt_leafTemplate = new WSProfileTemplate(leaf2.getData());
                GenericExpressionTree parent = leaf2.getParent();
                OperatorExpressionTree expTree_AND = new OperatorExpressionTree("AND", null, null);
                expTree_AND.setParent(parent);
                if (this.nodeIsRightChild(parent, leaf2)) {
                    parent.setRightChild(expTree_AND);
                } else {
                    parent.setLeftChild(expTree_AND);
                }
                expTree_AND.setRightChild(leaf2);
                expTree_AND.setLeftChild(wspt_leafTemplate.getPrereqTemplateTree());
                leaf2.setLeftChild(null);
                leaf2.setRightChild(null);
            }
            this.validateTreePaths(root);
            v_leafs = this.getNextLevel(root);
        }
        return root;
    }

    private void validateTreePaths(GenericExpressionTree inputTree) throws WSProfileException {
        GenericExpressionTree tree = inputTree;
        tree = PrereqTreeUtils.convertToDNF(tree);
        Vector<GenericExpressionTree> v_ANDexpTree = PrereqTreeUtils.getAllANDExpressionTrees(tree);
        for (int i = 0; i < v_ANDexpTree.size(); ++i) {
            OperatorExpressionTree currentTree = (OperatorExpressionTree)v_ANDexpTree.get(i);
            Vector<GenericExpressionTree> v_currentLeafs = PrereqTreeUtils.getLeafsAsNodes(currentTree);
            if (v_currentLeafs != null && v_currentLeafs.size() > 0) {
                for (int j = 0; j < v_currentLeafs.size(); ++j) {
                    WSProfileTemplateExpressionTree expTree_leaf = (WSProfileTemplateExpressionTree)v_currentLeafs.get(j);
                    WSProfileTemplate treeTemplate = new WSProfileTemplate(expTree_leaf.getData());
                    if (!treeTemplate.getProfileTemplatePath().equals(this.getProfileTemplatePath())) continue;
                    throw new WSProfileException("A cycles has been detected between " + this.getProfileTemplatePath() + " and a template in its prereq list: " + v_currentLeafs);
                }
            }
            if (currentTree.isLeaf()) {
                WSProfileTemplate treeTemplate = new WSProfileTemplate(currentTree.getData());
                if (!treeTemplate.getProfileTemplatePath().equals(this.getProfileTemplatePath())) continue;
                throw new WSProfileException("A cycles has been detected between " + this.getProfileTemplatePath() + " and a template in its prereq list: " + currentTree);
            }
            this.breadthFirstTreeValidation(currentTree);
        }
    }

    private void validateTree(GenericExpressionTree expTree) throws WSProfileException {
        OperatorExpressionTree parent;
        if (expTree != null && (parent = (OperatorExpressionTree)expTree.getParent()) != null && !PrereqTreeUtils.isRootAnOR(parent) && !this.isBaseTemplate(expTree)) {
            boolean searchResult = false;
            searchResult = this.nodeIsRightChild(parent, expTree) ? this.breadthFirstSearch(parent.getLeftChild(), expTree) : this.breadthFirstSearch(parent.getRightChild(), expTree);
            searchResult = searchResult || this.breadthFirstSearch(expTree.getLeftChild(), expTree);
            boolean bl = searchResult = searchResult || this.breadthFirstSearch(expTree.getRightChild(), expTree);
            if (searchResult) {
                throw new WSProfileException("A cycles has been detected in the prerequisite tree:\n" + expTree.toString());
            }
        }
    }

    private boolean isBaseTemplate(GenericExpressionTree expTree) throws WSProfileException {
        if (PrereqTreeUtils.isRootAnOperand(expTree)) {
            WSProfileTemplate wspt = new WSProfileTemplate(((WSProfileTemplateExpressionTree)expTree).getData());
            return wspt.isCreateTemplate();
        }
        return false;
    }

    private void breadthFirstTreeValidation(GenericExpressionTree expTree) throws WSProfileException {
        if (expTree != null) {
            LinkedList<GenericExpressionTree> queue = new LinkedList<GenericExpressionTree>();
            queue.addFirst(expTree);
            while (queue != null && queue.size() > 0) {
                GenericExpressionTree expTree_current = (GenericExpressionTree)queue.removeFirst();
                this.validateTree(expTree_current);
                GenericExpressionTree leftChild = expTree_current.getLeftChild();
                GenericExpressionTree rightChild = expTree_current.getRightChild();
                if (leftChild != null) {
                    queue.addFirst(leftChild);
                }
                if (rightChild == null) continue;
                queue.addFirst(rightChild);
            }
        }
    }

    private boolean breadthFirstSearch(GenericExpressionTree expTree, GenericExpressionTree node) throws WSProfileException {
        if (PrereqTreeUtils.isRootAnOperand(node)) {
            WSProfileTemplate wspt_node = new WSProfileTemplate((File)node.getData());
            if (expTree != null) {
                LinkedList<GenericExpressionTree> queue = new LinkedList<GenericExpressionTree>();
                queue.addFirst(expTree);
                while (queue != null && queue.size() > 0) {
                    GenericExpressionTree expTree_current = (GenericExpressionTree)queue.removeFirst();
                    if (PrereqTreeUtils.isRootAnOperand(expTree_current)) {
                        WSProfileTemplate wspt_current = new WSProfileTemplate((File)expTree_current.getData());
                        if (wspt_node.getProfileTemplatePath().equals(wspt_current.getProfileTemplatePath())) {
                            return true;
                        }
                    }
                    if (expTree_current.isLeaf()) continue;
                    queue.addFirst(expTree_current.getLeftChild());
                    queue.addFirst(expTree_current.getRightChild());
                }
            }
        }
        return false;
    }

    private boolean nodeIsRightChild(GenericExpressionTree parent, GenericExpressionTree leaf) {
        if (parent == null) {
            return false;
        }
        GenericExpressionTree rightChild = parent.getRightChild();
        if (rightChild == null) {
            return false;
        }
        return rightChild == leaf;
    }

    private Vector getNextLevel(GenericExpressionTree tree) throws WSProfileException {
        Vector<GenericExpressionTree> v_leafs = PrereqTreeUtils.getLeafsAsNodes(tree);
        if (v_leafs == null || v_leafs.size() <= 0) {
            return new Vector();
        }
        Vector<WSProfileTemplateExpressionTree> v_children = new Vector<WSProfileTemplateExpressionTree>();
        for (int i = 0; i < v_leafs.size(); ++i) {
            WSProfileTemplateExpressionTree leaf = (WSProfileTemplateExpressionTree)v_leafs.get(i);
            WSProfileTemplate wspt_leafTemplate = new WSProfileTemplate(leaf.getData());
            GenericExpressionTree expTree_leaf = wspt_leafTemplate.getPrereqTemplateTree();
            GenericExpressionTree parent = leaf.getParent();
            if (parent != null && PrereqTreeUtils.isRootAnOperator(parent) && parent.getData().equals("OR") && expTree_leaf != null) {
                v_children.add(leaf);
                continue;
            }
            if (expTree_leaf == null || PrereqTreeUtils.treeContainsLeafs(leaf.getLeftSibling(), PrereqTreeUtils.getLeafsAsNodes(expTree_leaf))) continue;
            v_children.add(leaf);
        }
        return v_children;
    }

    public GenericExpressionTree getCompletePrereqTree() throws WSProfileException {
        if (this.m_completePrereqExpressionTree != null) {
            return this.m_completePrereqExpressionTree;
        }
        return this.getCompletePrereqTree(this.getPrereqTemplateTree());
    }
}

