/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer.services;

import com.ibm.wsspi.portletcontainer.services.ContainerService;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PortletContainerContextAdapter
implements PortletContainerContext {
    private Map services = new HashMap();
    private List parentContexts;

    public PortletContainerContextAdapter() {
        this(null);
    }

    public PortletContainerContextAdapter(List parentContexts) {
        this.parentContexts = parentContexts;
    }

    public void addContainerService(ContainerService service) {
        for (Class<?> serviceClass = service.getClass(); serviceClass != null; serviceClass = serviceClass.getSuperclass()) {
            this.addContainerService(serviceClass, service);
        }
    }

    private void addContainerService(Class interfaceClass, ContainerService service) {
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(ContainerService.class)) {
                this.services.put(interfaceClass, service);
                continue;
            }
            this.addContainerService(interfaces[i], service);
        }
    }

    public ContainerService getContainerService(Class service) {
        ContainerService serviceImpl = (ContainerService)this.services.get(service);
        if (serviceImpl == null && this.parentContexts != null) {
            Iterator iter = this.parentContexts.iterator();
            while (serviceImpl == null && iter.hasNext()) {
                serviceImpl = ((PortletContainerContext)iter.next()).getContainerService(service);
            }
        }
        return serviceImpl;
    }
}

