/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca;

import com.ibm.wsif.format.jca.WSIFFormatPart_JCA;
import com.ibm.wsif.jca.JCAFormatHandler;
import com.ibm.wsif.jca.JCAMessage;
import com.ibm.wsif.jca.log.JCAResource;
import com.ibm.wsif.jca.util.JCAUtil;
import com.ibm.wsif.logging.Trc;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.resource.cci.Streamable;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;

public class JCAStreamableMessage
extends JCAMessage
implements Streamable {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private Message fieldMessageModel = null;
    private static final long serialVersionUID = 5L;
    private HashMap fieldPartNameFormatHandlerMapping = new HashMap();

    public JCAStreamableMessage(Definition definition, Binding binding, String string, String string2, String string3, int n) {
        super(definition, binding, string, string2, string3, n);
        Operation operation = binding.getPortType().getOperation(string, string2, string3);
        switch (n) {
            case 1: {
                if (operation.getInput() == null) break;
                this.fieldMessageModel = operation.getInput().getMessage();
                break;
            }
            case 2: {
                if (operation.getOutput() == null) break;
                this.fieldMessageModel = operation.getOutput().getMessage();
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.fieldMessageModel = operation.getInput().getMessage();
            }
        }
    }

    public void read(InputStream inputStream) throws IOException {
        try {
            Trc.entry((Object)inputStream);
            if (this.fieldMessageModel == null) {
                return;
            }
            Iterator iterator = this.fieldMessageModel.getOrderedParts(null).iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                String string = part.getName();
                JCAFormatHandler jCAFormatHandler = null;
                if (this.fieldPartNameFormatHandlerMapping.containsKey(string)) {
                    jCAFormatHandler = (JCAFormatHandler)this.fieldPartNameFormatHandlerMapping.get(string);
                } else {
                    jCAFormatHandler = (JCAFormatHandler)JCAUtil.getFormatHandler(part, this.fieldDefinition, this.fieldBinding);
                    this.fieldPartNameFormatHandlerMapping.put(string, jCAFormatHandler);
                }
                jCAFormatHandler.read(inputStream);
            }
            Trc.exit();
        }
        catch (Exception exception) {
            throw new IOException(JCAResource.get("IWAA0104E", exception.getLocalizedMessage()));
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            Trc.entry((Object)outputStream);
            Iterator iterator = this.getPartNames();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                Object v = this.parts.get(string);
                JCAFormatHandler jCAFormatHandler = null;
                if (v instanceof WSIFFormatPart_JCA && ((WSIFFormatPart_JCA)(object = (WSIFFormatPart_JCA)v))._getFormatHandler() != null) {
                    jCAFormatHandler = (JCAFormatHandler)((WSIFFormatPart_JCA)object)._getFormatHandler();
                    this.fieldPartNameFormatHandlerMapping.put(string, jCAFormatHandler);
                }
                if (jCAFormatHandler == null) {
                    if (this.fieldPartNameFormatHandlerMapping.containsKey(string)) {
                        jCAFormatHandler = (JCAFormatHandler)this.fieldPartNameFormatHandlerMapping.get(string);
                    } else {
                        if (this.fieldMessageModel == null) {
                            return;
                        }
                        object = this.fieldMessageModel.getPart(string);
                        jCAFormatHandler = (JCAFormatHandler)JCAUtil.getFormatHandler((Part)object, this.fieldDefinition, this.fieldBinding);
                        this.fieldPartNameFormatHandlerMapping.put(string, jCAFormatHandler);
                    }
                    jCAFormatHandler.setObjectPart(v);
                }
                jCAFormatHandler.write(outputStream);
            }
            Trc.exit();
        }
        catch (Exception exception) {
            throw new IOException(JCAResource.get("IWAA0105E", exception.getLocalizedMessage()));
        }
    }

    public Object getObjectPart(String string) {
        Object object;
        if (this.parts != null && (object = this.parts.get(string)) != null) {
            return object;
        }
        try {
            object = (JCAFormatHandler)this.fieldPartNameFormatHandlerMapping.get(string);
            if (object != null) {
                Object object2 = object.getObjectPart();
                this.setObjectPart(string, object2);
                return object2;
            }
            if (this.fieldMessageModel == null) {
                return null;
            }
            Part part = this.fieldMessageModel.getPart(string);
            object = (JCAFormatHandler)JCAUtil.getFormatHandler(part, this.fieldDefinition, this.fieldBinding);
            Object object3 = object.getObjectPart();
            this.setObjectPart(string, object3);
            return object3;
        }
        catch (Exception exception) {
            throw new RuntimeException(JCAResource.get("IWAA0107E", exception.getLocalizedMessage()));
        }
    }

    public Object getObjectPart(String string, Class clazz) {
        Object object;
        try {
            if (this.parts != null && (object = this.parts.get(string)) != null && clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = (JCAFormatHandler)this.fieldPartNameFormatHandlerMapping.get(string);
            if (object != null) {
                Object object2 = object.getObjectPart(clazz);
                this.setObjectPart(string, object2);
                return object2;
            }
            if (this.fieldMessageModel == null) {
                return null;
            }
            Part part = this.fieldMessageModel.getPart(string);
            object = (JCAFormatHandler)JCAUtil.getFormatHandler(part, this.fieldDefinition, this.fieldBinding);
            Object object3 = object.getObjectPart(clazz);
            this.setObjectPart(string, object3);
            return object3;
        }
        catch (Exception exception) {
            throw new RuntimeException(JCAResource.get("IWAA0107E", exception.getLocalizedMessage()));
        }
    }
}

