/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.ServantNotificationHandler;
import com.ibm.ws.sm.workspace.WorkSpaceJMXEvent;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.proxy.ConfigServiceManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class WorkSpaceManagerMBeanProxy
extends ProxyMBeanSupport
implements ServantNotificationHandler {
    private ServantMBeanInvoker mbeanInvoker = new ServantMBeanInvoker();
    private static Map workspaces = Collections.synchronizedMap(new HashMap());
    private static final TraceComponent tc = Tr.register(WorkSpaceManagerMBeanProxy.class, null, null);
    private static SelfListener self = new SelfListener();

    public WorkSpaceManagerMBeanProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkSpaceManagerMBeanProxy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkSpaceManagerMBeanProxy", self);
        }
    }

    protected static Map getWorkSpaces() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpaces");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpaces", workspaces);
        }
        return workspaces;
    }

    public void setObjectName(ObjectName name) {
        super.setObjectName(name);
    }

    protected static void setServantStoken(String workspaceID, String stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServantStoken", new Object[]{workspaceID, stoken});
        }
        workspaces.put(workspaceID, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServantStoken");
        }
    }

    public void handleServantNotification(Notification notification) {
        Object ev;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServantNotification", new Object[]{notification});
        }
        String type = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Notification Event", new Object[]{type});
        }
        if (type.equals("websphere.workspace.event") && (ev = notification.getUserData()) instanceof WorkSpaceJMXEvent) {
            WorkSpaceJMXEvent event2 = (WorkSpaceJMXEvent)ev;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WorkSpace event", new Object[]{new Integer(event2.getType())});
            }
            String id = event2.getWorkSpaceID();
            String stoken = event2.getStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ID / stoken", new Object[]{id, stoken});
            }
            switch (event2.getType()) {
                case 11: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WorkSpace created");
                    }
                    workspaces.put(id, stoken);
                    break;
                }
                case 10: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WorkSpace invalidated");
                    }
                }
                case 12: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WorkSpace removed");
                    }
                    workspaces.remove(id);
                    ConfigServiceManager.removeServantStoken(id, stoken);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Invalid type: " + event2.getType());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServantNotification", new Object[]{workspaces});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String eventType = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event type", eventType);
        }
        ServantMBeanStatus status = (ServantMBeanStatus)notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", status);
        }
        if (eventType.equals("websphere.ws390.servant.terminated")) {
            String servantStoken = status.getServantStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken", servantStoken);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before Removal: ", workspaces);
            }
            Map map = workspaces;
            synchronized (map) {
                Collection values = workspaces.values();
                values.remove(servantStoken);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After Removal: ", workspaces);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    private static class SelfListener
    implements NotificationListener {
        public SelfListener() {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "SelfListener");
                }
                try {
                    AdminService admin = AdminServiceFactory.getAdminService();
                    String node = admin.getNodeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node: ", node);
                    }
                    String proc = admin.getProcessName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Proc: ", proc);
                    }
                    String query = "WebSphere:*,type=WorkSpaceManager,node=" + node + ",process=" + proc;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Query: ", query);
                    }
                    ObjectName work = new ObjectName(query);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Work: ", work);
                    }
                    NotificationFilterSupport filter = new NotificationFilterSupport();
                    admin.addNotificationListenerExtended(work, this, filter, null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "SelfListener");
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws390.management.proxy.WorkSpaceManagerMBeanProxy.SelfListener", (String)"166", (Object)this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Error", e);
                }
            }
        }

        public void handleNotification(Notification notification, Object obj) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleNotification", new Object[]{notification, obj});
            }
        }
    }
}

