/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.ControlAdminService;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.util.PlatformHelper;

public class ServantUpNotifier
implements Runnable {
    private static TraceComponent tc = Tr.register(ServantUpNotifier.class, "Admin", null);
    private static PlatformHelper platformHelper = AdminServiceFactoryInitializer.getPlatformHelper();

    private ServantUpNotifier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyController() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyController " + AdminContext.peek());
        }
        if ((uuid = AdminContext.peek()) == null) {
            Class<ServantUpNotifier> clazz = ServantUpNotifier.class;
            synchronized (ServantUpNotifier.class) {
                new ServantUpNotifier().run();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            new ServantUpNotifier().run();
        }
        {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyController");
            }
            return;
        }
    }

    public void run() {
        block20: {
            String stoken;
            ControlAdminService controlAdmin;
            boolean controlAdminNotified;
            String uuid;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run " + AdminContext.peek());
                }
                uuid = AdminContext.peek();
                controlAdminNotified = false;
                controlAdmin = null;
                stoken = platformHelper.getServantToken();
                try {
                    controlAdmin = Utils.getControlAdminService();
                    if (controlAdmin != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got ControlAdminService", controlAdmin);
                        }
                        controlAdminNotified = true;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws390.management.ServantUpNotifier.run", (String)"131", (Object)this);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Servant up notifier error.  WLM initialization still in progress.", e);
                }
            }
            if (controlAdminNotified) {
                block19: {
                    AdminServiceImpl adminService = (AdminServiceImpl)AdminServiceFactory.getAdminService();
                    adminService.zOSInitComplete();
                    NotificationService notifService = adminService.getNotificationService();
                    String cell = adminService.getCellName();
                    String node = adminService.getNodeName();
                    String process = adminService.getProcessName();
                    ServerInfo serverInfo = new ServerInfo(null, cell, node, process, null, null, null);
                    try {
                        notifService.getDownstreamProcessManager().addDownstreamProcess(serverInfo);
                    }
                    catch (ConnectorException exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws390.management.ServantUpNotifier.run", (String)"169", (Object)this);
                        if (!tc.isDebugEnabled()) break block19;
                        Tr.debug(tc, "unable to add downstream process", exc);
                    }
                }
                try {
                    if (uuid == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invoking ControlAdminService", stoken);
                        }
                        if (platformHelper.isCRAJvm()) {
                            controlAdmin.startupAdjunctJVM(stoken);
                        } else {
                            controlAdmin.startupServantJVM(stoken);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Return from ControlAdminService");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not invoking ControlAdminService", stoken);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws390.management.ServantUpNotifier.run", (String)"179", (Object)this);
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Servant up notifier error.", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }
}

