/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public abstract class ProxyMBeanSupport
extends RuntimeCollaborator
implements NotificationListener {
    private static TraceComponent tc = Tr.register(ProxyMBeanSupport.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private HashSet servants = new HashSet();
    private HashSet adjuncts = new HashSet();
    protected ServantMBeanInvoker _mbeanInvoker = new ServantMBeanInvoker();

    public ProxyMBeanSupport(String mbeanType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", mbeanType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ProxyMBeanSupport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    protected Set currentServants() {
        return Collections.unmodifiableSet(this.servants);
    }

    protected Set currentAdjuncts() {
        return Collections.unmodifiableSet(this.adjuncts);
    }

    protected ServantMBeanInvoker getInvoker() {
        return this._mbeanInvoker;
    }

    protected void handleInternalNotification(Notification internalNotification) {
    }

    public final void handleNotification(Notification notification, Object obj) {
        block32: {
            boolean unregisterProxy;
            String eventType = notification.getType();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", eventType);
            }
            ServantMBeanStatus status = (ServantMBeanStatus)notification.getUserData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantMBeanStatus", status);
            }
            String servantStoken = status.getServantStoken();
            ObjectName proxyObjectName = this.getObjectName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean proxy objectName", proxyObjectName);
            }
            if (eventType.equals("websphere.ws390.servant.started")) {
                this.handleInternalNotification(notification);
            } else if (eventType.equals("websphere.ws390.adjunct.started")) {
                this.adjuncts.add(servantStoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjunct started", servantStoken);
                }
                this.handleInternalNotification(notification);
            } else if (eventType.equals("websphere.ws390.servant.wlm.queueable")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant WLMQueueable", servantStoken);
                }
                this.handleInternalNotification(notification);
            } else if (eventType.equals("websphere.ws390.servant.mbean.registered")) {
                this.servants.add(servantStoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added servant", servantStoken);
                }
                this.handleInternalNotification(notification);
            } else if (eventType.equals("websphere.ws390.servant.mbean.unregistered")) {
                this.servants.remove(servantStoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed servant", servantStoken);
                }
                this.handleInternalNotification(notification);
            } else if (eventType.equals("websphere.ws390.servant.terminated")) {
                this.servants.remove(servantStoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant terminated", servantStoken);
                }
                this.handleInternalNotification(notification);
            } else if (eventType.equals("websphere.ws390.adjunct.terminated")) {
                this.adjuncts.remove(servantStoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjunct terminated", servantStoken);
                }
                this.handleInternalNotification(notification);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unsupported event type", eventType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servants with MBean managed by " + proxyObjectName + " = " + this.servants);
            }
            if (this.servants.isEmpty() && (unregisterProxy = this.prepareToUnregister())) {
                try {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    MBeanServer mbServer = adminService.getMBeanFactory().getMBeanServer();
                    ControlAdminServiceImpl.getInstance().removeListener(proxyObjectName);
                    mbServer.unregisterMBean(proxyObjectName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MBean proxy  " + proxyObjectName + " was unregistered from control MBean server");
                    }
                }
                catch (InstanceNotFoundException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ProxyMBeanSupport.handleNotification", (String)"474", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdminService not found", ex);
                    }
                }
                catch (MBeanRegistrationException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ProxyMBeanSupport.handleNotification", (String)"481", (Object)this);
                    if (!tc.isDebugEnabled()) break block32;
                    Tr.debug(tc, "Unable to unregister proxy Mbean " + proxyObjectName, ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public String getName() {
        return this.zOSProxyMBeanGetName();
    }

    protected final String zOSProxyMBeanGetName() {
        String name = "";
        ObjectName servantObjectName = this.getObjectName();
        if (servantObjectName != null) {
            name = servantObjectName.getKeyProperty("name");
        }
        return name;
    }

    public String getType() {
        return this.zOSProxyMBeanGetType();
    }

    public String getApplication() {
        return this.zOSProxyMBeanGetApplication();
    }

    protected final String zOSProxyMBeanGetType() {
        String type = "";
        ObjectName servantObjectName = this.getObjectName();
        if (servantObjectName != null) {
            type = servantObjectName.getKeyProperty("type");
        }
        return type;
    }

    protected final String zOSProxyMBeanGetApplication() {
        String application = "";
        ObjectName servantObjectName = this.getObjectName();
        if (servantObjectName != null) {
            application = servantObjectName.getKeyProperty("Application");
        }
        return application;
    }

    protected boolean prepareToUnregister() {
        return true;
    }

    protected Object mbeanInvokerSpray(String methodName, Object[] params, String[] signatures, AggregationHandler[] resultAggregator, StateObject stateObject) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvokerSpray", new Object[]{methodName, params, signatures, resultAggregator});
        }
        Object retval = null;
        Vector servantResults = this._mbeanInvoker.invokeSpecifiedServants(this.servants, this.getObjectName(), methodName, params, signatures);
        if (resultAggregator != null && resultAggregator.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking aggregator");
            }
            Object tempResult = null;
            for (int i = 0; i < resultAggregator.length; ++i) {
                if (resultAggregator[i] != null) {
                    tempResult = resultAggregator[i].aggregateResults(methodName, params, signatures, servantResults.toArray(new ServantMBeanResult[0]), stateObject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from aggregator", tempResult);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current returnval", retval);
                }
                if (tempResult != null) {
                    retval = tempResult;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Return from aggregator", retval);
            }
        } else if (servantResults != null && servantResults.size() > 0) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)servantResults.elementAt(0);
            if (data.resultThrowable()) {
                Throwable t = (Throwable)data.getResult();
                if (t instanceof ConnectorException) {
                    throw this.processConnectorException((ConnectorException)t);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during _mbeanInvoker call", t);
                }
                throw t;
            }
            retval = data.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvokerSpray", retval);
        }
        return retval;
    }

    protected Object mbeanInvokerSpray(String methodName, Object[] params, String[] signatures, AggregationHandler resultAggregator, StateObject stateObject) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvokerSpray", new Object[]{methodName, params, signatures, resultAggregator});
        }
        Object retval = null;
        Vector servantResults = this._mbeanInvoker.invokeSpecifiedServants(this.servants, this.getObjectName(), methodName, params, signatures);
        if (resultAggregator != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking aggregator");
            }
            retval = resultAggregator.aggregateResults(methodName, params, signatures, servantResults.toArray(new ServantMBeanResult[0]), stateObject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from aggregator");
            }
        } else if (servantResults != null && servantResults.size() > 0) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)servantResults.elementAt(0);
            if (data.resultThrowable()) {
                Throwable t = (Throwable)data.getResult();
                if (t instanceof ConnectorException) {
                    throw this.processConnectorException((ConnectorException)t);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during _mbeanInvoker call", t);
                }
                throw t;
            }
            retval = data.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvokerSpray", retval);
        }
        return retval;
    }

    protected Object mbeanInvokerSpray(String methodName) throws Throwable {
        return this.mbeanInvokerSpray(methodName, null, null, (AggregationHandler[])null, null);
    }

    protected Object mbeanInvokerSimple(String methodName, Object[] params, String[] signatures) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvokerSimple", new Object[]{methodName, params, signatures});
        }
        Object retval = null;
        ServantMBeanInvokerData data = this._mbeanInvoker.invokeAnyServant(this.servants, this.getObjectName(), methodName, params, signatures);
        if (data.resultThrowable()) {
            Throwable t = (Throwable)data.getResult();
            if (t instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)t);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during _mbeanInvoker call", t);
            }
            throw t;
        }
        retval = data.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvokerSimple", retval);
        }
        return retval;
    }

    protected Object mbeanInvokerSimple(String methodName) throws Throwable {
        return this.mbeanInvokerSimple(methodName, null, null);
    }

    protected Object mbeanGetterSimple(String attributeName) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanGetterSimple", new Object[]{attributeName});
        }
        Object retval = null;
        ServantMBeanInvokerData data = this._mbeanInvoker.getAnyServantMBeanAttribute(this.servants, this.getObjectName(), attributeName);
        if (data.resultThrowable()) {
            Throwable t = (Throwable)data.getResult();
            if (t instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)t);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during _mbeanGetter call", t);
            }
            throw t;
        }
        retval = data.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanGetterSimple", retval);
        }
        return retval;
    }

    protected Object mbeanSetterSimple(String attributeName, Object attributeValue) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanSetterSimple", new Object[]{attributeName, attributeValue});
        }
        Object retval = null;
        Iterator iterator = this.servants.iterator();
        HashSet firstServant = new HashSet(1);
        firstServant.add(iterator.next());
        Vector servantResults = this._mbeanInvoker.setSpecifiedServantsMBeanAttribute(firstServant, this.getObjectName(), attributeName, attributeValue);
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)servantResults.elementAt(0);
        if (data.resultThrowable()) {
            Throwable t = (Throwable)data.getResult();
            if (t instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)t);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during _mbeanSetter call", t);
            }
            throw t;
        }
        retval = data.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanSetterSimple", retval);
        }
        return retval;
    }

    protected void mbeanSetterSpray(String attributeName, Object attributeValue) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanSetterSpray", new Object[]{attributeName, attributeValue});
        }
        Vector servantResults = this._mbeanInvoker.setSpecifiedServantsMBeanAttribute(this.servants, this.getObjectName(), attributeName, attributeValue);
        for (int i = 0; i < servantResults.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)servantResults.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantMBeanInvokerData", data);
            }
            if (!data.resultThrowable()) continue;
            Throwable t = (Throwable)data.getResult();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "mbeanSetterSpray error", t);
            }
            if (t instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)t);
            }
            throw t;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanSetterSpray");
        }
    }

    public String getObjectNameStr() {
        return this.getObjectName().toString();
    }

    protected Throwable processConnectorException(ConnectorException connExc) {
        Throwable cause;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConnectorException", connExc);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectorException caught during _mbeanInvoker call", connExc);
        }
        if ((cause = connExc.getCause()) instanceof MBeanException) {
            cause = ((MBeanException)cause).getTargetException();
        } else if (cause instanceof RuntimeMBeanException) {
            cause = ((RuntimeMBeanException)cause).getTargetException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cause", cause);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processConnectorException");
        }
        return cause;
    }

    protected void proxyHelperTraceThrowable(String operation, ServantMBeanInvokerData data, TraceComponent proxyTc) {
        if (proxyTc.isEventEnabled() && data.resultThrowable()) {
            Tr.event(proxyTc, "Error invoking servant MBean: servant = " + data.getStoken() + ", operation = " + operation + ",MBean = " + this.getObjectName(), data.getResult());
        }
    }

    protected void proxyHelperTraceThrowables(String operation, Vector dataVector, TraceComponent proxyTc) {
        if (proxyTc.isEventEnabled()) {
            for (int i = 0; i < dataVector.size(); ++i) {
                ServantMBeanInvokerData data = (ServantMBeanInvokerData)dataVector.elementAt(i);
                if (!data.resultThrowable()) continue;
                Tr.event(proxyTc, "Error invoking servant MBean: servant = " + data.getStoken() + ", operation = " + operation + ",MBean = " + this.getObjectName(), data.getResult());
            }
        }
    }

    public Object getValueFromAnyServant(String operationName, Object[] parms, String[] sig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueFromAnyServant", operationName);
        }
        Object value = null;
        Set servants = this.currentServants();
        Iterator iterator = servants.iterator();
        while (value == null && iterator.hasNext()) {
            ServantMBeanInvokerData data;
            Object result;
            String stoken = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken for _mbeanInvoker", stoken);
            }
            if ((result = (data = this._mbeanInvoker.invokeSpecificServant(stoken, this.getObjectName(), operationName, parms, sig)).getResult()) instanceof Throwable) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception driving _mbeanInvoker", (Throwable)result);
                continue;
            }
            value = result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueFromAnyServant", value);
        }
        return value;
    }

    public Object getAttributeValueFromAnyServant(String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeValueFromAnyServant", attributeName);
        }
        Object value = null;
        ServantMBeanInvokerData data = this._mbeanInvoker.getAnyServantMBeanAttribute(this.currentServants(), this.getObjectName(), attributeName);
        Object result = data.getResult();
        if (data.resultThrowable()) {
            if (tc.isEventEnabled()) {
                this.proxyHelperTraceThrowable("getAttribute: " + attributeName, data, tc);
            }
        } else {
            value = result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeValueFromAnyServant", value);
        }
        return value;
    }

    public Object getValueFromAnyServantWithException(String operationName, Object[] parms, String[] sig) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueFromAnyServant", operationName);
        }
        Object value = null;
        Set servants = this.currentServants();
        Iterator iterator = servants.iterator();
        while (value == null && iterator.hasNext()) {
            String stoken = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken for _mbeanInvoker", stoken);
            }
            ServantMBeanInvokerData data = this._mbeanInvoker.invokeSpecificServant(stoken, this.getObjectName(), operationName, parms, sig);
            Object result = data.getResult();
            if (data.resultThrowable()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception driving _mbeanInvoker", (Throwable)result);
                }
                if (result instanceof ConnectorException) {
                    throw this.processConnectorException((ConnectorException)result);
                }
                throw (Throwable)result;
            }
            value = result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueFromAnyServant", value);
        }
        return value;
    }

    public Object getAttributeValueFromAnyServantWithException(String attributeName) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeValueFromAnyServant", attributeName);
        }
        Object value = null;
        ServantMBeanInvokerData data = this._mbeanInvoker.getAnyServantMBeanAttribute(this.currentServants(), this.getObjectName(), attributeName);
        Object result = data.getResult();
        if (data.resultThrowable()) {
            if (tc.isEventEnabled()) {
                this.proxyHelperTraceThrowable("getAttribute: " + attributeName, data, tc);
            }
            if (result instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)result);
            }
            throw (Throwable)result;
        }
        value = result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeValueFromAnyServant", value);
        }
        return value;
    }
}

