/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import [Ljava.lang.Object;;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.ComponentDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ArrayDeserializer
extends ComponentDeserializer {
    protected static Log log = LogFactory.getLog((String)ArrayDeserializer.class.getName());
    public QName arrayType = null;
    public int curIndex = 0;
    QName defaultItemType;
    int length;
    Class arrayClass = null;
    ArrayList mDimLength = null;
    ArrayList mDimFactor = null;
    QName componentTypeQName = null;
    QName componentQName = null;

    public ArrayDeserializer(Class clazz, QName qName) {
        this(clazz, qName, null, null);
    }

    public ArrayDeserializer(Class clazz, QName qName, QName qName2, QName qName3) {
        super(clazz, qName);
        this.componentQName = qName2;
        this.componentTypeQName = qName3;
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        int n;
        Object object;
        Object object2;
        QName qName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ArrayDeserializer::startElement()");
        }
        if ((qName = AttributeUtils.getTypeFromAttributes((String)string, (String)string2, (Attributes)attributes, (MappingScope)mappingScope)) == null) {
            qName = this.getDefaultType();
        }
        if (qName != null && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = null;
        }
        String string4 = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "arrayType");
        QName qName2 = null;
        if (string4 != null) {
            qName2 = QNameTable.createQName(string4, mappingScope);
        }
        String string5 = null;
        QName qName3 = null;
        String string6 = "";
        if (qName2 != null) {
            object2 = qName2.getNamespaceURI();
            object = qName2.getLocalPart();
            n = ((String)object).lastIndexOf(91);
            int n2 = ((String)object).lastIndexOf(93);
            if (n == -1 || n2 == -1 || n2 < n) {
                throw new IllegalArgumentException(Messages.getMessage((String)"badArrayType00", (String)("" + qName2)));
            }
            string5 = ((String)object).substring(n + 1, n2);
            if (((String)(object = ((String)object).substring(0, n))).endsWith("]")) {
                this.defaultItemType = Constants.SOAP_ARRAY;
                qName3 = QNameTable.createQName((String)object2, ((String)object).substring(0, ((String)object).indexOf("[")));
                string6 = ((String)object).substring(((String)object).indexOf("["));
            } else {
                this.defaultItemType = QNameTable.createQName((String)object2, (String)object);
            }
        }
        if (this.defaultItemType == null) {
            this.defaultItemType = this.componentTypeQName;
        }
        if (this.defaultItemType == null && qName == null) {
            this.defaultItemType = Constants.XSD_ANYTYPE;
        }
        this.arrayClass = null;
        if (qName != null) {
            this.arrayClass = deserializationContext.getTypeMapping().getClassForQName(qName);
        } else if (this.javaType != null && !this.javaType.equals(Object;.class) && this.javaType.isArray()) {
            this.arrayClass = this.javaType;
        } else {
            Class clazz;
            object2 = this.defaultItemType;
            object = "[]";
            if (qName3 != null) {
                object2 = qName3;
                object = (String)object + string6;
            }
            if ((clazz = deserializationContext.getTypeMapping().getClassForQName((QName)object2)) != null) {
                try {
                    Object object3 = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return clazz.getClassLoader();
                            }
                            catch (Throwable throwable) {
                                return throwable;
                            }
                        }
                    });
                    ClassLoader classLoader = null;
                    if (object3 instanceof ClassLoader) {
                        classLoader = (ClassLoader)object3;
                    }
                    if (classLoader == null) {
                        this.arrayClass = ClassUtils.forName((String)JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(clazz.getName()) + (String)object));
                    } else {
                        try {
                            this.arrayClass = ClassUtils.forName((String)JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(clazz.getName()) + (String)object), (boolean)true, (ClassLoader)classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.arrayClass = ClassUtils.forName((String)JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(clazz.getName()) + (String)object));
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.onStartElement", (String)"276", (Object)this);
                    throw new SAXException(Messages.getMessage((String)"noComponent00", (String)("" + this.defaultItemType)));
                }
            }
        }
        if (this.arrayClass == null) {
            throw new SAXException(Messages.getMessage((String)"noComponent00", (String)("" + this.defaultItemType)));
        }
        if (string5 == null || string5.length() == 0) {
            this.value = new ArrayListExtension(this.arrayClass);
        } else {
            try {
                object2 = new StringTokenizer(string5, "[],");
                this.length = Integer.parseInt(((StringTokenizer)object2).nextToken());
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    this.mDimLength = new ArrayList();
                    this.mDimLength.add(new Integer(this.length));
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        this.mDimLength.add(new Integer(Integer.parseInt(((StringTokenizer)object2).nextToken())));
                    }
                }
                object = new ArrayListExtension(this.arrayClass, this.length);
                for (n = 0; n < this.length; ++n) {
                    ((ArrayList)object).add(null);
                }
                this.value = object;
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.onStartElement", (String)"330", (Object)this);
                throw new IllegalArgumentException(Messages.getMessage((String)"badInteger00", (String)string5));
            }
        }
        object2 = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "offset");
        if (object2 != null) {
            int n3 = ((String)object2).lastIndexOf(91);
            n = ((String)object2).lastIndexOf(93);
            if (n3 == -1 || n == -1 || n < n3) {
                throw new SAXException(Messages.getMessage((String)"badOffset00", (String)object2));
            }
            this.curIndex = this.convertToIndex(((String)object2).substring(n3 + 1, n), "badOffset00");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: ArrayDeserializer::startElement()");
        }
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        String string4;
        Deserializer deserializer;
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ArrayDeserializer.onStartChild()");
        }
        if (attributes != null) {
            object = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "position");
            if (object != null) {
                int n = ((String)object).lastIndexOf(91);
                int n2 = ((String)object).lastIndexOf(93);
                if (n == -1 || n2 == -1 || n2 < n) {
                    throw new SAXException(Messages.getMessage((String)"badPosition00", (String)object));
                }
                this.curIndex = this.convertToIndex(((String)object).substring(n + 1, n2), "badPosition00");
            }
            if (AttributeUtils.isNil((Attributes)attributes)) {
                this.setChildValue(null, this.curIndex++);
                return new NOOPProcessor();
            }
        }
        if ((object = AttributeUtils.getTypeFromAttributes((String)string, (String)string2, (Attributes)attributes, (MappingScope)mappingScope)) == null) {
            object = this.defaultItemType;
        }
        Class<?> clazz = null;
        if (this.arrayClass != null && !this.arrayClass.equals(Object;.class) && this.arrayClass.isArray()) {
            clazz = this.arrayClass.getComponentType();
            if (this.defaultType == null) {
                this.defaultType = deserializationContext.getTypeMapping().getTypeQName(clazz);
            }
        }
        if ((deserializer = this.getDeserializer((QName)object, clazz, string4 = attributes.getValue("href"), deserializationContext)) == null) {
            deserializer = this.getDeserializer((QName)object, null, string4, deserializationContext);
        }
        deserializer.registerValueTarget(new DeserializerTarget(this, new Integer(this.curIndex)));
        this.addChildDeserializer(deserializer, string4);
        ++this.curIndex;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: ArrayDeserializer.onStartChild()");
        }
        return deserializer;
    }

    public void onSimpleChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, String string4) throws SAXException {
        Object object;
        Class<?> clazz = null;
        if (this.arrayClass != null && this.arrayClass.isArray()) {
            clazz = this.arrayClass.getComponentType();
        }
        if (clazz == null || clazz != String.class && !clazz.isPrimitive()) {
            super.onSimpleChild(string, string2, string3, attributes, mappingScope, deserializationContext, string4);
            return;
        }
        try {
            object = SimpleDeserializer.convert(string4, clazz);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.onSimpleChild", (String)"518", (Object)this);
            throw new SAXException(exception);
        }
        this.setChildValue(object, this.curIndex);
        ++this.curIndex;
    }

    public void setValue(Object object, Object object2) throws SAXException {
        if (object2 instanceof Integer) {
            this.setChildValue(object, (Integer)object2);
        } else {
            super.setValue(object, object2);
        }
    }

    public void setChildValue(Object object, int n) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ArrayDeserializer::setChildValue(" + object + ", " + n + ")"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (this.mDimLength == null) {
            while (arrayList.size() <= n) {
                arrayList.add(null);
            }
            arrayList.set(n, object);
        } else {
            ArrayList arrayList2 = this.toMultiIndex(n);
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                int n2 = (Integer)this.mDimLength.get(i);
                int n3 = (Integer)arrayList2.get(i);
                while (arrayList.size() < n2) {
                    arrayList.add(null);
                }
                if (i < this.mDimLength.size() - 1) {
                    if (arrayList.get(n3) == null) {
                        arrayList.set(n3, new ArrayList());
                    }
                    arrayList = (ArrayList)arrayList.get(n3);
                    continue;
                }
                arrayList.set(n3, object);
            }
        }
    }

    public void valueComplete() throws SAXException {
        if (this.componentsReady()) {
            try {
                if (this.arrayClass != null) {
                    this.value = JavaUtils.convert(this.value, this.arrayClass);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        super.valueComplete();
    }

    private int convertToIndex(String string, String string2) throws SAXException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[],");
        int n = 0;
        try {
            if (this.mDimLength == null) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    throw new SAXException(Messages.getMessage((String)string2, (String)string));
                }
            } else {
                int n2 = -1;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    if (++n2 >= this.mDimLength.size()) {
                        throw new SAXException(Messages.getMessage((String)string2, (String)string));
                    }
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n3 < 0 || n3 >= (Integer)this.mDimLength.get(n2)) {
                        throw new SAXException(Messages.getMessage((String)string2, (String)string));
                    }
                    arrayList.add(new Integer(n3));
                }
                n = this.toSingleIndex(arrayList);
            }
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.convertToIndex", (String)"679", (Object)this);
            throw sAXException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.convertToIndex", (String)"682", (Object)this);
            throw new SAXException(Messages.getMessage((String)string2, (String)string));
        }
        return n;
    }

    private ArrayList toMultiIndex(int n) {
        int n2;
        int n3;
        if (this.mDimLength == null) {
            return null;
        }
        if (this.mDimFactor == null) {
            this.mDimFactor = new ArrayList();
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                n3 = 1;
                for (n2 = i + 1; n2 < this.mDimLength.size(); ++n2) {
                    n3 *= ((Integer)this.mDimLength.get(n2)).intValue();
                }
                this.mDimFactor.add(new Integer(n3));
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < this.mDimLength.size(); ++n3) {
            n2 = (Integer)this.mDimFactor.get(n3);
            arrayList.add(new Integer(n / n2));
            n %= n2;
        }
        return arrayList;
    }

    private int toSingleIndex(ArrayList arrayList) {
        int n;
        int n2;
        if (this.mDimLength == null || arrayList == null) {
            return -1;
        }
        if (this.mDimFactor == null) {
            this.mDimFactor = new ArrayList();
            for (n2 = 0; n2 < this.mDimLength.size(); ++n2) {
                n = 1;
                for (int i = n2 + 1; i < this.mDimLength.size(); ++i) {
                    n *= ((Integer)this.mDimLength.get(i)).intValue();
                }
                this.mDimFactor.add(new Integer(n));
            }
        }
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            n2 += (Integer)this.mDimFactor.get(n) * (Integer)arrayList.get(n);
        }
        return n2;
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.arrayType = null;
            this.curIndex = 0;
            this.defaultItemType = null;
            this.length = 0;
            this.arrayClass = null;
            this.mDimLength = null;
            this.mDimFactor = null;
        }
        return bl;
    }

    public class ArrayListExtension
    extends ArrayList
    implements JavaUtils.ConvertCache {
        private HashMap table;
        private Class arrayClass;

        ArrayListExtension(Class clazz) {
            this.table = null;
            this.arrayClass = null;
            this.arrayClass = clazz;
            if (clazz == null || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                clazz = null;
            }
        }

        ArrayListExtension(Class clazz, int n) {
            super(n);
            this.table = null;
            this.arrayClass = null;
            this.arrayClass = clazz;
            if (clazz == null || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                clazz = null;
            }
        }

        public void setConvertedValue(Class clazz, Object object) {
            if (this.table == null) {
                this.table = new HashMap();
            }
            this.table.put(clazz, object);
        }

        public Object getConvertedValue(Class clazz) {
            if (this.table == null) {
                return null;
            }
            return this.table.get(clazz);
        }

        public Class getDestClass() {
            return this.arrayClass;
        }
    }
}

