/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.facade.IFacade;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SRTRequestContext
implements Cloneable {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTRequestContext";
    private Hashtable webappToSessionMap;
    private SRTServletRequest request;
    private Stack boundaries = new Stack();

    public SRTRequestContext(SRTServletRequest request) {
        this.request = request;
        this.webappToSessionMap = new Hashtable();
    }

    public void sessionPreInvoke(WebApp webapp) {
        HttpSession session = (HttpSession)this.webappToSessionMap.get(webapp);
        if (session == null && (session = webapp.getSessionContext().sessionPreInvoke(this.request, (HttpServletResponse)((Object)this.request.getResponse()))) != null) {
            this.webappToSessionMap.put(webapp, session);
        }
    }

    public boolean isRequestedSessionIdValid(WebApp webapp) {
        HttpSession session = this.getSession(false, webapp);
        return webapp.getSessionContext().isRequestedSessionIdValid(this.request, session);
    }

    public void sessionPostInvoke() {
    }

    public HttpSession getSession(boolean arg0, WebApp webapp) {
        SRTServletRequest localrequest = this.request;
        HttpSession session = (HttpSession)this.webappToSessionMap.get(webapp);
        if (session != null && webapp.getSessionContext().isValid(session, localrequest)) {
            return (HttpSession)((IFacade)((Object)session)).getFacade();
        }
        session = webapp.getSessionContext().getIHttpSession(localrequest, (HttpServletResponse)((Object)this.request.getResponse()), arg0);
        if (session == null) {
            return null;
        }
        this.webappToSessionMap.put(webapp, session);
        return (HttpSession)((IFacade)((Object)session)).getFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            Enumeration webapps = this.webappToSessionMap.keys();
            while (webapps.hasMoreElements()) {
                WebApp wa = (WebApp)webapps.nextElement();
                HttpSession s = (HttpSession)this.webappToSessionMap.get(wa);
                IHttpSessionContext ctx = wa.getSessionContext();
                if (ctx != null) {
                    wa.getSessionContext().sessionPostInvoke(s);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "finish", "Session Context was null so session data will not be persisted.");
            }
        }
        finally {
            this.webappToSessionMap.clear();
            this.boundaries.clear();
        }
    }

    public String encodeURL(WebApp webapp, HttpServletRequest request, String arg0) {
        HttpSession session = (HttpSession)this.webappToSessionMap.get(webapp);
        if (session != null) {
            return webapp.getSessionContext().encodeURL(session, request, arg0);
        }
        return arg0;
    }

    public void setCurrWebAppBoundary(WebApp webapp) {
        this.boundaries.push(webapp);
    }

    public void rollBackBoundary() {
        this.boundaries.pop();
    }

    public boolean isWithinModule(WebApp app) {
        WebApp currWebAppBoundary = (WebApp)this.boundaries.peek();
        return currWebAppBoundary.equals(app);
    }

    public boolean isWithinApplication(WebApp app) {
        WebApp currWebAppBoundary = (WebApp)this.boundaries.peek();
        return currWebAppBoundary.getApplicationName().equals(app.getApplicationName());
    }

    protected Object clone(SRTServletRequest clonedRequest) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " entry");
        }
        SRTRequestContext clonedRequestContext = (SRTRequestContext)super.clone();
        if (this.boundaries != null) {
            clonedRequestContext.boundaries = (Stack)this.boundaries.clone();
        }
        if (this.webappToSessionMap != null) {
            clonedRequestContext.webappToSessionMap = (Hashtable)this.webappToSessionMap.clone();
        }
        clonedRequestContext.request = clonedRequest;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " exit original -->" + this + " clone -->" + clonedRequestContext);
        }
        return clonedRequestContext;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " entry");
        }
        this.request = null;
        this.webappToSessionMap = null;
        this.boundaries = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }
}

