/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory;
import com.ibm.ws.naming.util.JndiLookupInfoRefAddr;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ResRefJndiLookupInfo;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ResRefJndiLookupObjectFactory
implements ObjectFactory {
    private static final String PROVIDER_URL_KEY = "java.naming.provider.url";
    private static final String ADDR_TYPE = "ResRefJndiLookupInfo";
    private static final TraceComponent tc = Tr.register(ResRefJndiLookupObjectFactory.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String METHOD_getObjectInstance = "getObjectInstance()";

    public ResRefJndiLookupObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ResRefJndiLookupObjectFactory() - Ctor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object tobj, Name tname, Context tnameCtx, Hashtable tenv) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, METHOD_getObjectInstance);
        }
        Object o = null;
        Object obj = tobj;
        Name name = tname;
        Context nameCtx = tnameCtx;
        Hashtable env = tenv;
        ResRefJndiLookupObjectFactory thisObject = this;
        String thisClassName = this.getClass().getName();
        Object retObj = null;
        Object clonedEnv = null;
        if (!(obj instanceof Reference)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, METHOD_getObjectInstance, obj + " is not a Reference");
            }
            return retObj;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(thisClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, METHOD_getObjectInstance, "this is not the right factory for this Reference: " + obj);
            }
            return retObj;
        }
        RefAddr addr = ref.get(ADDR_TYPE);
        if (addr == null) {
            NullRefAddrException ne = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, METHOD_getObjectInstance, "Get NullRefAddrException!");
            }
            throw ne;
        }
        ResRefJndiLookupInfo info = (ResRefJndiLookupInfo)addr.getContent();
        IndirectJndiLookupObjectFactory indirectJndiLookupObjectFactory = new IndirectJndiLookupObjectFactory();
        ContainerComponentMetaData cmd = (ContainerComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        Reference ref2 = new Reference("java.lang.Object", (RefAddr)new JndiLookupInfoRefAddr(info.getJndiLookupInfo()), IndirectJndiLookupObjectFactory.class.getName(), null);
        ResRefList rrl = cmd.getResourceRefList();
        String lookUpName = info.getName();
        ResRefList resRefList = rrl;
        synchronized (resRefList) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Look up of Res-Ref with name: " + lookUpName);
            }
            rrl.setLookupString(lookUpName);
            try {
                o = indirectJndiLookupObjectFactory.getObjectInstance((Object)ref2, null, null, null);
            }
            catch (NameNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getObjectInstance() with javax.naming.NameNotFoundException");
                }
                throw e;
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getObjectInstance() with " + e);
                }
                throw e;
            }
            finally {
                rrl.setLookupString(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (o == null) {
                        Tr.debug(tc, "Look up of Res-Ref with name: " + lookUpName + " failed.");
                    } else {
                        Tr.debug(tc, "Look up of Res-Ref with name: " + lookUpName + " successful.");
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, METHOD_getObjectInstance);
        }
        return o;
    }
}

