/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerStatusValidator
extends GenericValidator {
    private String sProfileName = null;
    private final String S_WIN = "Win";
    private final String S_OS400 = "OS/400";
    private final String S_ALL = "-all";
    private final String S_BAD_CREDENTIAL_USERNAME_ARG = "-username";
    private final String S_BAD_CREDENTIAL_PASSWORD_ARG = "-password";
    private final String S_BAD_CREDENTIAL = " ";
    private final String S_BIN = "bin";
    private final String S_STOPPED = "STOPPED";
    private final String S_UNAVAILABLE = "UNAVAILABLE";
    private final String S_OS_NAME = System.getProperty("os.name");
    private final String S_SERVERSTATUS_BAT = "serverStatus.bat";
    private final String S_SERVERSTATUS_SH = "serverStatus.sh";
    private final String S_SERVERSTATUS_OS400 = "serverStatus";
    private final String S_SECURITYLOGINFAILED_KEY = "ADMU0002E";
    private final String S_SERVERSTARTED_KEY = "ADMU0508I";
    private static final String S_RESOURCE_BUNDLE = "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle";
    private static final String S_CLASS_NAME = ServerStatusValidator.class.getName();
    private static final Logger LOGGER = LoggerFactory.createLogger(ServerStatusValidator.class);

    public boolean runValidator() {
        LOGGER.entering(ServerStatusValidator.class.getName(), "runValidator");
        ResourceBundle rb = ResourceBundle.getBundle(S_RESOURCE_BUNDLE);
        this.sProfileName = System.getProperty("profileName");
        boolean result = false;
        try {
            result = this.sProfileName != null ? !this.isProfileRunning(this.sProfileName) : true;
        }
        catch (WSProfileException wpe) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "WSProfileException - getting profile path");
            LogUtils.logException(LOGGER, wpe);
            this.sErrorMessage = rb.getString("validate.serverstatus.error");
        }
        catch (FileNotFoundException fofe) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "FileNotFoundException - serverstatus executable in the bin directory of profile location");
            LogUtils.logException(LOGGER, fofe);
            this.sErrorMessage = rb.getString("validate.serverstatus.error");
        }
        catch (IOException ioe) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "IOException - running serverstatus command");
            LogUtils.logException(LOGGER, ioe);
            this.sErrorMessage = rb.getString("validate.serverstatus.error");
        }
        if (!result) {
            this.sErrorMessage = rb.getString("validate.serverstatus.started");
        }
        LOGGER.exiting(ServerStatusValidator.class.getName(), "runValidator");
        return result;
    }

    private boolean isProfileRunning(String profileName) throws WSProfileException, IOException {
        LOGGER.entering(ServerStatusValidator.class.getName(), "isProfileRunning");
        boolean profileRunning = false;
        try {
            String line;
            String serverstatusFileName;
            File fProfileLocation = null;
            fProfileLocation = WSProfile.getProfileLocation(profileName);
            String sProfileLocation = fProfileLocation.getAbsolutePath();
            if (this.S_OS_NAME.startsWith("Win")) {
                serverstatusFileName = "serverStatus.bat";
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isProfileRunning", "Resolved server status script to be: serverStatus.bat");
            } else if (this.S_OS_NAME.startsWith("OS/400")) {
                serverstatusFileName = "serverStatus";
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isProfileRunning", "Resolved server status script to be: serverStatus");
            } else {
                serverstatusFileName = "serverStatus.sh";
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isProfileRunning", "Resolved server status script to be: serverStatus.sh");
            }
            String command = sProfileLocation + File.separator + "bin" + File.separator + serverstatusFileName;
            String[] cmdArray = new String[]{command, "-all", "-username", " ", "-password", " "};
            for (int i = 0; i < cmdArray.length; ++i) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "isProfileRunning", cmdArray[i]);
            }
            Process myProcess = Runtime.getRuntime().exec(cmdArray);
            BufferedReader brdr = new BufferedReader(new InputStreamReader(myProcess.getInputStream()));
            while ((line = brdr.readLine()) != null) {
                if (line.indexOf(this.S_SERVERSTARTED_KEY) <= -1 && line.indexOf(this.S_SECURITYLOGINFAILED_KEY) <= -1) continue;
                if (line.indexOf("STOPPED") > -1 || line.indexOf("UNAVAILABLE") > -1) {
                    profileRunning = false;
                    continue;
                }
                profileRunning = true;
                break;
            }
            brdr.close();
        }
        catch (IOException e) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isProfileRunning", "Unable to access server status executable. The server is assumed to be not running.");
            LogUtils.logException(LOGGER, e);
        }
        LOGGER.exiting(ServerStatusValidator.class.getName(), "isProfileRunning");
        return profileRunning;
    }

    public boolean doIRun() {
        LOGGER.entering(ServerStatusValidator.class.getName(), "doIRun");
        String sProfileName = System.getProperty("profileName");
        if (sProfileName != null) {
            LOGGER.exiting(ServerStatusValidator.class.getName(), "doIRun");
            this.bDoIRun = true;
            return true;
        }
        LOGGER.exiting(ServerStatusValidator.class.getName(), "doIRun");
        this.bDoIRun = false;
        return false;
    }
}

