/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.io.file.NativeFile;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.registry.ProfileBackup;
import com.ibm.ws.profile.registry.ProfileRegistrySnippetMarshaller;
import com.ibm.ws.profile.utils.BackupProfileSnippetMarshallerUtils;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.DiskSpaceValidator;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestoreProfileValidator
extends GenericValidator {
    private static final Logger LOGGER = LoggerFactory.createLogger(RestoreProfileValidator.class);
    private static final String S_CLASS_NAME = RestoreProfileValidator.class.getName();
    private static final String S_WAS_HOME = "WAS_HOME";

    public boolean runValidator() throws Exception {
        LOGGER.entering(DiskSpaceValidator.class.getName(), "runValidator");
        String sBackupFile = System.getProperty("backupFile");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "profilePath:" + sBackupFile);
        if (sBackupFile == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("BackupProfileValidator.noBackupFile", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            return false;
        }
        FileUtils.intializeNativeFileFunctionality();
        if (FileUtils.isNativeFileFunctionalityAvailable()) {
            InputStream isBackupProfileSnippet = FileUtils.getInputStreamFromZipFile(sBackupFile, "profileBackupSnippet.xml");
            InputStream isProfileRegistrySnippet = FileUtils.getInputStreamFromZipFile(sBackupFile, "profileRegistrySnippet.xml");
            Profile profileToBeRestored = ProfileRegistrySnippetMarshaller.readProfileFromRegistrySnippetInputStream(isProfileRegistrySnippet);
            ProfileBackup profileBackup = BackupProfileSnippetMarshallerUtils.readFileSnippetInputStream(isBackupProfileSnippet);
            double freeSpace = 0.0;
            NativeFile backupProfile = new NativeFile(profileToBeRestored.getPath());
            long profileFileSize = Long.parseLong(profileBackup.getProfileSize());
            freeSpace = FileUtils.convertBytesToMB(backupProfile.getFreeSpace());
            if (freeSpace < Double.longBitsToDouble(profileFileSize)) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.insufficient", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                return false;
            }
            if (backupProfile.exists()) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("RestoreProfileValidator.profileExists", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            if (backupProfile.createNewFile()) {
                backupProfile.delete();
            }
            try {
                new WSProfileTemplate(profileToBeRestored.getWSProfileTemplate().getProfileTemplatePath());
            }
            catch (WSProfileException e) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("RestoreProfileValidator.profileTemplateDoesNotExist", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            try {
                for (int i = 0; i < profileToBeRestored.getAugmentationTemplates().size(); ++i) {
                    String augmentTemplate = profileToBeRestored.getAugmentationTemplates().get(i).getProfileTemplatePath().getPath();
                    new WSProfileTemplate(augmentTemplate);
                }
            }
            catch (WSProfileException e) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("RestoreProfileValidator.augmentTemplateDoesNotExist", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            String wasHome = profileBackup.getWASHome();
            if (!System.getProperty(S_WAS_HOME).equals(wasHome)) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("RestoreProfileValidator.profileWASHome", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFile functionality is not available");
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(RestoreProfileValidator.class.getName(), "runValidator");
            return false;
        }
        return true;
    }
}

