/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonRootUserValidator
extends GenericValidator {
    protected final String S_NO_WRITE_PERMISSIONS = "nonRootUserValidation.writeAccess";
    protected final String S_NO_READ_PERMISSIONS = "nonRootUserValidation.readAccess";
    protected final String S_FSDB_DIR = "fsdb";
    protected final String S_PROFILEMENU = "Profiles.menu";
    protected final String S_SPACE = " ";
    protected final String S_NEWLINE = "\n";
    protected final String S_TAB = "               ";
    protected final String S_LARGE_TAB = "                   ";
    protected final String S_DASH = "-";
    protected final String S_USER_NAME_KEY = "user.name";
    protected final String S_FILE_SEPERATOR = File.separator;
    protected String S_UNREADABLE_PATH = "";
    private static final String S_CLASS_NAME = NonRootUserValidator.class.getName();
    private static final Logger LOGGER = LoggerFactory.createLogger(NonRootUserValidator.class);

    public boolean runValidator() throws WSProfileException {
        Iterator itr;
        LOGGER.entering(NonRootUserValidator.class.getName(), "runValidator");
        String sUserName = System.getProperty("user.name");
        boolean fResult = true;
        Vector<String> vUnwritablePaths = new Vector<String>();
        Vector<String> vUnreadablePaths = new Vector<String>();
        if (WASUtilities.isWindows()) {
            LOGGER.exiting(NonRootUserValidator.class.getName(), "runValidator");
            return fResult;
        }
        File[] filesToWriteCheck = this.getFilesForWriteCheck();
        File[] filesToRecursivelyReadCheck = this.getFilesForRecursivelyReadCheck();
        File[] filesToReadCheck = this.getFilesForReadCheck();
        for (int j = 0; j < filesToRecursivelyReadCheck.length; ++j) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Checking if the " + sUserName + " user ID has read permission to the following path: " + filesToRecursivelyReadCheck[j].getAbsolutePath());
            if (this.isRecursivelyReadable(filesToRecursivelyReadCheck[j])) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runValidator", "The " + sUserName + " user ID does not have read permission to the following path: " + this.S_UNREADABLE_PATH);
            vUnreadablePaths.add(this.S_UNREADABLE_PATH);
        }
        for (int k = 0; k < filesToReadCheck.length; ++k) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Checking if the " + sUserName + " user ID has read permission to the following path: " + filesToReadCheck[k].getAbsolutePath());
            if (this.isReadable(filesToReadCheck[k])) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runValidator", "The " + sUserName + " user ID does not have read permission to the following path: " + filesToReadCheck[k].getAbsolutePath());
            vUnreadablePaths.add(filesToReadCheck[k].getAbsolutePath());
        }
        for (int i = 0; i < filesToWriteCheck.length; ++i) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Checking if the " + sUserName + " user ID has write permission to the following path: " + filesToWriteCheck[i].getAbsolutePath());
            if (this.isPathWritable(filesToWriteCheck[i])) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runValidator", "The " + sUserName + " user ID does not have write permission to: " + filesToWriteCheck[i].getAbsolutePath());
            vUnwritablePaths.add(filesToWriteCheck[i].getAbsolutePath());
        }
        if (!vUnreadablePaths.isEmpty()) {
            StringBuffer sbErrorMessage = new StringBuffer(ResourceBundleUtils.getResourceBundleLocaleString("nonRootUserValidation.readAccess", "\"" + sUserName + "\"", ResourceBundle.getBundle("com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle")));
            itr = vUnreadablePaths.iterator();
            while (itr.hasNext()) {
                sbErrorMessage.append("\n");
                sbErrorMessage.append("                   ");
                sbErrorMessage.append("-");
                sbErrorMessage.append(" ");
                sbErrorMessage.append((String)itr.next());
            }
            this.sErrorMessage = sbErrorMessage.toString();
            fResult = false;
        }
        if (!vUnwritablePaths.isEmpty()) {
            StringBuffer sbErrorMessage;
            if (this.sErrorMessage == null || this.sErrorMessage.isEmpty()) {
                sbErrorMessage = new StringBuffer("\n               " + ResourceBundleUtils.getResourceBundleLocaleString("nonRootUserValidation.writeAccess", "\"" + sUserName + "\"", ResourceBundle.getBundle("com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle")));
            } else {
                sbErrorMessage = new StringBuffer(this.sErrorMessage);
                sbErrorMessage.append("\n");
                sbErrorMessage.append("               ");
                sbErrorMessage.append(ResourceBundleUtils.getResourceBundleLocaleString("nonRootUserValidation.writeAccess", "\"" + sUserName + "\"", ResourceBundle.getBundle("com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle")));
            }
            itr = vUnwritablePaths.iterator();
            while (itr.hasNext()) {
                sbErrorMessage.append("\n");
                sbErrorMessage.append("                   ");
                sbErrorMessage.append("-");
                sbErrorMessage.append(" ");
                sbErrorMessage.append((String)itr.next());
            }
            this.sErrorMessage = sbErrorMessage.toString();
            fResult = false;
        }
        LOGGER.exiting(NonRootUserValidator.class.getName(), "runValidator");
        return fResult;
    }

    protected File[] getFilesForWriteCheck() throws WSProfileException {
        LOGGER.entering(NonRootUserValidator.class.getName(), "getFilesForWriteCheck");
        try {
            File fProfileHome = new File(this.sValidatorArgValue);
            File fProfileRegistry = WSProfile.getRegistryFile();
            File fProfilePropertiesHome = fProfileRegistry.getParentFile();
            File fProfilePropertiesHomeFsdb = new File(fProfilePropertiesHome.getAbsoluteFile() + this.S_FILE_SEPERATOR + "fsdb");
            File fManageProfilesLoggingHome = new File(new WSProfileProperties().getProperty("WS_CMT_LOG_HOME"));
            if (WASUtilities.isLinux()) {
                File fWASHomePropertiesProfilesMenu = new File(fProfilePropertiesHome.getAbsoluteFile() + this.S_FILE_SEPERATOR + "Profiles.menu");
                File[] fFilesToCheck = new File[]{fProfileHome, fProfileRegistry, fProfilePropertiesHome, fProfilePropertiesHomeFsdb, fManageProfilesLoggingHome, fWASHomePropertiesProfilesMenu};
                LOGGER.exiting(NonRootUserValidator.class.getName(), "getFilesForWriteCheck");
                return fFilesToCheck;
            }
            File[] fFilesToCheck = new File[]{fProfileHome, fProfileRegistry, fProfilePropertiesHome, fProfilePropertiesHomeFsdb, fManageProfilesLoggingHome};
            LOGGER.exiting(NonRootUserValidator.class.getName(), "getFilesForWriteCheck");
            return fFilesToCheck;
        }
        catch (FileNotFoundException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    protected File[] getFilesForReadCheck() throws WSProfileException {
        LOGGER.entering(NonRootUserValidator.class.getName(), "getFilesForReadCheck");
        File[] fFilesToCheck = this.getFilesForWriteCheck();
        LOGGER.exiting(NonRootUserValidator.class.getName(), "getFilesForReadCheck");
        return fFilesToCheck;
    }

    protected File[] getFilesForRecursivelyReadCheck() {
        LOGGER.entering(NonRootUserValidator.class.getName(), "getFilesForRecursivelyReadCheck");
        Vector<File> filesToCheck = new Vector<File>();
        String filePath = WASUtilities.getSystemPropertyValue("templatePath");
        if (filePath != null && !" ".equals(filePath)) {
            filesToCheck.add(new File(filePath));
        }
        filesToCheck.trimToSize();
        LOGGER.exiting(NonRootUserValidator.class.getName(), "getFilesForRecursivelyReadCheck");
        return filesToCheck.toArray(new File[filesToCheck.size()]);
    }

    protected boolean isPathWritable(File fDir) {
        LOGGER.entering(NonRootUserValidator.class.getName(), "isPathWritable");
        boolean fResult = false;
        if (fDir.exists()) {
            fResult = fDir.canWrite();
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isPathWritable", "The following path does not exist. Checking if its parents exist and are indeed Writable: " + fDir.getAbsolutePath());
            for (File fDirParent = fDir.getParentFile(); fDirParent != null; fDirParent = fDirParent.getParentFile()) {
                if (fDirParent.exists()) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "isPathWritable", "The following parent path exists. Checking if it is Writable: " + fDirParent.getAbsolutePath());
                    fResult = fDirParent.canWrite();
                    break;
                }
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "isPathWritable", "The following parent path does not exist. Checking if its parent exists and is indeed Writable: " + fDirParent.getAbsolutePath());
            }
        }
        LOGGER.exiting(NonRootUserValidator.class.getName(), "isPathWritable");
        return fResult;
    }

    protected boolean isReadable(File fDir) {
        LOGGER.entering(NonRootUserValidator.class.getName(), "isReadable");
        boolean fResult = false;
        if (fDir.exists()) {
            fResult = fDir.canRead();
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isReadable", "The following path does not exist. Checking if its parents exist and are indeed Readable: " + fDir.getAbsolutePath());
            for (File fDirParent = fDir.getParentFile(); fDirParent != null; fDirParent = fDirParent.getParentFile()) {
                if (fDirParent.exists()) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "isReadable", "The following parent path exists. Checking if it is Readable: " + fDirParent.getAbsolutePath());
                    fResult = fDirParent.canRead();
                    break;
                }
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "isPathWritable", "The following parent path does not exist. Checking if its parent exists and is indeed Readable: " + fDirParent.getAbsolutePath());
            }
        }
        LOGGER.exiting(NonRootUserValidator.class.getName(), "isReadable");
        return fResult;
    }

    protected boolean isRecursivelyReadable(File fDir) {
        LOGGER.entering(NonRootUserValidator.class.getName(), "isRecursivelyReadable");
        if (fDir.canRead()) {
            File[] fDirFiles = fDir.listFiles();
            for (int i = 0; i < fDirFiles.length; ++i) {
                if (!fDirFiles[i].isDirectory()) continue;
                boolean fResult = fDirFiles[i].canRead();
                if (!fResult) {
                    this.S_UNREADABLE_PATH = fDirFiles[i].getAbsolutePath();
                    LOGGER.exiting(NonRootUserValidator.class.getName(), "isRecursivelyReadable");
                    return false;
                }
                this.isRecursivelyReadable(fDirFiles[i]);
            }
            LOGGER.exiting(NonRootUserValidator.class.getName(), "isRecursivelyReadable");
            return true;
        }
        this.S_UNREADABLE_PATH = fDir.getAbsolutePath();
        LOGGER.exiting(NonRootUserValidator.class.getName(), "isRecursivelyReadable");
        return false;
    }
}

