/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.TargetPlatform;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectoryValidator
extends GenericValidator {
    public static final String S_INVALID_PATH_CHARS_WINDOWS_REGEX = "[{}:;\\&\\*?\"<>|%,=+'#$^`!\\[\\]]";
    public static final String S_INVALID_PATH_CHARS_UNIX_REGEX = "[{}`!\\&\\*\\(\\)|;:<>?\"\\\\,=+%'$#^\\[\\]]";
    public static final String S_INVALID_CHAR_COMB_REGEX = "]]>";
    public static final String S_COLON = ":";
    public static final String S_BACK_SLASH = "\\";
    public static final String S_SPACE = " ";
    private static final String S_INVALID_PATH_KEY = "path.invalid";
    private static final String S_INVALID_CHARS_KEY = "name.error.invalidChars";
    public static final String S_RESOURCE_BUNDLE = "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle";
    private static final Logger LOGGER = LoggerFactory.createLogger(DirectoryValidator.class);
    private static final String S_CLASS_NAME = DirectoryValidator.class.getName();

    public boolean runValidator() {
        LOGGER.entering(S_CLASS_NAME, "runValidator");
        if (!this.isExistingDriveLocation()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        if (!this.isValidPathCharacters(TargetPlatform.getPlatformName())) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        File dir = new File(this.sValidatorArgValue);
        if (!this.isValidDir(this.sValidatorArgValue, dir)) {
            this.sErrorMessage = this.getInvalidDirectoryString();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidator");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return true;
    }

    public boolean runValidatorDisconnected() {
        LOGGER.entering(S_CLASS_NAME, "runValidatorDisconnected");
        if (this.sValidatorArgValue.equals("")) {
            LOGGER.exiting(S_CLASS_NAME, "runValidatorDisconnected");
            return true;
        }
        if (!this.isValidDriveLocation(TargetPlatform.getPlatformName())) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidatorDisconnected", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidatorDisconnected");
            return false;
        }
        if (!this.isValidPathCharacters(TargetPlatform.getPlatformName())) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidatorDisconnected", this.sErrorMessage);
            LOGGER.exiting(S_CLASS_NAME, "runValidatorDisconnected");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidatorDisconnected");
        return true;
    }

    protected boolean isExistingDriveLocation() {
        LOGGER.entering(S_CLASS_NAME, "isExistingDriveLocation");
        boolean result = true;
        int driveLocation = this.sValidatorArgValue.indexOf(S_COLON);
        if (driveLocation > 0 && TargetPlatform.isWindows()) {
            File path = new File(this.sValidatorArgValue.substring(0, driveLocation + 1));
            result = path.exists();
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isExistingDriveLocation", path.getAbsolutePath() + " exists? " + result);
        }
        if (!result) {
            this.sErrorMessage = this.getInvalidDirectoryString();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isExistingDriveLocation", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "isExistingDriveLocation");
        return result;
    }

    protected boolean isValidPathCharacters(String sPlatform) {
        LOGGER.entering(S_CLASS_NAME, "isValidPathCharacters");
        boolean result = true;
        if (sPlatform.equals("windows")) {
            int nDriveLocation = this.sValidatorArgValue.indexOf(S_COLON);
            if (this.evaluateRegex(S_INVALID_PATH_CHARS_WINDOWS_REGEX, this.sValidatorArgValue.substring(nDriveLocation + 1)) || this.evaluateRegex(S_INVALID_CHAR_COMB_REGEX, this.sValidatorArgValue.substring(nDriveLocation + 1))) {
                result = false;
            }
        } else if (this.sValidatorArgValue.indexOf(S_BACK_SLASH) != -1 || this.sValidatorArgValue.indexOf(S_SPACE) != -1 || this.evaluateRegex(S_INVALID_PATH_CHARS_UNIX_REGEX, this.sValidatorArgValue) || this.evaluateRegex(S_INVALID_CHAR_COMB_REGEX, this.sValidatorArgValue)) {
            result = false;
        }
        if (!result) {
            this.sErrorMessage = this.getPathContainsInvalidCharactersString();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isValidPathCharacters", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "isValidPathCharacters");
        return result;
    }

    protected boolean isValidDriveLocation(String sPlatform) {
        int nDriveLocation;
        LOGGER.entering(S_CLASS_NAME, "isValidDriveLocation");
        boolean result = true;
        if (sPlatform.equals("windows") && ((nDriveLocation = this.sValidatorArgValue.indexOf(S_COLON)) == -1 || nDriveLocation == this.sValidatorArgValue.length() - 1 || this.sValidatorArgValue.charAt(nDriveLocation + 1) != '\\' && this.sValidatorArgValue.charAt(nDriveLocation + 1) != '/')) {
            result = false;
        }
        if (!result) {
            this.sErrorMessage = this.getInvalidDirectoryString();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isValidDriveLocation", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "isValidDriveLocation");
        return result;
    }

    protected boolean isValidDir(String dir, File f) {
        LOGGER.entering(DirectoryValidator.class.getName(), "isValidDir");
        boolean result = false;
        if (!f.exists()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isValidDirectory", f.getAbsolutePath() + " does not exist");
            File parent = f.getParentFile();
            LinkedList<File> parents = new LinkedList<File>();
            if (parent == null) {
                result = f.canWrite();
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "isValidDirectory", "Is " + f.getAbsolutePath() + " writable? " + result);
            }
            while (parent != null && !parent.exists()) {
                parents.add(parent);
                parent = parent.getParentFile();
            }
            result = f.mkdirs();
            if (result) {
                f.delete();
                for (int i = 0; i < parents.size(); ++i) {
                    File tmpParent = (File)parents.get(i);
                    tmpParent.delete();
                }
            }
            LOGGER.exiting(DirectoryValidator.class.getName(), "isValidDir");
            return result;
        }
        if (f.isDirectory() && f.canWrite()) {
            int isEmpty = f.list().length;
            File testDir = new File(f.getAbsolutePath() + File.separatorChar + "temp");
            boolean canWrite = testDir.mkdirs();
            if (canWrite) {
                testDir.delete();
            }
            if (isEmpty <= 0) {
                LOGGER.exiting(DirectoryValidator.class.getName(), "isValidDir");
                return true;
            }
        }
        LOGGER.exiting(DirectoryValidator.class.getName(), "isValidDir");
        return false;
    }

    protected boolean evaluateRegex(String sRegex, String sPattern) {
        Pattern pattern = Pattern.compile(sRegex);
        Matcher matcher = pattern.matcher(sPattern);
        return matcher.find();
    }

    protected String getInvalidDirectoryString() {
        return ResourceBundleUtils.getResourceBundleLocaleString(S_INVALID_PATH_KEY, S_RESOURCE_BUNDLE);
    }

    protected String getPathContainsInvalidCharactersString() {
        return ResourceBundleUtils.getResourceBundleLocaleString(S_INVALID_CHARS_KEY, S_RESOURCE_BUNDLE);
    }
}

