/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.io.file.NativeFile;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.DiskSpaceValidator;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.validators.GenericValidator;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupProfileValidator
extends GenericValidator {
    private static final Logger LOGGER = LoggerFactory.createLogger(BackupProfileValidator.class);
    private static final String S_CLASS_NAME = BackupProfileValidator.class.getName();

    public boolean runValidator() throws Exception {
        LOGGER.entering(DiskSpaceValidator.class.getName(), "runValidator");
        String sBackupFile = System.getProperty("backupFile");
        String sBackupProfile = System.getProperty("profileName");
        if (sBackupFile == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("BackupProfileValidator.noBackupFile", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            return false;
        }
        if (sBackupProfile == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("BackupProfileValidator.noBackupProfile", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            return false;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "profilePath:" + sBackupFile);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "backupFile:" + sBackupProfile);
        FileUtils.intializeNativeFileFunctionality();
        if (FileUtils.isNativeFileFunctionalityAvailable()) {
            double freeSpace = 0.0;
            NativeFile backupFile = new NativeFile(sBackupFile);
            File profile = WSProfile.getProfileLocation(sBackupProfile);
            NativeFile backupProfile = new NativeFile(profile);
            freeSpace = FileUtils.convertBytesToMB(backupProfile.getFreeSpace());
            if (freeSpace < Double.longBitsToDouble(backupProfile.getFileSystemSize())) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.insufficient", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                return false;
            }
            if (backupFile.exists()) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("BackupProfileValidator.fileExists", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            if (backupFile.createNewFile()) {
                backupFile.delete();
            }
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFile functionality is not available");
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(BackupProfileValidator.class.getName(), "runValidator");
            return false;
        }
        return true;
    }
}

