/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.WSProfileJob;
import com.ibm.ws.profile.bootstrap.LogInitializer;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.ProfilesCryptoI;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.ws.profile.utils.VectorUtils;
import com.ibm.ws.profile.utils.WSProfileCryptoImpl;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WSProfileUtils {
    private static String S_NON_ESCAPED_COMMAS = ",(?<!\\\\,)";
    private static String S_COMMA = ",";
    private static String S_ESCAPED_COMMA = "\\\\,";
    private static String S_EMPTY = "";
    private static Logger LOGGER = LoggerFactory.createLogger(WSProfileUtils.class);
    private static String S_CLASS_NAME = WSProfileUtils.class.getName();

    public static List<String> getMapAsList(Map<String, List> map) {
        if (map != null) {
            Enumeration e_enum = ((Hashtable)map).keys();
            Vector<String> v_list = new Vector<String>();
            while (e_enum.hasMoreElements()) {
                String key = (String)e_enum.nextElement();
                v_list.add("-" + key);
                v_list.addAll((Vector)map.get(key));
            }
            return new Vector<String>(v_list);
        }
        return new Vector<String>();
    }

    public static String[] getMapAsStringArray(Map map) {
        return VectorUtils.convertVectorToStringArray((Vector)WSProfileUtils.getMapAsList((Hashtable)map));
    }

    public static Map<String, List> cloneMap(Map<String, List> map) {
        Hashtable<String, List> h_clone = new Hashtable<String, List>();
        for (String sKey : map.keySet()) {
            Vector l_value = (Vector)((Vector)map.get(sKey)).clone();
            h_clone.put(sKey, l_value);
        }
        return h_clone;
    }

    public static List<String> convertCommaEscapedStringToValues(String sValues) {
        LOGGER.entering(S_CLASS_NAME, "convertCommaEscapedStringToValues");
        Vector<String> listConvertedValues = new Vector<String>();
        if (sValues != null) {
            String[] splitArray = sValues.split(S_NON_ESCAPED_COMMAS);
            for (int i = 0; i < splitArray.length; ++i) {
                listConvertedValues.add(splitArray[i].replaceAll(S_ESCAPED_COMMA, S_COMMA));
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "convertCommaEscapedStringToValues");
        return listConvertedValues;
    }

    public static String convertListToCommaEscapedString(List<String> listValues) {
        LOGGER.entering(S_CLASS_NAME, "convertListToCommaEscapedString");
        String sValue = "";
        if (listValues != null) {
            for (int i = 0; i < listValues.size(); ++i) {
                sValue = sValue + WSProfileUtils.escapeCommasInString(listValues.get(i));
                if (i + 1 >= listValues.size()) continue;
                sValue = sValue + S_COMMA;
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "convertListToCommaEscapedString");
        return sValue;
    }

    public static String[] convertPropertiesToCommandLineArguments(Properties propertiesIn) {
        LOGGER.entering(S_CLASS_NAME, "convertPropertiesToCommandLineArguments");
        if (propertiesIn != null) {
            Vector<String> vsArgs = new Vector<String>();
            Enumeration<Object> enumerationKeys = propertiesIn.keys();
            while (enumerationKeys.hasMoreElements()) {
                String sKeyThis = enumerationKeys.nextElement().toString();
                vsArgs.add("-" + sKeyThis);
                String sValues = propertiesIn.getProperty(sKeyThis);
                if (sValues == null || sValues.equals(S_EMPTY)) continue;
                List<String> listValues = WSProfileUtils.convertCommaEscapedStringToValues(sValues);
                vsArgs.addAll(listValues);
            }
            LOGGER.exiting(S_CLASS_NAME, "convertPropertiesToCommandLineArguments");
            return VectorUtils.convertVectorToStringArray(vsArgs);
        }
        LOGGER.exiting(S_CLASS_NAME, "convertPropertiesToCommandLineArguments");
        return new String[0];
    }

    public static String[] convertTemplatePathShortFormToProperPath(String[] saArgs) throws FileNotFoundException, IOException {
        LOGGER.entering(S_CLASS_NAME, "convertTemplatePathShortFormToProperPath");
        String[] saTemplatePaths = WSProfileUtils.getValuesForParam(saArgs, "templatePath");
        String[] saNewTemplatePaths = new String[saTemplatePaths.length];
        for (int i = 0; i < saTemplatePaths.length; ++i) {
            String sTemplatePath = saTemplatePaths[i];
            if (sTemplatePath != null) {
                if (new File(sTemplatePath).exists() || sTemplatePath.equals("")) {
                    saNewTemplatePaths[i] = sTemplatePath;
                    continue;
                }
                String sDefaultParent = new WSProfileProperties().getProperty("WS_DEFAULT_TEMPLATE_LOCATION");
                try {
                    new WSProfileTemplate(new File(sDefaultParent, sTemplatePath));
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "convertTemplatePathShortFormToProperPath", "templatePath was coverted from \"" + sTemplatePath + "\" to \"" + new File(sDefaultParent, sTemplatePath).getAbsolutePath() + "\"");
                    saNewTemplatePaths[i] = new File(sDefaultParent, sTemplatePath).getAbsolutePath();
                }
                catch (WSProfileException wspe) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "convertTemplatePathShortFormToProperPath", "templatePath could not be coverted from \"" + sTemplatePath + "\" to \"" + new File(sDefaultParent, sTemplatePath).getAbsolutePath() + "\"");
                    saNewTemplatePaths[i] = new File(sDefaultParent, sTemplatePath).getAbsolutePath();
                }
                continue;
            }
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "convertTemplatePathShortFormToProperPath", "templatePath is null");
            return saArgs;
        }
        String[] saNewArgs = CommandLineArgumentsUtils.replaceArgValues("templatePath", saArgs, saNewTemplatePaths);
        LOGGER.exiting(S_CLASS_NAME, "convertTemplatePathShortFormToProperPath");
        return saNewArgs;
    }

    public static boolean isEarlyDefaultingNecessary(WSProfileCLIModeInvoker wspclimi, Map m_args) {
        List l_profileNames = (List)m_args.get("profileName");
        List l_templatePaths = (List)m_args.get("templatePath");
        return (l_profileNames == null || l_profileNames.size() <= 0) && l_templatePaths != null && l_templatePaths.size() > 0 && wspclimi.isArgumentRequired("profileName");
    }

    public static Map addEarlyDefaults(WSProfileCLIModeInvoker wspclimi, Map m_args) {
        boolean f_modifiedArgs = false;
        Hashtable m_argsLocal = (Hashtable)m_args;
        List l_templatePaths = (List)m_argsLocal.get("templatePath");
        for (int r_currentTemplateIndex = l_templatePaths.size() - 1; r_currentTemplateIndex >= 0 && !f_modifiedArgs; --r_currentTemplateIndex) {
            String sTemplatePath = (String)l_templatePaths.get(r_currentTemplateIndex);
            if (sTemplatePath == null || sTemplatePath.equals("")) continue;
            Properties props = SystemPropertiesUtils.getCurrentSystemProperties();
            System.setProperty("WS_CMT_CONF_DIR", sTemplatePath);
            System.setProperty("WS_CMT_ACTION_REGISTRY", sTemplatePath + File.separator + wspclimi.getRegistryName());
            System.setProperty(wspclimi.getModeFlag(), "");
            Hashtable<String, String> hashtableOtherArgs = new Hashtable<String, String>();
            hashtableOtherArgs.put("templatePath", sTemplatePath);
            String profileName = DefaultValueManagerUtils.getDefaultValue("profileName", hashtableOtherArgs);
            if (profileName != null && !profileName.equals("")) {
                Vector<String> l_tmp = new Vector<String>();
                l_tmp.add(profileName);
                m_argsLocal.put("profileName", l_tmp);
                f_modifiedArgs = true;
            }
            SystemPropertiesUtils.resetSystemProperties(props);
        }
        return m_argsLocal;
    }

    public static boolean isLogReInitializationNecessary(Map m_args_initial, Map m_args_current, WSProfileCLIModeInvoker wspclimi_initial, WSProfileCLIModeInvoker wspclimi_current) {
        boolean fModeChanged;
        List l_initialProfileName = (List)m_args_initial.get("profileName");
        List l_currentProfileName = (List)m_args_current.get("profileName");
        String originalProfileName = null;
        String newProfileName = null;
        if (l_initialProfileName != null && l_initialProfileName.size() > 0) {
            originalProfileName = (String)l_initialProfileName.get(0);
        }
        if (l_currentProfileName != null && l_currentProfileName.size() > 0) {
            newProfileName = (String)l_currentProfileName.get(0);
        }
        String originalModeName = wspclimi_initial.getModeFlag();
        String newModeName = wspclimi_current.getModeFlag();
        boolean fProfileNameChanged = originalProfileName == null && newProfileName != null || originalProfileName != null && !originalProfileName.equals(newProfileName);
        boolean bl = fModeChanged = originalModeName == null && newModeName != null || originalModeName != null && !originalModeName.equals(newModeName);
        return (fProfileNameChanged || fModeChanged) && !WSProfile.isAllMode(originalModeName);
    }

    public static void reInitializeLogger(String[] asRealArgs, LoggerContext lc) {
        LOGGER.entering(S_CLASS_NAME, "addEarlyDefaults");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Current command line is: " + LogUtils.getArrayAsALoggableString(WSProfileUtils.hidePasswordArgs(asRealArgs)));
        String sOldLogFileName = LoggerFactoryConstants.getGlobalLogFilePath();
        try {
            String sNewLogFileBaseName = new LogInitializer(asRealArgs).determineLogFileName();
            String sNewLogFileDirectory = LoggerFactoryConstants.getGlobalLogDirectory();
            String sNewLogFileName = new File(sNewLogFileDirectory, sNewLogFileBaseName).getAbsolutePath();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Switching logging to: " + sNewLogFileName);
            if (lc != null) {
                lc.saveAndSwitchCurrentContext();
            }
            WSProfileUtils.initLogger(asRealArgs);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Logging continued from: " + sOldLogFileName);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "reInitializeLogger", "Current command line is: " + LogUtils.getArrayAsALoggableString(WSProfileUtils.hidePasswordArgs(asRealArgs)));
        LOGGER.exiting(S_CLASS_NAME, "reInitializeLogger");
    }

    public static String[] hidePasswordArgs(List<String> args) {
        LOGGER.entering(S_CLASS_NAME, "hidePasswordArgs");
        if (args == null) {
            LOGGER.exiting(S_CLASS_NAME, "hidePasswordArgs");
            return new String[0];
        }
        String[] sa_args = args.toArray(new String[args.size()]);
        LOGGER.exiting(S_CLASS_NAME, "hidePasswordArgs");
        return WSProfileUtils.hidePasswordArgs(sa_args);
    }

    public static String[] hidePasswordArgs(String[] args) {
        LOGGER.entering(S_CLASS_NAME, "hidePasswordArgs");
        if (args == null) {
            LOGGER.exiting(S_CLASS_NAME, "hidePasswordArgs");
            return new String[0];
        }
        String[] sArgsLogs = new String[args.length];
        System.arraycopy(args, 0, sArgsLogs, 0, args.length);
        String[] sMaskableActionArguments = WSProfileUtils.getMaskableArgs();
        if (sMaskableActionArguments == null) {
            return sArgsLogs;
        }
        int iPasswordIndex = 0;
        for (int i = 0; i < sArgsLogs.length; ++i) {
            if (iPasswordIndex != 0) {
                sArgsLogs[iPasswordIndex] = "********";
            }
            for (int j = 0; j < sMaskableActionArguments.length; ++j) {
                if (!sArgsLogs[i].equals("-" + sMaskableActionArguments[j])) continue;
                iPasswordIndex = i + 1;
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "hidePasswordArgs");
        return sArgsLogs;
    }

    public static String[] getMaskableArgs() {
        LOGGER.entering(S_CLASS_NAME, "getMaskableArgs");
        String sMaskableArgs = "";
        try {
            sMaskableArgs = new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS");
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        catch (IOException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        Object[] sMaskableArgsList = sMaskableArgs.split(";");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "Maskable Action Arguments: " + LogUtils.getArrayAsALoggableString(sMaskableArgsList));
        LOGGER.exiting(S_CLASS_NAME, "getMaskableArgs");
        return sMaskableArgsList;
    }

    public static String[] getExcludedArgsForDecryption() {
        LOGGER.entering(S_CLASS_NAME, "getExcludedArgsForDecryption");
        String sExcludedArgsForDecryption = "";
        try {
            sExcludedArgsForDecryption = new WSProfileProperties().getProperty("WS_WSPROFILE_EXCLUDED_DECRYPTION_ARGUMENTS");
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExcludedArgsForDecryption", "No Excluded Decryption Arguments found in wasprofile.properties.");
        }
        catch (IOException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExcludedArgsForDecryption", "No Excluded Decryption Arguments found in wasprofile.properties.");
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExcludedArgsForDecryption", "No Excluded Decryption Arguments found in wasprofile.properties.");
        }
        Object[] sExcludedArgsForDecryptionList = sExcludedArgsForDecryption.split(";");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExcludedArgsForDecryption", "Excluded Decryption Action Arguments: " + LogUtils.getArrayAsALoggableString(sExcludedArgsForDecryptionList));
        LOGGER.exiting(S_CLASS_NAME, "getExcludedArgsForDecryption");
        return sExcludedArgsForDecryptionList;
    }

    public static void initLogger(String[] args) {
        try {
            LOGGER = new LogInitializer(args).initCMTLoggerFactory(WSProfileUtils.class);
            LOGGER.entering(S_CLASS_NAME, "initLogger");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        LOGGER.exiting(S_CLASS_NAME, "initLogger");
    }

    public static int launchExecutionOfActions(Class[] caActions) {
        LOGGER.entering(S_CLASS_NAME, "launchExecutionOfActions");
        try {
            Vector<WSProfileProcessorTask> lwsptActions = new Vector<WSProfileProcessorTask>();
            for (int i = 0; i < caActions.length; ++i) {
                Class classAction = caActions[i];
                lwsptActions.add((WSProfileProcessorTask)classAction.newInstance());
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launchExecutionOfActions", "Starting Execution of Processors");
            boolean fExecutionPassed = true;
            for (int i = 0; i < lwsptActions.size() && fExecutionPassed; ++i) {
                WSProfileProcessorTask cAction = (WSProfileProcessorTask)lwsptActions.get(i);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "launchExecutionOfActions", "Starting Execution of: " + cAction.getClass().getSimpleName());
                fExecutionPassed = cAction.execute();
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "launchExecutionOfActions", "Finished Executing: " + cAction.getClass().getSimpleName() + " with return code: " + fExecutionPassed);
            }
            int rExecutionResult = !fExecutionPassed ? 1 : 0;
            LOGGER.exiting(S_CLASS_NAME, "launchExecutionOfActions");
            return rExecutionResult;
        }
        catch (IllegalAccessException e) {
            LogUtils.logException(LOGGER, e);
        }
        catch (InstantiationException e) {
            LogUtils.logException(LOGGER, e);
        }
        LOGGER.exiting(S_CLASS_NAME, "launchExecutionOfActions");
        return 1;
    }

    public static int executeAllJobs(List lwspjAll) {
        LOGGER.entering(S_CLASS_NAME, "executeAllJobs");
        int rExecutionCode = 0;
        for (int i = 0; i < lwspjAll.size() && rExecutionCode != 1; ++i) {
            WSProfileJob wspjCurrent = (WSProfileJob)lwspjAll.get(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAllJobs", "Executing job: " + i + " using command " + LogUtils.getArrayAsALoggableString(StringUtils.hidePasswordArgs(wspjCurrent.getArgsAsStringArray())));
            int rTempReturnCode = wspjCurrent.run();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAllJobs", "Finished Execution: result:" + rTempReturnCode);
            rExecutionCode = rExecutionCode == 2 && rTempReturnCode != 1 ? 2 : rTempReturnCode;
        }
        LOGGER.exiting(S_CLASS_NAME, "executeAllJobs");
        return rExecutionCode;
    }

    public static int getOutcome(int incommingResult, int recentResult) {
        LOGGER.entering(S_CLASS_NAME, "getOutcome");
        if (incommingResult == 0) {
            LOGGER.exiting(S_CLASS_NAME, "getOutcome");
            return recentResult;
        }
        if (incommingResult == 1) {
            LOGGER.exiting(S_CLASS_NAME, "getOutcome");
            return incommingResult;
        }
        if (recentResult == 1) {
            LOGGER.exiting(S_CLASS_NAME, "getOutcome");
            return recentResult;
        }
        if (recentResult == 0) {
            LOGGER.exiting(S_CLASS_NAME, "getOutcome");
            return incommingResult;
        }
        LOGGER.exiting(S_CLASS_NAME, "getOutcome");
        return incommingResult;
    }

    public static List<WSProfileTemplate> getDisplayedTemplates(List<WSProfileTemplate> templates) {
        Vector<WSProfileTemplate> displayedTemplates = new Vector<WSProfileTemplate>();
        for (int i = 0; i < templates.size(); ++i) {
            WSProfileTemplate wspt = templates.get(i);
            if (!wspt.isDisplayed()) continue;
            displayedTemplates.add(wspt);
        }
        return displayedTemplates;
    }

    public static String getDefaultTemplateName() {
        String sDefaultTemplateName = new String();
        try {
            LOGGER.entering(S_CLASS_NAME, "getDefaultTemplateName");
            WSProfileProperties wspp = new WSProfileProperties();
            sDefaultTemplateName = wspp.getProperty("WS_DEFAULT_TEMPLATE_NAME");
        }
        catch (FileNotFoundException fnfe) {
            LogUtils.logException(LOGGER, fnfe);
        }
        catch (IOException ioe) {
            LogUtils.logException(LOGGER, ioe);
        }
        LOGGER.exiting(S_CLASS_NAME, "getDefaultTemplateName");
        return sDefaultTemplateName;
    }

    public static boolean isTemplateDefaultingNecessary(WSProfileCLIModeInvoker wspclimi, String[] saArgs) {
        LOGGER.entering(S_CLASS_NAME, "isTemplateDefaultingNecessary");
        if (wspclimi == null || saArgs == null || !WSProfileUtils.isArgumentRequired(wspclimi, "templatePath")) {
            LOGGER.exiting(S_CLASS_NAME, "isTemplateDefaultingNecessary");
            return false;
        }
        String[] saTemplatePaths = WSProfileUtils.getValuesForParam(saArgs, "templatePath");
        if (saTemplatePaths == null || saTemplatePaths.length <= 0 || WSProfileUtils.isTemplatePathGivenInShortForm(saTemplatePaths)) {
            LOGGER.exiting(S_CLASS_NAME, "isTemplateDefaultingNecessary");
            return true;
        }
        LOGGER.exiting(S_CLASS_NAME, "isTemplateDefaultingNecessary");
        return false;
    }

    public static String[] addTemplatePathDefault(String[] saArgs) throws FileNotFoundException, IOException {
        LOGGER.entering(S_CLASS_NAME, "addTemplatePathDefault");
        Hashtable mArgs = CommandLineArgumentsUtils.convertCommandLineToHashtable(saArgs);
        Vector<String> vNewValues = new Vector<String>();
        vNewValues.add(WSProfileUtils.getDefaultTemplatePath());
        if (vNewValues.size() > 0) {
            mArgs.put("templatePath", vNewValues);
        }
        LOGGER.exiting(S_CLASS_NAME, "addTemplatePathDefault");
        return WSProfileUtils.getMapAsStringArray(mArgs);
    }

    public static String[] getValuesForParam(String[] saArgs, String sArgKey) {
        LOGGER.entering(S_CLASS_NAME, "getValuesForParam");
        if (saArgs == null || saArgs.length <= 0 || sArgKey == null || sArgKey.equals("")) {
            return new String[0];
        }
        Hashtable m_args = CommandLineArgumentsUtils.convertCommandLineToHashtable(saArgs);
        Vector v_list = (Vector)m_args.get(sArgKey);
        if (v_list == null) {
            return new String[0];
        }
        LOGGER.exiting(S_CLASS_NAME, "getValuesForParam");
        return VectorUtils.convertVectorToStringArray(v_list);
    }

    private static boolean isArgumentRequired(WSProfileCLIModeInvoker wspclimi, String sArgName) {
        LOGGER.entering(S_CLASS_NAME, "isArgumentRequired");
        Vector vclaAllArgs = wspclimi.getListOfAllCommandLineArguments();
        for (int i = 0; i < vclaAllArgs.size(); ++i) {
            CommandLineArgument cla = (CommandLineArgument)vclaAllArgs.get(i);
            if (!sArgName.equals(cla.getKey()) || !cla.isRequired()) continue;
            LOGGER.exiting(S_CLASS_NAME, "isArgumentRequired");
            return true;
        }
        LOGGER.exiting(S_CLASS_NAME, "isArgumentRequired");
        return false;
    }

    private static boolean isTemplatePathGivenInShortForm(String[] saTemplatePaths) {
        LOGGER.entering(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
        for (int i = 0; i < saTemplatePaths.length; ++i) {
            String sTemplatePath = saTemplatePaths[i];
            if (sTemplatePath == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isTemplatePathGivenInShortForm", "templatePath is null");
                LOGGER.exiting(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
                return false;
            }
            if (new File(sTemplatePath).exists()) continue;
            try {
                String sDefaultParent = new WSProfileProperties().getProperty("WS_DEFAULT_TEMPLATE_LOCATION");
                new WSProfileTemplate(new File(sDefaultParent, sTemplatePath));
                LOGGER.exiting(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
                return true;
            }
            catch (WSProfileException wspe) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isTemplatePathGivenInShortForm", "templatePath \"" + sTemplatePath + "\" is not found and is not a short form");
                LOGGER.exiting(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
                return false;
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isTemplatePathGivenInShortForm", "Attempting to read wasprofile.properties: " + fnfe.getMessage());
                LOGGER.exiting(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
                return false;
            }
            catch (IOException ioe) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isTemplatePathGivenInShortForm", "Attempting to read wasprofile.properties: " + ioe.getMessage());
                LOGGER.exiting(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
                return false;
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "isTemplatePathGivenInShortForm");
        return false;
    }

    private static String escapeCommasInString(String sValue) {
        LOGGER.entering(S_CLASS_NAME, "escapeCommasInString");
        LOGGER.exiting(S_CLASS_NAME, "escapeCommasInString");
        return sValue.replaceAll(S_COMMA, S_ESCAPED_COMMA);
    }

    private static String getDefaultTemplatePath() throws FileNotFoundException, IOException {
        LOGGER.entering(S_CLASS_NAME, "getDefaultTemplatePath");
        WSProfileProperties wspp = new WSProfileProperties();
        String sParentFolderPath = wspp.getProperty("WS_DEFAULT_TEMPLATE_LOCATION");
        String sDefaultTemplateName = wspp.getProperty("WS_DEFAULT_TEMPLATE_NAME");
        if (sParentFolderPath == null || sDefaultTemplateName == null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultTemplatePath", "templatePath was defaulted to: Unable to properly default the templatePath: returning null");
            LOGGER.exiting(S_CLASS_NAME, "getDefaultTemplatePath");
            return null;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultTemplatePath", "templatePath was defaulted to: " + new File(sParentFolderPath, sDefaultTemplateName).getAbsolutePath());
        LOGGER.exiting(S_CLASS_NAME, "getDefaultTemplatePath");
        return new File(sParentFolderPath, sDefaultTemplateName).getAbsolutePath();
    }

    public static List<WSProfileTemplate> convertFileListToWSProfileTemplateList(List<File> listFileTemplatePaths) {
        LOGGER.entering(S_CLASS_NAME, "convertFileListOfTemplatePathsToWSProfileTemplateList");
        Vector<WSProfileTemplate> v_wsptReturnTemplates = new Vector<WSProfileTemplate>();
        if (listFileTemplatePaths != null || !listFileTemplatePaths.isEmpty()) {
            for (File thisTemplatePath : listFileTemplatePaths) {
                try {
                    v_wsptReturnTemplates.add(new WSProfileTemplate(thisTemplatePath));
                }
                catch (WSProfileException wspe) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "convertFileListOfTemplatePathsToWSProfileTemplateList", thisTemplatePath.getAbsolutePath() + " is not a valid WSProfileTemplate. It will not be included in the WSProfileTemplate list.");
                }
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "convertFileListOfTemplatePathsToWSProfileTemplateList");
        return v_wsptReturnTemplates;
    }

    public static WSProfileTemplate getBaseLevelTemplateInStack(List<WSProfileTemplate> l_wsptTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "getBaseLevelTemplateInStack");
        LOGGER.exiting(S_CLASS_NAME, "getBaseLevelTemplateInStack");
        return l_wsptTemplateStack.get(0);
    }

    public static String getBaseLevelTemplateInStack(List<String> l_sTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "getBaseLevelTemplateInStack");
        LOGGER.exiting(S_CLASS_NAME, "getBaseLevelTemplateInStack");
        return l_sTemplateStack.get(0);
    }

    public static WSProfileTemplate getTopLevelTemplateInStack(List<WSProfileTemplate> l_wsptTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "getTopLevelTemplateInStack");
        LOGGER.exiting(S_CLASS_NAME, "getTopLevelTemplateInStack");
        return l_wsptTemplateStack.get(l_wsptTemplateStack.size() - 1);
    }

    public static String getTopLevelTemplateInStack(List<String> l_sTemplateStack) {
        LOGGER.entering(S_CLASS_NAME, "getTopLevelTemplateInStack");
        LOGGER.exiting(S_CLASS_NAME, "getTopLevelTemplateInStack");
        return l_sTemplateStack.get(l_sTemplateStack.size() - 1);
    }

    public static ProfilesCryptoI getCryptoHelper() {
        return new WSProfileCryptoImpl();
    }
}

