/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ProfilesCryptoI;
import com.ibm.ws.profile.utils.WSProfileUtils;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCryptoImpl
implements ProfilesCryptoI {
    private static String[] _excludedArgsForDecryption = null;
    private static Logger LOGGER = LoggerFactory.createLogger(WSProfileCryptoImpl.class);
    private static final String S_CLASS_NAME = WSProfileCryptoImpl.class.getName();

    public WSProfileCryptoImpl() {
        if (_excludedArgsForDecryption == null) {
            _excludedArgsForDecryption = WSProfileUtils.getExcludedArgsForDecryption();
        }
    }

    @Override
    public Map<String, List> getDecryptedMap(Map<String, List> encryptedMap, boolean plaintextIsCommaSeparated) {
        LOGGER.entering(S_CLASS_NAME, "getDecryptedMap");
        Hashtable<String, List> decryptedIncomingArgs = new Hashtable<String, List>();
        Set<String> argKeys = encryptedMap.keySet();
        for (String argKey : argKeys) {
            List argValues = encryptedMap.get(argKey);
            Iterator argValuesIterator = argValues.iterator();
            Vector<String> decryptedValues = new Vector<String>();
            while (argValuesIterator.hasNext()) {
                String argValue = (String)argValuesIterator.next();
                if (this.isCandidateForDecryption(argKey) && this.isEncrypted(argValue)) {
                    Vector<String> decryptedArgValues = this.decryptPossiblyMultiValuedPassword(argValue, plaintextIsCommaSeparated);
                    decryptedValues.addAll(decryptedArgValues);
                    continue;
                }
                decryptedValues.addElement(argValue);
            }
            decryptedIncomingArgs.put(argKey, decryptedValues);
        }
        LOGGER.exiting(S_CLASS_NAME, "getDecryptedMap");
        return decryptedIncomingArgs;
    }

    private boolean isCandidateForDecryption(String argKey) {
        for (int i = 0; i < _excludedArgsForDecryption.length; ++i) {
            if (!argKey.equals(_excludedArgsForDecryption[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String decryptPassword(String cipherText) {
        LOGGER.entering(S_CLASS_NAME, "decryptPassword");
        LOGGER.exiting(S_CLASS_NAME, "decryptPassword");
        return PasswordUtil.passwordDecode((String)cipherText);
    }

    public Vector<String> decryptPossiblyMultiValuedPassword(String cipherText, boolean plaintextIsCommaSeparated) {
        LOGGER.entering(S_CLASS_NAME, "decryptPossiblyMultiValuedPassword");
        String s = PasswordUtil.passwordDecode((String)cipherText);
        if (!plaintextIsCommaSeparated && (s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        Vector<String> v = null;
        if (plaintextIsCommaSeparated) {
            Properties p = new Properties();
            p.put("tempKey", s);
            String[] vals = WSProfileUtils.convertPropertiesToCommandLineArguments(p);
            v = new Vector<String>(Arrays.asList(vals));
            v.remove(0);
        } else {
            v = new Vector<String>();
            v.addElement(s);
        }
        LOGGER.exiting(S_CLASS_NAME, "decryptPossiblyMultiValuedPassword");
        return v;
    }

    @Override
    public String encryptPassword(String plainText) {
        LOGGER.entering(S_CLASS_NAME, "encryptPassword");
        LOGGER.exiting(S_CLASS_NAME, "encryptPassword");
        return PasswordUtil.passwordEncode((String)plainText);
    }

    @Override
    public String encryptPassword(String plainText, String cryptoAlgorithm) {
        LOGGER.entering(S_CLASS_NAME, "encryptPassword");
        LOGGER.exiting(S_CLASS_NAME, "encryptPassword");
        return PasswordUtil.passwordEncode((String)plainText, (String)cryptoAlgorithm);
    }

    @Override
    public boolean isEncrypted(String text) {
        LOGGER.entering(S_CLASS_NAME, "isEncrypted");
        LOGGER.exiting(S_CLASS_NAME, "isEncrypted");
        return PasswordUtil.isEncrypted((String)text);
    }
}

