/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.MessageFormatUtils;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import com.ibm.ws.install.configmanager.utils.ValidationManager;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationManagerUtils {
    private static List m_listSortedValidationManagers = null;
    private static Hashtable<String, List> m_hashtableValidationErrorMessages = null;
    private static Hashtable<File, ValidationManager> m_hashtableVMCache = null;
    private static final boolean F_DEFAULT_VALIDATION_VALUE = true;
    private static final String S_EMPTY = "";
    private static final String S_VALIDATION_ERROR_KEY = "WSProfile.WSProfileCLIModeInvoker.validationError";
    private static final Logger LOGGER = LoggerFactory.createLogger(ValidationManagerUtils.class);
    private static final String S_CLASS_NAME = ValidationManagerUtils.class.getName();

    public static boolean isArgumentValueValid(String sArgumentKey, String sArgumentValue) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        return ValidationManagerUtils.isArgumentValueValid(sArgumentKey, sArgumentValue, new Hashtable());
    }

    public static boolean isArgumentValueValid(String sArgumentKey, String sArgumentValue, Map mapAllActionArguments) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        Hashtable mapAllActionArgumentsLocal = (Hashtable)mapAllActionArguments;
        String[] saArgumentKey = new String[]{sArgumentKey};
        mapAllActionArgumentsLocal.put(sArgumentKey, sArgumentValue);
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapAllActionArgumentsLocal);
        ValidationManagerUtils.initialize();
        Hashtable hashtableValidationManagersAndArgs = ValidationManagerUtils.matchArgumentsToValidationManagers(saArgumentKey);
        boolean fisValid = ValidationManagerUtils.executeAllValidators(hashtableValidationManagersAndArgs, mapAllActionArgumentsLocal);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        return fisValid;
    }

    public static boolean areAllArgumentsValid(Map mapAllArguments) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "areAllArgumentsValid");
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapAllArguments);
        ValidationManagerUtils.initialize();
        boolean fisValid = ValidationManagerUtils.executeAllValidators(mapAllArguments);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "areAllArgumentsValid");
        return fisValid;
    }

    public static boolean areAllArgumentsValid(String sMode, Map mapAllArguments, List<WSProfileTemplate> lwsptTemplateStack) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "areAllArgumentsValid");
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapAllArguments);
        ValidationManagerUtils.initialize(sMode, lwsptTemplateStack);
        boolean fisValid = ValidationManagerUtils.executeAllValidators(mapAllArguments);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "areAllArgumentsValid");
        return fisValid;
    }

    public static Hashtable getAllErrorMessages() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "getAllErrorMessages");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "getAllErrorMessages");
        return m_hashtableValidationErrorMessages;
    }

    public static List getErrorMessagesForArgument(String sArgumentKey) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "getErrorMessagesForArgument");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "getErrorMessagesForArgument");
        return m_hashtableValidationErrorMessages.get(sArgumentKey);
    }

    public static void reinitialize() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "reinitialize");
        ValidationManagerUtils.resetHastableVMCache();
        ValidationManagerUtils.initialize();
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "reinitialize");
    }

    public static void resetHastableVMCache() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "reinitialize");
        m_listSortedValidationManagers = null;
        m_hashtableVMCache = null;
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "reinitialize");
    }

    public static void printOutValidationResults(Map mapValidationFailures) {
        LOGGER.entering(S_CLASS_NAME, "printOutValidationResults");
        OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_VALIDATION_ERROR_KEY));
        Enumeration enumArgKeys = ((Hashtable)mapValidationFailures).keys();
        while (enumArgKeys.hasMoreElements()) {
            String sArgumentKey = (String)enumArgKeys.nextElement();
            List listValidationErrors = (List)mapValidationFailures.get(sArgumentKey);
            for (int j = 0; j < listValidationErrors.size(); ++j) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "printOutValidationResults", "Validation error for " + sArgumentKey + ": " + listValidationErrors.get(j));
                String sRawMessage = (String)listValidationErrors.get(j);
                String sFormatedMessage = MessageFormatUtils.formatMessage(sRawMessage, new String[]{sArgumentKey});
                OutputStreamHandler.println("\t" + sArgumentKey + ": " + sFormatedMessage);
            }
        }
        OutputStreamHandler.init();
        LOGGER.exiting(S_CLASS_NAME, "printOutValidationResults");
    }

    private static void initialize() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "initialize");
        if (m_hashtableVMCache == null) {
            m_hashtableVMCache = new Hashtable();
        }
        ValidationManagerUtils.clearErrorMessages();
        String sTemplatePath = ValidationManagerUtils.determineTemplatePath();
        String sMode = ValidationManagerUtils.determineCurrentMode();
        String sProfileName = ValidationManagerUtils.determineProfileName();
        List<WSProfileTemplate> listTemplates = PrereqTemplateUtils.getListOfTemplatePathsForMode(sMode, sProfileName, sTemplatePath);
        ValidationManagerUtils.createValidationManagers(listTemplates, sMode);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "initialize");
    }

    private static void initialize(String sMode, List<WSProfileTemplate> lwsptTemplateStack) {
        ValidationManagerUtils.createValidationManagers(lwsptTemplateStack, sMode);
    }

    private static void clearErrorMessages() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "clearErrorMessages");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "clearErrorMessages");
        m_hashtableValidationErrorMessages = new Hashtable();
    }

    private static void createValidationManagers(List<WSProfileTemplate> l_wsptTemplateStack, String sMode) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "createValidationManagers");
        Vector<ValidationManager> listValidationManagers = new Vector<ValidationManager>();
        if (m_hashtableVMCache == null) {
            m_hashtableVMCache = new Hashtable();
        }
        for (int i = 0; i < l_wsptTemplateStack.size(); ++i) {
            ValidationManager vmCurrent;
            File fileProfileTemplate = l_wsptTemplateStack.get(i).getProfileTemplatePath();
            if (m_hashtableVMCache.get(fileProfileTemplate) != null) {
                vmCurrent = m_hashtableVMCache.get(fileProfileTemplate);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "createValidationManager", "m_hashtableVMCache :\n" + fileProfileTemplate);
            } else {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "createValidationManager", "m_hashtableVMCache is empty");
                String sTemplatePath = fileProfileTemplate.getAbsolutePath();
                String sActionRegistry = ValidationManagerUtils.determineActionRegistryFileName();
                vmCurrent = new ValidationManager(sTemplatePath, sTemplatePath + File.separator + sActionRegistry);
                m_hashtableVMCache.put(fileProfileTemplate, vmCurrent);
            }
            listValidationManagers.add(vmCurrent);
        }
        m_listSortedValidationManagers = listValidationManagers;
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "createValidationManagers");
    }

    private static String determineActionRegistry() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineActionRegistry");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistry");
        return System.getProperty("WS_CMT_ACTION_REGISTRY");
    }

    private static Hashtable matchArgumentsToValidationManagers(String[] saArgumentKeys) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "matchArgumentsToValidationManager");
        Hashtable<ValidationManager, Vector> hastableArugmentsByValidationManager = new Hashtable<ValidationManager, Vector>();
        for (int i = 0; i < saArgumentKeys.length; ++i) {
            List listValidationManager = ValidationManagerUtils.findValidationManagersForArgument(saArgumentKeys[i]);
            for (int j = 0; j < listValidationManager.size(); ++j) {
                Vector vectorArgumentKeys;
                ValidationManager vmCurrent = (ValidationManager)listValidationManager.get(j);
                if (hastableArugmentsByValidationManager.containsKey(vmCurrent)) {
                    vectorArgumentKeys = (Vector)hastableArugmentsByValidationManager.get(vmCurrent);
                    vectorArgumentKeys.add(saArgumentKeys[i]);
                    continue;
                }
                vectorArgumentKeys = new Vector();
                vectorArgumentKeys.add(saArgumentKeys[i]);
                hastableArugmentsByValidationManager.put(vmCurrent, vectorArgumentKeys);
            }
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "matchArgumentsToValidationManager");
        return hastableArugmentsByValidationManager;
    }

    private static boolean executeAllValidators(Map mapValidationManagersAndArgs, Map mapSetArgs) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "executeAllValidators");
        boolean fOverallStatus = true;
        ValidationManagerUtils.clearErrorMessages();
        for (ValidationManager vmCurrent : mapValidationManagersAndArgs.keySet()) {
            Vector vsArgKeys;
            if (vmCurrent.areAllArgumentsValid(vsArgKeys = (Vector)mapValidationManagersAndArgs.get(vmCurrent), mapSetArgs)) continue;
            Hashtable hashtableErrorMessagesForThisVM = vmCurrent.getAllErrorMessages();
            ValidationManagerUtils.storeErrorMessages(hashtableErrorMessagesForThisVM);
            fOverallStatus = false;
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "executeAllValidators");
        return fOverallStatus;
    }

    private static boolean executeAllValidators(Map mapSetArgs) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "executeAllValidators");
        boolean fOverallStatus = true;
        ValidationManagerUtils.clearErrorMessages();
        for (int i = 0; i < m_listSortedValidationManagers.size(); ++i) {
            ValidationManager vmCurrent = (ValidationManager)m_listSortedValidationManagers.get(i);
            if (vmCurrent.areAllArgumentsValid(mapSetArgs)) continue;
            Hashtable hashtableErrorMessagesForThisVM = vmCurrent.getAllErrorMessages();
            ValidationManagerUtils.storeErrorMessages(hashtableErrorMessagesForThisVM);
            fOverallStatus = false;
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "executeAllValidators");
        return fOverallStatus;
    }

    private static void storeErrorMessages(Map mapValidationErrors) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "storeErrorMessage");
        Hashtable mapValidationErrorsLocal = (Hashtable)mapValidationErrors;
        for (String sArgumentKey : mapValidationErrorsLocal.keySet()) {
            List listAdditionalArgumentValidationErrorMessages = (List)mapValidationErrorsLocal.get(sArgumentKey);
            if (m_hashtableValidationErrorMessages.containsKey(sArgumentKey) && m_hashtableValidationErrorMessages.get(sArgumentKey) != null) {
                Vector listCurrentArgumentValidationErrorMessage = (Vector)m_hashtableValidationErrorMessages.get(sArgumentKey);
                listCurrentArgumentValidationErrorMessage.addAll(listAdditionalArgumentValidationErrorMessages);
                continue;
            }
            m_hashtableValidationErrorMessages.put(sArgumentKey, listAdditionalArgumentValidationErrorMessages);
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "storeErrorMessage");
    }

    private static List findValidationManagersForArgument(String sArgumentKey) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "findValidationManagersForArgument");
        Vector<ValidationManager> listApplicableValidationManagers = new Vector<ValidationManager>();
        for (int i = m_listSortedValidationManagers.size() - 1; i >= 0; --i) {
            ValidationManager vmCurrent = (ValidationManager)m_listSortedValidationManagers.get(i);
            if (!vmCurrent.isArgumentAvailableForValidating(sArgumentKey)) continue;
            listApplicableValidationManagers.add(vmCurrent);
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "findValidationManagersForArgument");
        return listApplicableValidationManagers;
    }

    private static String determineTemplatePath() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineTemplatePath");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineTemplatePath");
        return System.getProperty("WS_CMT_CONF_DIR");
    }

    private static String determineProfileName() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineProfileName");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineProfileName");
        return System.getProperty("profileName");
    }

    private static String determineActionRegistryFileName() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
        String sFullActionRegistryName = ValidationManagerUtils.determineActionRegistry();
        if (sFullActionRegistryName != null && !sFullActionRegistryName.equals(S_EMPTY)) {
            File fileActionRegistry = new File(sFullActionRegistryName);
            LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
            return fileActionRegistry.getName();
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
        return S_EMPTY;
    }

    private static String determineCurrentMode() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineCurrentMode");
        String sMode = null;
        String sModeCreate = System.getProperty("create");
        String sModeAugment = System.getProperty("augment");
        String sModeBackup = System.getProperty("backupProfile");
        String sModeRestore = System.getProperty("restoreProfile");
        if (sModeCreate == null && sModeAugment == null && sModeBackup == null && sModeRestore == null) {
            sMode = null;
        } else if (sModeBackup != null && sModeBackup.equals(S_EMPTY)) {
            sMode = "backupProfile";
        } else if (sModeRestore != null && sModeRestore.equals(S_EMPTY)) {
            sMode = "restoreProfile";
        } else if (sModeCreate == null && sModeAugment.equals(S_EMPTY)) {
            sMode = "augment";
        } else if (sModeCreate != null && sModeCreate.equals(S_EMPTY) && sModeAugment == null) {
            sMode = "create";
        } else if (sModeCreate.equals(S_EMPTY) && sModeAugment.equals(S_EMPTY)) {
            sMode = null;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineCurrentMode", "Mode was determined to be: " + sMode);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineCurrentMode");
        return sMode;
    }
}

