/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringUtils {
    private static final String S_COMMA = ",";
    private static final String S_SPACE = " ";
    private static final String S_EMPTY = "";
    private static final String S_PASSWD_HIDE = "****************";
    private static final String S_PASSWD_PARAMETER = "winservicePassword";
    private static final int I_INITIAL_INDEX = -999;
    public static final Logger LOGGER = LoggerFactory.createLogger(StringUtils.class);
    private static String S_CLASS_NAME = StringUtils.class.getName();

    public static String convertStringArrayToCommaSeparatedString(String[] asIn) {
        String sReturn = S_EMPTY;
        for (int i = 0; i < asIn.length; ++i) {
            sReturn = i < asIn.length - 1 ? sReturn + asIn[i] + S_COMMA + S_SPACE : sReturn + asIn[i];
        }
        return sReturn;
    }

    public static String[] hidePasswordArgs(String[] args) {
        LOGGER.entering(S_CLASS_NAME, "hidePasswordArgs");
        String[] sArgsLogs = new String[args.length];
        System.arraycopy(args, 0, sArgsLogs, 0, args.length);
        String[] sMaskableActionArguments = StringUtils.getMaskableArgs();
        if (sMaskableActionArguments == null) {
            return sArgsLogs;
        }
        int iPasswordIndex = -999;
        for (int i = 0; i < sArgsLogs.length; ++i) {
            if (iPasswordIndex != -999) {
                sArgsLogs[iPasswordIndex] = S_PASSWD_HIDE;
            }
            for (int j = 0; j < sMaskableActionArguments.length; ++j) {
                if (!sArgsLogs[i].equals("-" + sMaskableActionArguments[j])) continue;
                iPasswordIndex = i + 1;
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "hidePasswordArgs");
        return sArgsLogs;
    }

    public static String[] getMaskableArgs() {
        LOGGER.entering(S_CLASS_NAME, "getMaskableArgs");
        String sMaskableArgs = S_EMPTY;
        try {
            sMaskableArgs = new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS");
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        catch (IOException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        catch (NullPointerException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties.");
        }
        if (sMaskableArgs.indexOf(S_PASSWD_PARAMETER) == -1) {
            sMaskableArgs = "winservicePassword;" + sMaskableArgs;
        }
        Object[] sMaskableArgsList = sMaskableArgs.split(";");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "Maskable Action Arguments: " + LogUtils.getArrayAsALoggableString(sMaskableArgsList));
        LOGGER.exiting(S_CLASS_NAME, "getMaskableArgs");
        return sMaskableArgsList;
    }
}

