/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.prereqtree.OperatorExpressionTree;
import com.ibm.ws.profile.prereqtree.WSProfileDisabledAction;
import com.ibm.ws.profile.prereqtree.WSProfileTemplateExpressionTree;
import com.ibm.ws.profile.prereqtree.WSProfileTemplatePrereqData;
import com.ibm.ws.profile.utils.PrereqTreeUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.prereqtree.GenericExpressionTree;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrereqTemplateUtils {
    private static int N_ONE = 1;
    private static int N_ZERO = 0;
    private static int N_NEGATIVE_ONE = -1;
    private static final String S_PREREQ_TEMPLATE_ERROR_KEY = "WSProfile.PrereqTemplateUtils.prereqTemplateError";
    private static final Logger LOGGER = LoggerFactory.createLogger(PrereqTemplateUtils.class);
    private static final String S_CLASS_NAME = PrereqTemplateUtils.class.getName();

    public static List<WSProfileTemplate> getTemplatesForStackCreation(File fileTemplatePath) throws WSProfileException {
        Vector<File> lfileTemplatePaths = new Vector<File>();
        lfileTemplatePaths.add(fileTemplatePath);
        return PrereqTemplateUtils.getTemplatesForStackCreation(lfileTemplatePaths);
    }

    public static Vector<WSProfileTemplate> getTemplatesForStackCreation(List<File> lfileTemplatePaths) throws WSProfileException {
        Vector<WSProfileTemplate> lwsptTemplateStack = new Vector<WSProfileTemplate>();
        for (int i = 0; i < lfileTemplatePaths.size(); ++i) {
            lwsptTemplateStack.add(new WSProfileTemplate(lfileTemplatePaths.get(i)));
        }
        return (Vector)PrereqTemplateUtils.getTemplatesForStackCreation(lwsptTemplateStack);
    }

    public static List<WSProfileTemplate> getTemplatesForStackCreation(WSProfileTemplate wsptForLaunch) throws WSProfileException {
        Vector<WSProfileTemplate> lwsptForLaunch = new Vector<WSProfileTemplate>();
        lwsptForLaunch.add(wsptForLaunch);
        return PrereqTemplateUtils.getTemplatesForStackCreation(lwsptForLaunch);
    }

    public static List<WSProfileTemplate> getTemplatesForStackCreation(List<WSProfileTemplate> lwsptTemplateStack) throws WSProfileException {
        Vector vlfilePrereqs = (Vector)PrereqTemplateUtils.getPrereqPaths(lwsptTemplateStack);
        Vector v_currentPath = (Vector)PrereqTemplateUtils.getBestCreationPath(vlfilePrereqs);
        return v_currentPath;
    }

    private static List<WSProfileTemplate> removeDuplicates(List<WSProfileTemplate> lwsptDuplicatesList) {
        Vector<WSProfileTemplate> v_newWsptList = new Vector<WSProfileTemplate>();
        for (int i = 0; i < lwsptDuplicatesList.size(); ++i) {
            WSProfileTemplate wsptCurrent = lwsptDuplicatesList.get(i);
            if (v_newWsptList.contains(wsptCurrent)) continue;
            v_newWsptList.add(wsptCurrent);
        }
        return v_newWsptList;
    }

    public static List<WSProfileTemplate> getListOfTemplatePathsForStackCreate(String sIncomingProfileTemplatePath) {
        Vector<String> lsIncomingProfileTemplatePath = new Vector<String>();
        lsIncomingProfileTemplatePath.add(sIncomingProfileTemplatePath);
        return PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(lsIncomingProfileTemplatePath);
    }

    public static List<WSProfileTemplate> getListOfTemplatePathsForStackCreate(List<String> lsIncomingProfileTemplatePath) {
        Vector vwsptTemplateStack = new Vector();
        try {
            vwsptTemplateStack = (Vector)PrereqTemplateUtils.getTemplatesForStackCreation(PrereqTemplateUtils.convertStringTemplatePathsToWSProfileTemplateList(lsIncomingProfileTemplatePath));
        }
        catch (WSProfileException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfTemplatePathsForStackCreate", "Could not build a list of prerequisite profile templates for profile template " + lsIncomingProfileTemplatePath);
            return new Vector<WSProfileTemplate>();
        }
        return vwsptTemplateStack;
    }

    public static List<WSProfileTemplate> getTemplatesForStackAugmentation(File fileTemplatePath, Profile profileThis) throws WSProfileException {
        Vector<File> lfileTemplatePath = new Vector<File>();
        lfileTemplatePath.add(fileTemplatePath);
        return PrereqTemplateUtils.getTemplatesForStackAugmentation(lfileTemplatePath, profileThis);
    }

    public static List<WSProfileTemplate> getTemplatesForStackAugmentation(List<File> lfileTemplatePath, Profile profileThis) throws WSProfileException {
        Vector<WSProfileTemplate> l_wspt = new Vector<WSProfileTemplate>();
        for (int i = 0; i < lfileTemplatePath.size(); ++i) {
            l_wspt.add(new WSProfileTemplate(lfileTemplatePath.get(i)));
        }
        return PrereqTemplateUtils.getTemplatesForStackAugmentation(l_wspt, profileThis);
    }

    public static List<WSProfileTemplate> getTemplatesForStackAugmentation(WSProfileTemplate wsptForAugmentation, Profile profileThis) throws WSProfileException {
        Vector<WSProfileTemplate> lwsptTemplateStack = new Vector<WSProfileTemplate>();
        lwsptTemplateStack.add(wsptForAugmentation);
        return PrereqTemplateUtils.getTemplatesForStackAugmentation(lwsptTemplateStack, profileThis);
    }

    public static Vector<WSProfileTemplate> getTemplatesForStackAugmentation(List<WSProfileTemplate> wsptForAugment, Profile profileThis) throws WSProfileException {
        Vector vwsptPrereqs = (Vector)PrereqTemplateUtils.getPrereqPaths(wsptForAugment);
        Vector vwsptCurrentPath = (Vector)PrereqTemplateUtils.getBestAugmentationPath(vwsptPrereqs, profileThis);
        Vector<WSProfileTemplate> vwsptStrippedPaths = PrereqTemplateUtils.removeExistingPrereqsForAugment(vwsptCurrentPath, profileThis);
        return vwsptStrippedPaths;
    }

    public static boolean isValidToAugment(WSProfileTemplate wsptAugment, WSProfileTemplate wsptThisProfileTemplate) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "isValidToAugment");
        Vector vwsptPrereqs = (Vector)PrereqTemplateUtils.getPrereqPaths(wsptAugment);
        for (int i = 0; i < vwsptPrereqs.size(); ++i) {
            File filePrereqPathCreateTemplate = ((WSProfileTemplate)((List)vwsptPrereqs.get(i)).get(0)).getProfileTemplatePath();
            if (filePrereqPathCreateTemplate.equals(wsptAugment.getProfileTemplatePath()) && ((List)vwsptPrereqs.get(i)).size() == 1) {
                LOGGER.exiting(S_CLASS_NAME, "isValidToAugment");
                return true;
            }
            if (!filePrereqPathCreateTemplate.equals(wsptThisProfileTemplate.getProfileTemplatePath())) continue;
            LOGGER.exiting(S_CLASS_NAME, "isValidToAugment");
            return true;
        }
        LOGGER.exiting(S_CLASS_NAME, "isValidToAugment");
        return false;
    }

    private static List<WSProfileTemplate> getBestAugmentationPath(List<List<WSProfileTemplate>> l_allPrereqPaths, Profile profileThis) throws WSProfileException {
        if (l_allPrereqPaths.size() == 0) {
            return new Vector<WSProfileTemplate>();
        }
        if (l_allPrereqPaths.size() == 1) {
            Vector v_current = (Vector)l_allPrereqPaths.get(0);
            v_current.add(0, profileThis.getWSProfileTemplate());
            v_current = (Vector)PrereqTemplateUtils.removeDuplicates(v_current);
            PrereqTemplateUtils.validateTemplatesInListForAugmentation(v_current, profileThis);
            return v_current;
        }
        Vector v_existingTemplates = new Vector();
        if (profileThis != null) {
            v_existingTemplates = (Vector)profileThis.getAugmentationTemplates();
            v_existingTemplates.add(0, profileThis.getWSProfileTemplate());
        }
        int nCurrentMax = 0;
        Vector vCurrentBest = new Vector();
        Vector vFirstBest = null;
        for (int i = 0; i < l_allPrereqPaths.size(); ++i) {
            Vector v_current = (Vector)l_allPrereqPaths.get(i);
            v_current = (Vector)PrereqTemplateUtils.removeDuplicates(v_current);
            if (profileThis != null && !PrereqTemplateUtils.pathExistsInList((WSProfileTemplate)v_existingTemplates.get(0), v_current)) continue;
            int nTempCount = 0;
            for (int j = 0; j < v_existingTemplates.size(); ++j) {
                if (!PrereqTemplateUtils.pathExistsInList((WSProfileTemplate)v_existingTemplates.get(j), v_current)) continue;
                ++nTempCount;
            }
            if (nTempCount <= nCurrentMax) continue;
            try {
                PrereqTemplateUtils.validateTemplatesInListForAugmentation(v_current, profileThis);
                v_current.addAll(0, v_existingTemplates);
                v_current = (Vector)PrereqTemplateUtils.removeDuplicates(v_current);
                if (vFirstBest == null) {
                    vFirstBest = v_current;
                }
                vCurrentBest = v_current;
                nCurrentMax = nTempCount;
                continue;
            }
            catch (WSProfileException e) {
                if (i >= l_allPrereqPaths.size() - 1 && vFirstBest == null) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getBestAugmentationPath", "The list of prereqs passed in does not pass validation.  Exiting with an exception");
                    throw e;
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getBestAugmentationPath", "Problem with the list:" + v_current + "\nThe following exception was caught.  There are more potential prerequisite template paths" + " to scan, ignoring exception.");
                LogUtils.logException(LOGGER, e);
            }
        }
        if (nCurrentMax == 0 && vFirstBest != null) {
            vCurrentBest = vFirstBest;
        }
        return vCurrentBest;
    }

    private static List<WSProfileTemplate> getBestCreationPath(List<List<WSProfileTemplate>> l_allPrereqPaths) throws WSProfileException {
        if (l_allPrereqPaths.size() == 0) {
            return new Vector<WSProfileTemplate>();
        }
        if (l_allPrereqPaths.size() == 1) {
            Vector v_current = (Vector)l_allPrereqPaths.get(0);
            v_current = (Vector)PrereqTemplateUtils.removeDuplicates(v_current);
            PrereqTemplateUtils.validateTemplatesInListForCreation(v_current);
            return v_current;
        }
        Vector vCurrentBest = new Vector();
        for (int i = 0; i < l_allPrereqPaths.size(); ++i) {
            Vector v_current = (Vector)l_allPrereqPaths.get(i);
            v_current = (Vector)PrereqTemplateUtils.removeDuplicates(v_current);
            try {
                PrereqTemplateUtils.validateTemplatesInListForCreation(v_current);
                vCurrentBest = v_current;
                return v_current;
            }
            catch (WSProfileException e) {
                if (i >= l_allPrereqPaths.size() - 1) {
                    throw e;
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getBestCreationPath", "Problem with the list:" + v_current + "\nThe following exception was caught.  There are more potential prerequisite template paths" + " to scan, ignoring exception.");
                LogUtils.logException(LOGGER, e);
                continue;
            }
        }
        return vCurrentBest;
    }

    private static boolean pathExistsInList(WSProfileTemplate wsptToSearchFor, List<WSProfileTemplate> lwsptAll) {
        WSProfileTemplate wspt_currentPath = wsptToSearchFor;
        for (int i = 0; i < lwsptAll.size(); ++i) {
            WSProfileTemplate wspt_temp = lwsptAll.get(i);
            if (!wspt_currentPath.equals(wspt_temp)) continue;
            return true;
        }
        return false;
    }

    public static Vector<WSProfileTemplate> getListOfTemplatePathsForStackAugment(String sIncomingProfileTemplatePath, String sProfileName) {
        Vector<String> lwsptTemplateStack = new Vector<String>();
        lwsptTemplateStack.add(sIncomingProfileTemplatePath);
        return PrereqTemplateUtils.getListOfTemplatePathsForStackAugment(lwsptTemplateStack, sProfileName);
    }

    public static Vector<WSProfileTemplate> getListOfTemplatePathsForStackAugment(List<String> lsTemplatePaths, String sProfileName) {
        Vector<WSProfileTemplate> vwsptTemplateStack = new Vector();
        try {
            vwsptTemplateStack = PrereqTemplateUtils.getTemplatesForStackAugmentation(PrereqTemplateUtils.convertStringTemplatePathsToWSProfileTemplateList(lsTemplatePaths), WSProfile.getProfile(sProfileName));
        }
        catch (WSProfileException e) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfTemplatePathsForStackAugment", lsTemplatePaths + " is not a valid profile template.");
            return new Vector<WSProfileTemplate>();
        }
        return vwsptTemplateStack;
    }

    private static List<WSProfileTemplate> convertStringTemplatePathsToWSProfileTemplateList(List<String> lsTemplatePaths) throws WSProfileException {
        Vector<WSProfileTemplate> vwsptTemplates = new Vector<WSProfileTemplate>();
        for (int i = 0; i < lsTemplatePaths.size(); ++i) {
            vwsptTemplates.add(PrereqTemplateUtils.convertStringTemplatePathToWSProfileTemplate(lsTemplatePaths.get(i)));
        }
        return vwsptTemplates;
    }

    private static WSProfileTemplate convertStringTemplatePathToWSProfileTemplate(String sTemplatePath) throws WSProfileException {
        return new WSProfileTemplate(new File(sTemplatePath));
    }

    public static List<WSProfileTemplate> getListOfTemplatePathsForMode(String sMode, String sProfileName, String sTemplatePath) {
        LOGGER.entering(S_CLASS_NAME, "getListOfTemplatePathsForMode");
        Vector<String> lwsptTemplate = new Vector<String>();
        lwsptTemplate.add(sTemplatePath);
        LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForMode");
        return PrereqTemplateUtils.getListOfTemplatesForMode(sMode, sProfileName, lwsptTemplate);
    }

    public static List<WSProfileTemplate> getListOfTemplatesForMode(String sMode, String sProfileName, List<String> listTemplatePath) {
        LOGGER.entering(S_CLASS_NAME, "getListOfTemplatePathsForMode");
        Vector vwsptTemplateStack = new Vector();
        if (sMode != null && sMode.equals("create") && listTemplatePath != null && listTemplatePath.size() > 0) {
            vwsptTemplateStack = (Vector)PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(listTemplatePath);
        } else if (sMode != null && sMode.equals("augment") && listTemplatePath != null && listTemplatePath.size() > 0 && sProfileName != null) {
            vwsptTemplateStack = PrereqTemplateUtils.getListOfTemplatePathsForStackAugment(listTemplatePath, sProfileName);
        } else if (sMode != null && sMode.equals("backupProfile") && sProfileName != null) {
            vwsptTemplateStack = (Vector)PrereqTemplateUtils.getListOfTemplatePathsForDelete(sProfileName);
        } else if (sMode != null && sMode.equals("delete") && sProfileName != null) {
            vwsptTemplateStack = (Vector)PrereqTemplateUtils.getListOfTemplatePathsForDelete(sProfileName);
        } else if (sMode != null && sMode.equals("unaugment") && sProfileName != null) {
            vwsptTemplateStack = (Vector)PrereqTemplateUtils.getListOfTemplatePathsForUnaugment(sProfileName, listTemplatePath);
        }
        LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForMode");
        return vwsptTemplateStack;
    }

    public static List<WSProfileTemplate> getListOfTemplatePathsForDelete(String sProfileName) {
        List<WSProfileTemplate> lwsptAugmentingTemplates;
        Profile profileThis;
        LOGGER.entering(S_CLASS_NAME, "getListOfTemplatePathsForDelete");
        Vector<WSProfileTemplate> vwsptTemplateStack = new Vector<WSProfileTemplate>();
        try {
            profileThis = WSProfile.getProfile(sProfileName);
        }
        catch (WSProfileException wspEx) {
            LogUtils.logException(LOGGER, wspEx);
            LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForDelete");
            return new Vector<WSProfileTemplate>();
        }
        try {
            vwsptTemplateStack.add(profileThis.getWSProfileTemplate());
        }
        catch (WSProfileException wspEx) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "create", "The profile template pointed by " + profileThis.getWSProfileTemplateRelaxed().getProfileTemplatePath() + " might not exists on the file system or its metadata might be corrupt. " + "This template will still be added to the list of template paths.");
            vwsptTemplateStack.add(profileThis.getWSProfileTemplateRelaxed());
        }
        try {
            lwsptAugmentingTemplates = profileThis.getAugmentationTemplates();
        }
        catch (WSProfileException wspEx) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "create", "One of the augmentation templates for profile " + profileThis + " might not exists on the file system or its metadata might be corrupt. " + "This template will still be added to the list of template paths.");
            lwsptAugmentingTemplates = profileThis.getAugmentationTemplatesRelaxed();
        }
        if (lwsptAugmentingTemplates != null) {
            vwsptTemplateStack.addAll(lwsptAugmentingTemplates);
        }
        LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForDelete");
        return vwsptTemplateStack;
    }

    public static List<WSProfileTemplate> getListOfTemplatePathsForUnaugment(String sProfileName, List<String> lsTemplatePath) {
        Vector<WSProfileTemplate> vwsptTemplateStack;
        block7: {
            LOGGER.entering(S_CLASS_NAME, "getListOfTemplatePathsForUnaugment");
            vwsptTemplateStack = new Vector<WSProfileTemplate>();
            Vector vwsptAugmentingTemplates = new Vector();
            try {
                vwsptAugmentingTemplates = (Vector)WSProfile.getProfile(sProfileName).getAugmentationTemplates();
                if (WSProfileDataStore.getFlowControllingModeInvoker().getModeFlag().equals("unaugmentAll") || WSProfileDataStore.isArgSpecified("ignoreStack") || System.getProperty("ignoreStack") != null && System.getProperty("ignoreStack").equals("")) {
                    if (lsTemplatePath != null && lsTemplatePath.size() > 0) {
                        WSProfileTemplate wsptTemplateToUnaugment = PrereqTemplateUtils.convertStringTemplatePathToWSProfileTemplate(lsTemplatePath.get(0));
                        for (int i = 0; i < vwsptAugmentingTemplates.size(); ++i) {
                            if (!((WSProfileTemplate)vwsptAugmentingTemplates.elementAt(i)).equals(wsptTemplateToUnaugment)) continue;
                            Vector v_wsptDependantTemplates = (Vector)PrereqTemplateUtils.getListOfDependantTemplates(sProfileName, (WSProfileTemplate)vwsptAugmentingTemplates.elementAt(i));
                            v_wsptDependantTemplates.remove(vwsptAugmentingTemplates.elementAt(i));
                            if (v_wsptDependantTemplates == null || v_wsptDependantTemplates.size() == 0) {
                                vwsptTemplateStack.add(wsptTemplateToUnaugment);
                            }
                            LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForUnaugment");
                            return vwsptTemplateStack;
                        }
                    }
                    break block7;
                }
                if (vwsptAugmentingTemplates.size() >= 1) {
                    WSProfileTemplate wsptTemplateToUnaugment = (WSProfileTemplate)vwsptAugmentingTemplates.get(vwsptAugmentingTemplates.size() - 1);
                    vwsptTemplateStack.add(wsptTemplateToUnaugment);
                }
                LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForUnaugment");
                return vwsptTemplateStack;
            }
            catch (WSProfileException wspEx) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getListOfTemplatePathsForUnaugment", sProfileName + " is not a valid profile name or the templatePath " + lsTemplatePath.get(0) + " refer to an existing template");
                LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForUnaugment");
                return new Vector<WSProfileTemplate>();
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForUnaugment");
        return vwsptTemplateStack;
    }

    public static Map<String, Vector<WSProfileTemplate>> getMapOfTemplatesForAllMode(String sMode, List<String> lsTemplatePath) {
        LOGGER.entering(S_CLASS_NAME, "getListOfTemplatePathsForAllMode");
        Hashtable<String, Vector<WSProfileTemplate>> htTemplatePaths = new Hashtable<String, Vector<WSProfileTemplate>>();
        Vector lsProfileNames = new Vector();
        Vector vwsptAugmentingTemplates = new Vector();
        String sProfileName = new String();
        if (sMode != null && WSProfile.isAllMode(sMode)) {
            try {
                lsProfileNames = (Vector)WSProfile.listAllProfileNames();
                for (int i = 0; i < lsProfileNames.size(); ++i) {
                    sProfileName = (String)lsProfileNames.get(i);
                    if (sMode.equals("deleteAll")) {
                        htTemplatePaths.put(sProfileName, (Vector)PrereqTemplateUtils.getListOfTemplatePathsForDelete(sProfileName));
                        continue;
                    }
                    if (!sMode.equals("unaugmentAll") || !WSProfile.getProfile(sProfileName).getAugmentationTemplates().contains(PrereqTemplateUtils.convertStringTemplatePathToWSProfileTemplate(lsTemplatePath.get(0)))) continue;
                    vwsptAugmentingTemplates = WSProfileDataStore.isArgSpecified("unaugmentDependents") ? (Vector)PrereqTemplateUtils.getListOfDependantTemplates(sProfileName, PrereqTemplateUtils.convertStringTemplatePathToWSProfileTemplate(lsTemplatePath.get(0))) : (Vector)PrereqTemplateUtils.getListOfTemplatePathsForUnaugment(sProfileName, lsTemplatePath);
                    htTemplatePaths.put(sProfileName, vwsptAugmentingTemplates);
                }
            }
            catch (WSProfileException wspEx) {
                LogUtils.logException(LOGGER, wspEx);
                LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForAllMode");
                return new Hashtable<String, Vector<WSProfileTemplate>>();
            }
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getListOfTemplatePathsForAllMode", sMode + " is not an 'All' type mode.");
            LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForAllMode");
            return new Hashtable<String, Vector<WSProfileTemplate>>();
        }
        LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForAllMode");
        return htTemplatePaths;
    }

    private static void validateTemplatesInListForCreation(List<WSProfileTemplate> l_templateList) throws WSProfileException {
        Vector<WSProfileTemplate> v_wsptList = new Vector<WSProfileTemplate>();
        for (int i = 0; i < l_templateList.size(); ++i) {
            WSProfileTemplate wsptThis = l_templateList.get(i);
            v_wsptList.add(wsptThis);
        }
        PrereqTemplateUtils.validateListForCreation(v_wsptList);
    }

    private static void validateTemplatesInListForAugmentation(List<WSProfileTemplate> l_templateList, Profile profileThis) throws WSProfileException {
        Vector<WSProfileTemplate> v_wsptList = new Vector<WSProfileTemplate>();
        for (int i = 0; i < l_templateList.size(); ++i) {
            WSProfileTemplate wsptThis = new WSProfileTemplate(l_templateList.get(i).getProfileTemplatePath());
            v_wsptList.add(wsptThis);
        }
        PrereqTemplateUtils.validateListForAugmentation(v_wsptList, profileThis);
    }

    public static void validateListForCreation(Vector v_wsptPrereqTemplates) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "validateListForCreation");
        boolean f_isValid = true;
        WSProfileTemplate wsptTemp = (WSProfileTemplate)v_wsptPrereqTemplates.get(N_ZERO);
        f_isValid = f_isValid && wsptTemp.isCreateTemplate();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForCreation", "Evaluating if " + wsptTemp.getProfileTemplatePath() + " is a profile-creating template.");
        for (int i = 1; i < v_wsptPrereqTemplates.size() && f_isValid; ++i) {
            wsptTemp = (WSProfileTemplate)v_wsptPrereqTemplates.get(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForCreation", "Evaluating if " + wsptTemp.getProfileTemplatePath() + " is a profile-augmenting template.");
            f_isValid = f_isValid && wsptTemp.isAugmentTemplate();
        }
        if (!f_isValid) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForCreation", "Prerequiste profile template " + wsptTemp.getProfileTemplatePath() + " cannot be used for creation.");
            throw new WSProfileException();
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "validateListForCreation");
    }

    public static void validateListForAugmentation(Vector v_wsptPrereqTemplates, Profile profileThis) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "validateListForAugmentation");
        boolean f_isValid = true;
        if (v_wsptPrereqTemplates.size() == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForAugmentation", "Validation successful. There are no augmentations that need to be performed.");
            LOGGER.exiting(PrereqTemplateUtils.class.getName(), "validateListForAugmentation");
            return;
        }
        WSProfileTemplate wsptTemp = (WSProfileTemplate)v_wsptPrereqTemplates.get(0);
        if (!wsptTemp.isAugmentTemplate() && !wsptTemp.equals(profileThis.getWSProfileTemplate())) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForAugmentation", "The prerequisite template " + wsptTemp.getProfileTemplatePath() + " failed validation. " + "It should be an augmenting template, or the template that was used " + "to create this profile.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY), ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY));
        }
        for (int i = N_ONE; i < v_wsptPrereqTemplates.size(); ++i) {
            wsptTemp = (WSProfileTemplate)v_wsptPrereqTemplates.get(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForAugmentation", "Evaluating if " + wsptTemp + " is a profile-augmenting template.");
            boolean bl = f_isValid = f_isValid && wsptTemp.isAugmentTemplate();
            if (f_isValid) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForAugmentation", "Prerequiste profile templates " + wsptTemp.getProfileTemplatePath() + " cannot be used for augmentation.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY), ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY));
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "validateListForAugmentation");
    }

    public static boolean isValidTemplateForUnaugmentation(String sProfileName, File fileTemplatePath) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "isValidTemplateForUnaugmentation");
        Vector v_augmentors = (Vector)WSProfile.getProfile(sProfileName).getAugmentationTemplates();
        WSProfileTemplate wsTemplateToUnaugment = new WSProfileTemplate(fileTemplatePath);
        if (!v_augmentors.contains(wsTemplateToUnaugment)) {
            LOGGER.exiting(PrereqTemplateUtils.class.getName(), "isValidTemplateForUnaugmentation");
            return true;
        }
        for (int i = 0; i < v_augmentors.size(); ++i) {
            WSProfileTemplate wsCurrTemplate = (WSProfileTemplate)v_augmentors.get(i);
            if (wsCurrTemplate.getPrereqTemplatePath() == null || wsCurrTemplate.equals(wsTemplateToUnaugment) || !new WSProfileTemplate(wsCurrTemplate.getPrereqTemplatePath()).equals(wsTemplateToUnaugment)) continue;
            LOGGER.exiting(PrereqTemplateUtils.class.getName(), "isValidTemplateForUnaugmentation");
            return false;
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "isValidTemplateForUnaugmentation");
        return true;
    }

    public static List getListOfDependantTemplates(String sProfileName, WSProfileTemplate templateToUnaugment) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getListStackOfUnaugments");
        Vector listOfAllAugments = (Vector)WSProfile.getAllAugmentationProfileTemplates(sProfileName);
        Vector<WSProfileTemplate> listOfAllAugmentsAboveGivenTemplate = new Vector<WSProfileTemplate>();
        if (!listOfAllAugments.contains(templateToUnaugment)) {
            LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getListStackOfUnaugments");
            return new Vector();
        }
        listOfAllAugmentsAboveGivenTemplate.add(templateToUnaugment);
        for (int i = 0; i < listOfAllAugments.size(); ++i) {
            WSProfileTemplate wsCurrTemplate = (WSProfileTemplate)listOfAllAugments.get(i);
            if (wsCurrTemplate.getPrereqTemplatePath() == null || !listOfAllAugmentsAboveGivenTemplate.contains(new WSProfileTemplate(wsCurrTemplate.getPrereqTemplatePath()))) continue;
            listOfAllAugmentsAboveGivenTemplate.add(wsCurrTemplate);
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getListStackOfUnaugments");
        return listOfAllAugmentsAboveGivenTemplate;
    }

    public static List getAugumentedTemplates(String sProfileName) throws WSProfileException {
        Vector<File> listAugmentsTemplates = new Vector<File>();
        Profile currProfile = WSProfile.getProfile(sProfileName);
        List<WSProfileTemplate> listAugments = currProfile.getAugmentationTemplates();
        for (int i = 0; i < listAugments.size(); ++i) {
            listAugmentsTemplates.add(listAugments.get(i).getProfileTemplatePath());
        }
        return listAugmentsTemplates;
    }

    public static int getTotalTemplateSizeForStackCreation(File fileTemplatePath) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackCreation");
        int iSize = 0;
        Vector v_wsptTemplatesForStackCreation = (Vector)PrereqTemplateUtils.getTemplatesForStackCreation(fileTemplatePath);
        for (int i = 0; i < v_wsptTemplatesForStackCreation.size(); ++i) {
            iSize += ((WSProfileTemplate)v_wsptTemplatesForStackCreation.get(i)).getSize();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getTotalTemplateSizeForStackCreation", "The size of the template including prerequisite templates is: " + iSize + " Megabytes");
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackCreation");
        return iSize;
    }

    public static int getTotalTemplateSizeForStackAugmentation(File fileTemplatePath, String sProfileName) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackAugmentation");
        int iSize = 0;
        Profile profileActiveProfile = WSProfile.getProfile(sProfileName);
        Vector v_wsptAugmentationTemplateStack = (Vector)PrereqTemplateUtils.getTemplatesForStackAugmentation(fileTemplatePath, profileActiveProfile);
        for (int i = 0; i < v_wsptAugmentationTemplateStack.size(); ++i) {
            iSize += ((WSProfileTemplate)v_wsptAugmentationTemplateStack.get(i)).getSize();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getTotalTemplateSizeForStackAugmentation", "The size of the template including prerequisite templates is: " + iSize + " Megabytes");
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackAugmentation");
        return iSize;
    }

    private static List<List<WSProfileTemplate>> getPrereqPaths(WSProfileTemplate wspt) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "getPrereqPaths");
        Vector<WSProfileTemplate> lwsptTemplateStack = new Vector<WSProfileTemplate>();
        lwsptTemplateStack.add(wspt);
        LOGGER.exiting(S_CLASS_NAME, "getPrereqPaths");
        return PrereqTemplateUtils.getPrereqPaths(lwsptTemplateStack);
    }

    private static List<List<WSProfileTemplate>> getPrereqPaths(List<WSProfileTemplate> l_wspt) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "getPrereqPaths");
        Vector<GenericExpressionTree> v_completeTrees = new Vector<GenericExpressionTree>();
        for (int i = 0; i < l_wspt.size(); ++i) {
            WSProfileTemplateExpressionTree wspt_expTree;
            WSProfileTemplate wspt_current = l_wspt.get(i);
            GenericExpressionTree expTree = wspt_current.getCompletePrereqTree();
            if (expTree != null) {
                expTree = PrereqTreeUtils.convertToDNF(expTree);
                wspt_expTree = new WSProfileTemplateExpressionTree(null, null);
                wspt_expTree.setData(new WSProfileTemplatePrereqData(wspt_current.getProfileTemplatePath(), new Vector<WSProfileDisabledAction>()));
                OperatorExpressionTree opt_expTree = (OperatorExpressionTree)PrereqTreeUtils.getANDNode();
                opt_expTree.setLeftChild(expTree);
                expTree.setParent(opt_expTree);
                opt_expTree.setRightChild(wspt_expTree);
                wspt_expTree.setParent(opt_expTree);
                opt_expTree = (OperatorExpressionTree)PrereqTreeUtils.convertToDNF(opt_expTree);
                v_completeTrees.add(opt_expTree);
                continue;
            }
            wspt_expTree = new WSProfileTemplateExpressionTree(null, null);
            wspt_expTree.setData(wspt_current.getProfileTemplatePath());
            v_completeTrees.add(wspt_expTree);
        }
        GenericExpressionTree expTree_final = null;
        if (v_completeTrees.size() == 1) {
            expTree_final = (GenericExpressionTree)v_completeTrees.get(0);
        } else {
            expTree_final = PrereqTreeUtils.getANDNode();
            OperatorExpressionTree current_ANDTree = (OperatorExpressionTree)expTree_final;
            for (int i = v_completeTrees.size() - 1; i >= 0; --i) {
                GenericExpressionTree current_expTree = (GenericExpressionTree)v_completeTrees.get(i);
                if (i >= 1) {
                    current_ANDTree.setRightChild(current_expTree);
                    current_expTree.setParent(current_ANDTree);
                    if (i <= 1) continue;
                    OperatorExpressionTree temp_ANDTree = (OperatorExpressionTree)PrereqTreeUtils.getANDNode();
                    current_ANDTree.setLeftChild(temp_ANDTree);
                    temp_ANDTree.setParent(current_ANDTree);
                    current_ANDTree = temp_ANDTree;
                    continue;
                }
                current_ANDTree.setLeftChild(current_expTree);
                current_expTree.setParent(current_ANDTree);
            }
        }
        expTree_final = PrereqTreeUtils.convertToDNF(expTree_final);
        Vector v_expObj = (Vector)PrereqTreeUtils.getExpressionsFromExpressionTree(expTree_final);
        LOGGER.exiting(S_CLASS_NAME, "getPrereqPaths");
        return PrereqTemplateUtils.convertVectorWSProfileTemplateExpressionToWSProfileTemplate(v_expObj);
    }

    private static List<List<WSProfileTemplate>> convertVectorWSProfileTemplateExpressionToWSProfileTemplate(List<List<WSProfileTemplateExpressionTree>> v_current) throws WSProfileException {
        Vector<List<WSProfileTemplate>> v_return = new Vector<List<WSProfileTemplate>>();
        for (int i = 0; i < v_current.size(); ++i) {
            Vector v_treeExp = (Vector)v_current.get(i);
            Vector<WSProfileTemplate> v_new = new Vector<WSProfileTemplate>();
            for (int j = 0; j < v_treeExp.size(); ++j) {
                v_new.add(new WSProfileTemplate(((WSProfileTemplateExpressionTree)v_treeExp.get(j)).getData()));
            }
            v_return.add(v_new);
        }
        return v_return;
    }

    private static Vector<WSProfileTemplate> removeExistingPrereqsForAugment(Vector<WSProfileTemplate> v_wsptAugmentPrereqTemplates, Profile profileThis) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "removeExistingPrereqsForAugment");
        Vector v_wsptExistingTemplates = (Vector)profileThis.getAugmentationTemplates();
        v_wsptExistingTemplates.add(0, profileThis.getWSProfileTemplate());
        int[] nIndexes = new int[v_wsptAugmentPrereqTemplates.size()];
        for (int i = N_ZERO; i < v_wsptAugmentPrereqTemplates.size(); ++i) {
            nIndexes[i] = v_wsptExistingTemplates.indexOf(v_wsptAugmentPrereqTemplates.get(i));
        }
        int n_pointer = nIndexes.length;
        int j = nIndexes.length - 1;
        while (j >= 0 && nIndexes[j] == N_NEGATIVE_ONE) {
            n_pointer = j--;
        }
        int nLargest = 0;
        for (int k = 0; k < n_pointer; ++k) {
            if (nIndexes[k] < nLargest) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "removeExistingPrereqsForAugment", "The registered profile template augmentor stacka is not valid.");
                throw new WSProfileException("invalid registered augmentor stack!", "invalid registered augmentor stack!");
            }
            nLargest = nIndexes[k];
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "removeExistingPrereqsForAugment");
        return new Vector<WSProfileTemplate>(v_wsptAugmentPrereqTemplates.subList(n_pointer, nIndexes.length));
    }
}

