/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.CurrentEnvironment;
import com.ibm.ws.management.util.PortConflictResolverException;
import com.ibm.ws.management.util.PortConflictResolverNoTrace;
import com.ibm.ws.profile.utils.FreePortDetector;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortResolutionUtils {
    private static final String S_CONFIG = "config";
    private static final String S_EMPTY = "";
    public static final int nMAX_PORT_VALUE = 65535;
    private static final String S_INVALID_NUMER_EXCEPTION = "WSProfile.PortResolutionUtils.invalidnumber";
    private static final String S_UNABLE_TO_RECOMMEND_PORT = "WSProfile.PortResolutionUtils.unableToRecommend";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortResolutionUtils.class);
    private static final String S_CLASS_NAME = PortResolutionUtils.class.getName();

    public static Hashtable recommendPorts(String[] asPortNames, int iStartingPort) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.recommendPorts(asPortNames, iStartingPort, new File(S_EMPTY));
    }

    public static Hashtable recommendPorts(String[] asPortNames, int iStartingPort, File sWASRegistry) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        if (CurrentEnvironment.isRemoteDisconnected()) {
            return PortResolutionUtils.recommendEmptyPorts(asPortNames);
        }
        Hashtable<String, Integer> hKeyValuePairs = new Hashtable<String, Integer>();
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry);
        int seed = iStartingPort;
        for (int j = 0; j < asPortNames.length; ++j) {
            String aKey = asPortNames[j];
            int aValue = PortResolutionUtils.resolvePort(seed, resolver);
            ++seed;
            hKeyValuePairs.put(aKey, aValue);
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hKeyValuePairs;
    }

    public static Hashtable recommendPorts(String[] asPortNames, int iStartingPort, File sWASRegistry, int[] iaReservedPorts) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        if (CurrentEnvironment.isRemoteDisconnected()) {
            return PortResolutionUtils.recommendEmptyPorts(asPortNames);
        }
        Hashtable<String, Integer> hKeyValuePairs = new Hashtable<String, Integer>();
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry, iaReservedPorts);
        int seed = iStartingPort;
        for (int j = 0; j < asPortNames.length; ++j) {
            String aKey = asPortNames[j];
            int aValue = PortResolutionUtils.resolvePort(seed, resolver);
            ++seed;
            hKeyValuePairs.put(aKey, aValue);
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hKeyValuePairs;
    }

    public static Hashtable recommendPorts(String[] asPortNames, int[] aiDefaultPorts) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.recommendPorts(asPortNames, aiDefaultPorts, new File(S_EMPTY));
    }

    public static Hashtable recommendPorts(String[] asPortNames, int[] aiDefaultPorts, File sWASRegistry) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        if (CurrentEnvironment.isRemoteDisconnected()) {
            return PortResolutionUtils.recommendEmptyPorts(asPortNames);
        }
        Hashtable<String, Integer> hKeyValuePairs = new Hashtable<String, Integer>();
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry);
        for (int j = 0; j < asPortNames.length; ++j) {
            String aKey = asPortNames[j];
            int aValue = PortResolutionUtils.resolvePort(aiDefaultPorts[j], resolver);
            hKeyValuePairs.put(aKey, aValue);
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hKeyValuePairs;
    }

    public static Properties recommendPorts(Properties propPorts, File sWASRegistry) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry);
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.resolvePorts(propPorts, resolver);
    }

    public static Properties recommendPorts(Properties propPorts, File sWASRegistry, int[] iaReservedPorts) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        if (CurrentEnvironment.isRemoteDisconnected()) {
            return PortResolutionUtils.recommendEmptyPorts(propPorts);
        }
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry, iaReservedPorts);
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.resolvePorts(propPorts, resolver);
    }

    public static Hashtable recommendPorts(Properties[] apropPorts, String[] saKeys, File sWASRegistry) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.recommendPorts(apropPorts, saKeys, sWASRegistry, new int[0]);
    }

    public static Hashtable recommendPorts(Properties[] apropPorts, String[] saKeys, File sWASRegistry, int[] iaReservedPorts) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry, iaReservedPorts);
        Hashtable<String, Properties> hashtableRecommendedPortProps = new Hashtable<String, Properties>(apropPorts.length);
        for (int i = 0; i < apropPorts.length; ++i) {
            hashtableRecommendedPortProps.put(saKeys[i], PortResolutionUtils.resolvePorts(apropPorts[i], resolver));
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hashtableRecommendedPortProps;
    }

    private static Hashtable<String, Integer> recommendEmptyPorts(String[] asPortNames) {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendEmptyPorts");
        Hashtable<String, Integer> hKeyValuePairs = new Hashtable<String, Integer>();
        for (int j = 0; j < asPortNames.length; ++j) {
            String aKey = asPortNames[j];
            hKeyValuePairs.put(aKey, 0);
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendEmptyPorts");
        return hKeyValuePairs;
    }

    private static Properties recommendEmptyPorts(Properties propPorts) {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendEmptyPorts");
        Enumeration<Object> enumPortKeys = propPorts.keys();
        while (enumPortKeys.hasMoreElements()) {
            String sPortKey = (String)enumPortKeys.nextElement();
            propPorts.put(sPortKey, S_EMPTY);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "recommendEmptyPorts", "Recommended Port=[" + sPortKey + "] recommended value=[" + S_EMPTY + "]");
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendEmptyPorts");
        return propPorts;
    }

    public static Properties determineBasePorts(String sTemplatePath) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineBasePorts");
        Hashtable hashtablePorts = PortResolutionUtils.determineBasePorts(sTemplatePath, new String[]{"portdef.props"});
        return (Properties)hashtablePorts.get("portdef.props");
    }

    public static Hashtable determineBasePorts(String sTemplatePath, String[] asSeedPortsFiles) throws WSProfileException {
        return PortResolutionUtils.determineBasePorts(sTemplatePath, asSeedPortsFiles, "create", S_EMPTY);
    }

    public static Hashtable determineBasePorts(String sTemplatePath, String[] asSeedPortsFiles, String sMode, String sProfileName) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineBasePorts");
        Hashtable<String, Properties> hashtableBasePorts = new Hashtable<String, Properties>(asSeedPortsFiles.length);
        List<WSProfileTemplate> l_wsptTemplates = PrereqTemplateUtils.getListOfTemplatePathsForMode(sMode, sProfileName, sTemplatePath);
        for (int i = 0; i < asSeedPortsFiles.length; ++i) {
            for (int j = 0; j < l_wsptTemplates.size(); ++j) {
                File fileTemplatePath = l_wsptTemplates.get(j).getProfileTemplatePath();
                File filePortsFiles = new File(fileTemplatePath, "actions/portsUpdate" + File.separator + asSeedPortsFiles[i]);
                FileInputStream fis = null;
                if (!filePortsFiles.exists()) continue;
                try {
                    fis = new FileInputStream(filePortsFiles);
                    Properties propBasePorts = new Properties();
                    propBasePorts.load(fis);
                    if (hashtableBasePorts.containsKey(asSeedPortsFiles[i])) {
                        ((Properties)hashtableBasePorts.get(asSeedPortsFiles[i])).putAll((Map<?, ?>)propBasePorts);
                        continue;
                    }
                    hashtableBasePorts.put(asSeedPortsFiles[i], propBasePorts);
                    continue;
                }
                catch (FileNotFoundException e) {
                    LogUtils.logException(LOGGER, e);
                    throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
                }
                catch (IOException e) {
                    LogUtils.logException(LOGGER, e);
                    throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        LogUtils.logException(LOGGER, e);
                        throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
                    }
                }
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineBasePorts");
        return hashtableBasePorts;
    }

    public static Properties determineRecommendedPorts(String sTemplatePath) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        Properties propTemplatePortDef = PortResolutionUtils.determineBasePorts(sTemplatePath);
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.recommendPorts(propTemplatePortDef, new File(S_EMPTY));
    }

    public static Hashtable determineRecommendedPorts(String sTemplatePath, String[] asSeedPortsFiles, int[] iaReservedPorts) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.determineRecommendedPorts(sTemplatePath, asSeedPortsFiles, iaReservedPorts, "create", S_EMPTY);
    }

    public static Hashtable determineRecommendedPorts(String sTemplatePath, String[] asSeedPortsFiles) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.determineRecommendedPorts(sTemplatePath, asSeedPortsFiles, new int[0]);
    }

    public static Hashtable determineRecommendedPorts(String sTemplatePath, String[] asSeedPortsFiles, int[] iaReservedPorts, String sMode, String sProfileName) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        Properties[] apropPorts = new Properties[asSeedPortsFiles.length];
        List<WSProfileTemplate> l_wsptTemplates = PrereqTemplateUtils.getListOfTemplatePathsForMode(sMode, sProfileName, sTemplatePath);
        for (int i = 0; i < asSeedPortsFiles.length; ++i) {
            for (int j = 0; j < l_wsptTemplates.size(); ++j) {
                File fileTemplatePath = l_wsptTemplates.get(j).getProfileTemplatePath();
                File filePortsFiles = new File(fileTemplatePath, "actions/portsUpdate" + File.separator + asSeedPortsFiles[i]);
                FileInputStream fis = null;
                if (!filePortsFiles.exists()) continue;
                if (apropPorts[i] == null) {
                    apropPorts[i] = new Properties();
                }
                Properties propLoadedProperties = new Properties();
                try {
                    fis = new FileInputStream(filePortsFiles);
                    propLoadedProperties.load(fis);
                }
                catch (FileNotFoundException e) {
                    LogUtils.logException(LOGGER, e);
                    throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
                }
                catch (IOException e) {
                    LogUtils.logException(LOGGER, e);
                    throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        LogUtils.logException(LOGGER, e);
                        throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
                    }
                }
                apropPorts[i].putAll((Map<?, ?>)propLoadedProperties);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineRecommendedPorts", "Added property file for i=" + i);
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.recommendPorts(apropPorts, asSeedPortsFiles, new File(S_EMPTY), iaReservedPorts);
    }

    public static boolean validatePorts(Properties propPorts) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePorts");
        return PortResolutionUtils.validatePorts(propPorts, new File(S_EMPTY));
    }

    public static boolean validatePorts(Properties propPorts, File sWASRegistry) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePorts");
        if (CurrentEnvironment.isRemoteDisconnected()) {
            return PortResolutionUtils.validateNoDuplicatePorts(propPorts);
        }
        boolean fArePortsFree = true;
        Enumeration<Object> enumPortKeys = propPorts.keys();
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(sWASRegistry);
        while (enumPortKeys.hasMoreElements()) {
            String sPortKey = (String)enumPortKeys.nextElement();
            int iOrigPortValue = Integer.parseInt((String)propPorts.get(sPortKey));
            fArePortsFree = resolver.reservePort(iOrigPortValue);
            fArePortsFree = fArePortsFree && FreePortDetector.isPortFree(iOrigPortValue);
            if (fArePortsFree) continue;
            fArePortsFree = false;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validatePorts", "Port [" + iOrigPortValue + "] assigned to " + sPortKey + " is not free.");
            break;
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePorts");
        return fArePortsFree;
    }

    private static boolean validateNoDuplicatePorts(Properties propPorts) {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validateNoDuplicatePorts");
        Enumeration<Object> enumPortKeys = propPorts.keys();
        ArrayList<String> ports = new ArrayList<String>();
        while (enumPortKeys.hasMoreElements()) {
            String sPortKey = (String)enumPortKeys.nextElement();
            String sPortValue = (String)propPorts.get(sPortKey);
            if (!ports.contains(sPortValue)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "validatePorts", "Port [" + sPortValue + "] assigned to " + sPortKey + " is not free.");
                return false;
            }
            if (sPortValue.equals(S_EMPTY)) continue;
            ports.add(sPortValue);
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validateNoDuplicatePorts");
        return true;
    }

    public static boolean validatePort(int iPortValue, File fileWasRegistry) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePort");
        if (CurrentEnvironment.isRemoteDisconnected()) {
            return true;
        }
        boolean fIsPortFree = true;
        PortConflictResolverNoTrace resolver = PortResolutionUtils.createPortConflictResolver(fileWasRegistry);
        fIsPortFree = resolver.reservePort(iPortValue);
        boolean bl = fIsPortFree = fIsPortFree && FreePortDetector.isPortFree(iPortValue);
        if (!fIsPortFree) {
            fIsPortFree = false;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validatePort", "Port [" + iPortValue + "] is not free.");
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePort");
        return fIsPortFree;
    }

    public static boolean validatePort(int iPortValue) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePort");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePort");
        return PortResolutionUtils.validatePort(iPortValue, new File(S_EMPTY));
    }

    private static Properties resolvePorts(Properties propPorts, PortConflictResolverNoTrace resolver) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "resolvePorts");
        Enumeration<Object> enumPortKeys = propPorts.keys();
        while (enumPortKeys.hasMoreElements()) {
            String sPortKey = (String)enumPortKeys.nextElement();
            int iBasePortValue = Integer.parseInt((String)propPorts.get(sPortKey));
            if (CurrentEnvironment.isRemoteDisconnected()) {
                propPorts.put(sPortKey, "0");
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "resolvePorts", "Recommended Port=[" + sPortKey + "] base value=[" + iBasePortValue + "]" + "] recommended value=[" + "1111" + "]");
                continue;
            }
            int iRecommendedPortValue = PortResolutionUtils.resolvePort(iBasePortValue, resolver);
            propPorts.put(sPortKey, new Integer(iRecommendedPortValue).toString());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "resolvePorts", "Recommended Port=[" + sPortKey + "] base value=[" + iBasePortValue + "]" + "] recommended value=[" + iRecommendedPortValue + "]");
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "resolvePorts");
        return propPorts;
    }

    private static int resolvePort(int iSeedPortValue, PortConflictResolverNoTrace resolver) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "resolvePort");
        if (iSeedPortValue > 65535 || iSeedPortValue < 0) {
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_NUMER_EXCEPTION));
        }
        int iRecommendedPort = resolver.getPort(iSeedPortValue);
        LOGGER.logp(Level.FINEST, S_CLASS_NAME, "resolvePort", "Initially recommending port=" + iRecommendedPort + " for seed value= " + iSeedPortValue);
        if (!FreePortDetector.isPortFree(iRecommendedPort)) {
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "resolvePort", "Port=" + iRecommendedPort + " is not free, looking for next available port");
            while (!FreePortDetector.isPortFree(iRecommendedPort) || !resolver.reservePort(iRecommendedPort)) {
                LOGGER.logp(Level.FINEST, S_CLASS_NAME, "resolvePort", "Port=" + iRecommendedPort + " is not free or available, looking for next available port");
                if (++iRecommendedPort <= 65535 && iRecommendedPort >= 0) continue;
                Exception throwablePortError = FreePortDetector.getLastError();
                if (throwablePortError != null) {
                    LogUtils.logException(LOGGER, throwablePortError);
                }
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_UNABLE_TO_RECOMMEND_PORT));
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "resolvePort");
        return iRecommendedPort;
    }

    private static PortConflictResolverNoTrace createPortConflictResolver(File sWASRegistryLocation) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "createPortConflictResolver");
        String[] allWASHomes = PortResolutionUtils.getAllWASLocations(sWASRegistryLocation);
        Vector<String> container2 = new Vector<String>();
        for (int i = 0; allWASHomes != null && i < allWASHomes.length; ++i) {
            container2 = PortResolutionUtils.getAllConfigLocations(container2, allWASHomes[i]);
        }
        String[] asConfigRoots = container2.toArray(new String[0]);
        try {
            LOGGER.exiting(PortResolutionUtils.class.getName(), "createPortConflictResolver");
            PortConflictResolverNoTrace pr = new PortConflictResolverNoTrace(asConfigRoots);
            PortResolutionUtils.documentAnyInaccessibleFiles(pr);
            return pr;
        }
        catch (PortConflictResolverException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    private static PortConflictResolverNoTrace createPortConflictResolver(File sWASRegistryLocation, int[] reservedPorts) throws WSProfileException {
        PortConflictResolverNoTrace resolver;
        LOGGER.entering(PortResolutionUtils.class.getName(), "createPortConflictResolver(File, int[])");
        String[] allWASHomes = PortResolutionUtils.getAllWASLocations(sWASRegistryLocation);
        Vector<String> container2 = new Vector<String>();
        for (int i = 0; allWASHomes != null && i < allWASHomes.length; ++i) {
            container2 = PortResolutionUtils.getAllConfigLocations(container2, allWASHomes[i]);
        }
        String[] asConfigRoots = container2.toArray(new String[0]);
        try {
            LOGGER.exiting(PortResolutionUtils.class.getName(), "createPortConflictResolver(File, int[])");
            resolver = new PortConflictResolverNoTrace(asConfigRoots);
            PortResolutionUtils.documentAnyInaccessibleFiles(resolver);
        }
        catch (PortConflictResolverException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        for (int i = 0; i < reservedPorts.length; ++i) {
            resolver.reservePort(reservedPorts[i]);
        }
        return resolver;
    }

    private static void documentAnyInaccessibleFiles(PortConflictResolverNoTrace resolver) {
        Vector v = resolver.getInaccessibleFiles();
        if (v != null && v.size() > 0) {
            String s = S_EMPTY;
            for (int i = 0; i < v.size(); ++i) {
                s = s + (String)v.elementAt(i) + ";";
            }
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createPortConflictResolver(File, int[])", "Recommended ports may be suspect - unable to access: " + s);
        }
    }

    private static String[] getAllWASLocations(File fileWASRegistryFile) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "getAllWASLocations");
        WASSystem aSys = null;
        try {
            aSys = fileWASRegistryFile == null || fileWASRegistryFile.equals(new File(S_EMPTY)) ? WASSystem.getWASSystemInstance() : WASSystem.getWASSystemInstance(fileWASRegistryFile.getAbsolutePath());
            String[] asWasLocations = aSys.getWASLocations();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllWASLocations", "Located the following WAS homes:" + StringUtils.convertStringArrayToCommaSeparatedString(asWasLocations));
            LOGGER.exiting(PortResolutionUtils.class.getName(), "getAllWASLocations");
            return asWasLocations;
        }
        catch (Throwable t) {
            LogUtils.logException(LOGGER, t);
            throw new WSProfileException(t.getMessage(), t.getLocalizedMessage());
        }
    }

    private static Vector<String> getAllConfigLocations(Vector<String> container2, String sWASHome) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), S_EMPTY);
        if (sWASHome == null) {
            return container2;
        }
        if (container2 == null) {
            container2 = new Vector();
        }
        try {
            if (WSProfile.isWasprofilePropertiesAvailable(sWASHome)) {
                File registryFile = WSProfile.getRegistryFile(sWASHome);
                if (registryFile != null && registryFile.exists()) {
                    List profileList = WSProfile.getProfileList(registryFile);
                    for (Profile profile : profileList) {
                        String profileHome = profile.getPath().getAbsolutePath();
                        String configRoot = PortResolutionUtils.getConfigRootFromProfileHome(profileHome);
                        if (configRoot == null) continue;
                        container2.addElement(configRoot);
                    }
                }
            } else {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getAllConfigLocations", "wasprofile.properties unavailable for WAS_HOME [" + sWASHome + "].  The ports from the profiles under this WAS_HOME cannot be detected.");
            }
        }
        catch (Throwable t) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getAllConfigLocations", "The install located at " + sWASHome + " is corrupt so all reserved ports in this install may be used.");
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getAllConfigLocations", "All current config homes: " + container2);
        LOGGER.exiting(PortResolutionUtils.class.getName(), S_EMPTY);
        return container2;
    }

    private static String getConfigRootFromProfileHome(String sProfileHome) {
        LOGGER.entering(PortResolutionUtils.class.getName(), "getConfigRootFromProfileHome");
        String configRoot = null;
        File configFile = new File(sProfileHome + File.separator + S_CONFIG);
        if (configFile.exists() && configFile.isDirectory()) {
            try {
                configRoot = configFile.getCanonicalPath();
            }
            catch (IOException e) {
                LogUtils.logException(LOGGER, e);
                configRoot = null;
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "getConfigRootFromProfileHome");
        return configRoot;
    }
}

