/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.profile.utils.FileLockerException;
import java.io.File;
import java.io.IOException;

public class FileLocker {
    private String m_sLockFilePath = null;
    private String m_sLockFileDirectory = null;
    private static final String S_LOCK = "_LOCK";
    private static final String S_FILE_PERMISSION_DENIED = "This userid has not been granted full read/write permissions for the directory: ";
    private static final String S_PERMISSION_DENIED = "Permission denied";

    public FileLocker(File fileToLock) throws IOException {
        this.m_sLockFileDirectory = fileToLock.getParentFile().getAbsolutePath();
        this.m_sLockFilePath = fileToLock.getCanonicalPath() + S_LOCK;
    }

    public FileLocker(String fileToLock) throws IOException {
        this(new File(fileToLock));
    }

    public void acquireFileLock() throws FileLockerException, IOException {
        this.acquireFileLock(0L, 1);
    }

    public void acquireFileLock(long retryInterval, int retryCount) throws FileLockerException, IOException {
        File fileLock = new File(this.m_sLockFilePath);
        for (int i = 0; i < retryCount; ++i) {
            block6: {
                try {
                    if (!fileLock.exists() && fileLock.createNewFile()) {
                        return;
                    }
                }
                catch (IOException ioEx) {
                    if (!ioEx.getMessage().equals(S_PERMISSION_DENIED)) break block6;
                    throw new IOException(S_FILE_PERMISSION_DENIED + this.m_sLockFileDirectory);
                }
            }
            if (i >= retryCount - 1) continue;
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        throw new FileLockerException(fileLock);
    }

    public void releaseFileLock() throws FileLockerException {
        File fileLock = new File(this.m_sLockFilePath);
        if (!fileLock.delete()) {
            throw new FileLockerException(fileLock);
        }
    }

    public String getLockFilePath() {
        return this.m_sLockFilePath;
    }
}

