/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IsDefaultValidationPreProcessorTask
extends WSProfileProcessorTask {
    private static final String S_TRUE = "true";
    private static final String S_FALSE = "false";
    private static final String S_INVALID_IS_DEFAULT_ARG_KEY = "WSProfile.WSProfile.invalidIsDefaultArgument";
    private static final Logger LOGGER = LoggerFactory.createLogger(IsDefaultValidationPreProcessorTask.class);
    private static final String S_CLASS_NAME = IsDefaultValidationPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        Map<String, List> mFlowControllingArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        List vIsDefaultArgs = mFlowControllingArgs.get("isDefault");
        if (vIsDefaultArgs != null && vIsDefaultArgs.size() > 0) {
            String sIsDefaultArg = (String)vIsDefaultArgs.get(0);
            if (vIsDefaultArgs.size() > 1 || !sIsDefaultArg.equalsIgnoreCase(S_TRUE) && !sIsDefaultArg.equalsIgnoreCase(S_FALSE)) {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_INVALID_IS_DEFAULT_ARG_KEY));
                LOGGER.exiting(S_CLASS_NAME, "runProcessor");
                return false;
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        boolean result = false;
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getFlowControllingModeInvoker();
        Map<String, List> mapFlowControllingArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        if (wspclimiFlowControlling != null && mapFlowControllingArgs != null && WSProfileDataStore.isArgSpecified("isDefault") && (wspclimiFlowControlling.isArgumentRequired("isDefault") || wspclimiFlowControlling.isArgumentOptional("isDefault"))) {
            result = true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + result);
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return result;
    }
}

