/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecuteModeHelpPreProcessorTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(ExecuteModeHelpPreProcessorTask.class);
    private static String S_CLASS_NAME = ExecuteModeHelpPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        boolean fCompleteCommand = true;
        Map<String, List> mSpecifiedArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        WSProfileDataStore.setHelpRequestedFlag(true);
        OutputStreamHandler.init();
        if (mSpecifiedArgs.get("help") != null) {
            WSProfileCLIModeInvoker.doHelpMode(WSProfileDataStore.getFlowControllingArgsAsArray());
            fCompleteCommand = true;
        } else {
            WSProfileCLIModeInvoker.doHelpMode(new String[0]);
            fCompleteCommand = false;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runProcessor", "Incoming command line is invalid. It may be missing some arguments.");
        }
        Vector list = (Vector)OutputStreamHandler.getOutput().get("message");
        WSProfileDataStore.setHelpMessages(new Vector<String>(list));
        OutputStreamHandler.init();
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return fCompleteCommand;
    }

    public boolean checkPostconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPostconditions");
        List<String> lsHelpMessages = WSProfileDataStore.getHelpMessages();
        if (lsHelpMessages.size() <= 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPostconditions", "checkPostconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPostconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPostconditions", "checkPostconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPostconditions");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        if (WSProfileDataStore.getFlowControllingModeInvoker() != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return false;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        Hashtable htFlowControllingArgs = (Hashtable)WSProfileDataStore.getFlowControllingArgsAsMap();
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileCLIModeInvoker.getModeInvoker(WSProfileDataStore.getFlowControllingArgsAsArray());
        if (htFlowControllingArgs.get("help") != null || wspclimiFlowControlling.getModeFlag().equals("help") || htFlowControllingArgs.size() == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = true");
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }
}

