/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.datastore.WSProfileJobGroupData;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.WSProfileCLIModeInvokerUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompleteDefaultingPreProcessorTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(CompleteDefaultingPreProcessorTask.class);
    private static String S_CLASS_NAME = CompleteDefaultingPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileJobGroupData wspjgdForExecution = WSProfileDataStore.getJobGroup(i);
            Map<String, List> mSpecifiedArgs = wspjgdForExecution.getCurrentArgsAsMap();
            WSProfileCLIModeInvoker wspclimiForExecution = wspjgdForExecution.getCurrentModeInvoker();
            List<WSProfileTemplate> lwsptTemplateStack = wspjgdForExecution.getTemplateStack();
            String sRegistryFilePath = lwsptTemplateStack.get(lwsptTemplateStack.size() - 1).getProfileTemplatePath().getAbsolutePath() + File.separator + wspclimiForExecution.getRegistryName();
            List<String> lsArgsNeedingDefaulting = WSProfileCLIModeInvokerUtils.findArgumentsNeedingDefaults(wspclimiForExecution, mSpecifiedArgs, lwsptTemplateStack);
            if (lsArgsNeedingDefaulting != null && lsArgsNeedingDefaulting.size() > 0) {
                Properties currentProps = SystemPropertiesUtils.getCurrentSystemProperties();
                System.setProperty("WS_CMT_ACTION_REGISTRY", sRegistryFilePath);
                SystemPropertiesUtils.setTemplateStackIntoSystemProperties(lwsptTemplateStack);
                Hashtable htDefaultedValues = DefaultValueManagerUtils.getDefaultValues(wspclimiForExecution.getModeFlag(), lsArgsNeedingDefaulting.toArray(new String[lsArgsNeedingDefaulting.size()]), mSpecifiedArgs, lwsptTemplateStack);
                SystemPropertiesUtils.resetSystemProperties(currentProps);
                for (int j = 0; j < lsArgsNeedingDefaulting.size(); ++j) {
                    String sDefaultedValue = (String)htDefaultedValues.get(lsArgsNeedingDefaulting.get(j));
                    if (sDefaultedValue == null) continue;
                    Vector<String> vsDefaultedValue = new Vector<String>();
                    vsDefaultedValue.add(sDefaultedValue);
                    mSpecifiedArgs.put(lsArgsNeedingDefaulting.get(j), vsDefaultedValue);
                }
            }
            wspjgdForExecution.setCurrentArgs(mSpecifiedArgs);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runProcessor", "Complete args with defaults are for Job Group " + i + " are: " + LogUtils.getArrayAsALoggableString(StringUtils.hidePasswordArgs(wspjgdForExecution.getCurrentArgsAsArray())));
            DefaultValueManagerUtils.reinitialize();
        }
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
            List<WSProfileTemplate> lwsptTemplateStack = WSProfileDataStore.getJobGroup(i).getTemplateStack();
            if (wspclimiForExecution != null && mSpecifiedArgs != null && mSpecifiedArgs.size() > 0 && lwsptTemplateStack != null && lwsptTemplateStack.size() > 0) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() <= 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            WSProfileCLIModeInvoker wspclimiForExecution = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            if (wspclimiForExecution == null || wspclimiForExecution.getRegistryName() == null || !wspclimiForExecution.isDefaultingAllowed()) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + !WSProfileDataStore.isHelpRequested());
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return !WSProfileDataStore.isHelpRequested();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }
}

