/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.defaulters.GenericDefaulter;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServerInstallPathDefaulter
extends GenericDefaulter {
    public final String S_WSPROFILE_DEFAULTERS_WEBSERVER_INSTALLPATH_KEY = "WSProfile.Defaulters.webserver.installpath.";
    private static final Logger LOGGER = LoggerFactory.createLogger(WebServerInstallPathDefaulter.class);
    private static final String S_CLASS_NAME = WebServerInstallPathDefaulter.class.getName();
    public final String[] SA_SERVER_TYPES_REQUIRING_VALUE = new String[]{"IHS"};
    public final String S_DEFAULT_PROGRAM_FILES_LOCATION = "C:\\Program Files";

    public boolean runDefaulter() {
        LOGGER.entering(WebServerInstallPathDefaulter.class.getName(), "runDefaulter");
        String sServer_os = System.getProperty("webServerOS");
        String sServer_type = System.getProperty("webServerType");
        if (sServer_os == null && sServer_type == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerOS") + "\n";
            this.sErrorMessage = this.sErrorMessage + MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerType");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerInstallPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        if (sServer_os == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerOS");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerInstallPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        if (sServer_type == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerType");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerInstallPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        this.sDefaultedValue = ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.webserver.installpath." + sServer_type + "." + sServer_os, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle");
        if (!this.validateResourceBundleReturn("WSProfile.Defaulters.webserver.installpath." + sServer_type + "." + sServer_os, this.sDefaultedValue)) {
            LOGGER.exiting(WebServerInstallPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        if (sServer_os.equals("windows")) {
            String sProgramFiles = WASUtilities.isWindows() ? WASUtilities.getEnvironmentVariable("ProgramFiles") : "C:\\Program Files";
            if (sProgramFiles == null || sProgramFiles.equals("")) {
                sProgramFiles = "C:\\Program Files";
            }
            this.sDefaultedValue = MessageFormat.format(this.sDefaultedValue, sProgramFiles);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        LOGGER.exiting(WebServerInstallPathDefaulter.class.getName(), "runDefaulter");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(WebServerInstallPathDefaulter.class.getName(), "doIRun");
        this.bDoIRun = true;
        String sWebServerCheck = System.getProperty("webServerCheck");
        String sWebServerType = System.getProperty("webServerType");
        if (sWebServerCheck == null || !sWebServerCheck.equals("true") || !this.defaultingServerType(sWebServerType)) {
            this.bDoIRun = false;
        }
        LOGGER.exiting(WebServerInstallPathDefaulter.class.getName(), "doIRun");
        return this.bDoIRun;
    }

    private boolean defaultingServerType(String sServerType) {
        for (int i = 0; i < this.SA_SERVER_TYPES_REQUIRING_VALUE.length; ++i) {
            if (!sServerType.equals(this.SA_SERVER_TYPES_REQUIRING_VALUE[i])) continue;
            return true;
        }
        return false;
    }
}

