/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.websphere.product.WASDirectory;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.wsspi.profile.defaulters.GenericDefaulter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticValueDefaulter
extends GenericDefaulter {
    private static final String S_STATIC_VALUE = "staticValue";
    private static final Logger LOGGER = LoggerFactory.createLogger(StaticValueDefaulter.class);
    private static final String S_CLASS_NAME = StaticValueDefaulter.class.getName();

    public boolean runDefaulter() {
        LOGGER.entering(S_CLASS_NAME, "runDefaulter");
        boolean fExecResult = true;
        String sStaticValue = null;
        String sWAS_HOME = SystemPropertiesUtils.getWasInstallLocation();
        if (sWAS_HOME != null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "sWAS_HOME=" + sWAS_HOME);
            WASDirectory wasDir = new WASDirectory(sWAS_HOME);
            if (wasDir != null) {
                if (wasDir.getName("EXPRESS") != null || wasDir.getName("BASE") != null || wasDir.getName("NDDMZ") != null) {
                    LOGGER.logp(Level.FINE, S_CLASS_NAME, "runDefaulter", "WAS Edition is EXPRESS, BASE, or NDDMZ");
                    sStaticValue = "ADMIN_AGENT";
                } else if (wasDir.getName("ND") != null) {
                    LOGGER.logp(Level.FINE, S_CLASS_NAME, "runDefaulter", "WAS Edition is ND");
                    sStaticValue = "DEPLOYMENT_MANAGER";
                }
            } else {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "wasDir is null");
            }
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "sWAS_HOME is null");
        }
        if (sStaticValue != null) {
            this.sDefaultedValue = sStaticValue;
        } else {
            fExecResult = false;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "The argument staticValue was specified incorrectly in the registry.");
        }
        LOGGER.exiting(S_CLASS_NAME, "runDefaulter");
        return fExecResult;
    }
}

