/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.wsspi.profile.defaulters.GenericDefaulter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatternizedValueDefaulter
extends GenericDefaulter {
    private static final String S_CONSOLE_SERVER_NAME_TAIL = "consoleserver";
    private static final Logger LOGGER = LoggerFactory.createLogger(PatternizedValueDefaulter.class);
    private static final String S_CLASS_NAME = PatternizedValueDefaulter.class.getName();

    public boolean runDefaulter() {
        LOGGER.entering(S_CLASS_NAME, "runDefaulter");
        boolean fExecResult = true;
        String sHostName = System.getProperty("hostName");
        if (sHostName == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "hostName was not set in the system properties, will use an empty string");
            sHostName = "";
            this.sDefaultedValue = S_CONSOLE_SERVER_NAME_TAIL;
        } else {
            sHostName = WASUtilities.getShortHostName(sHostName);
            this.sDefaultedValue = sHostName + "_" + S_CONSOLE_SERVER_NAME_TAIL;
        }
        LOGGER.exiting(S_CLASS_NAME, "runDefaulter");
        return fExecResult;
    }
}

