/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.datastore;

import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.WSProfileJob;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileJobGroupData;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.ProfilesCryptoI;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileDataStore {
    private static Hashtable<String, List> m_htIncomingArgs = new Hashtable();
    private static Hashtable<String, List> m_htArgsInResponseFile = new Hashtable();
    private static Hashtable<String, List> m_htValidationMessages = new Hashtable();
    private static Hashtable<String, String[]> m_htDisabledActions = new Hashtable();
    private static WSProfileCLIModeInvoker m_wspclimiIncoming = null;
    private static WSProfileCLIModeInvoker m_wspclimiFlowControlling = null;
    private static boolean m_fIsResponseFileSpecified = false;
    private static boolean m_fIsHelpSpecified = false;
    private static boolean m_fValidationResult = true;
    private static LoggerContext m_lcSwitcher = null;
    private static List<WSProfileJobGroupData> m_lwspjgdAllJobDatas = new Vector<WSProfileJobGroupData>();
    private static List<WSProfileJob> m_lwspjAllJobs = new Vector<WSProfileJob>();
    private static List<String> m_lsHelpMessage = new Vector<String>();
    private static Logger LOGGER = LoggerFactory.createLogger(WSProfileDataStore.class);
    private static String S_CLASS_NAME = WSProfileDataStore.class.getName();

    public static void initialize() {
        LOGGER.entering(S_CLASS_NAME, "initialize");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Initializing Data Store ...");
        m_htIncomingArgs = new Hashtable();
        m_wspclimiIncoming = null;
        m_htArgsInResponseFile = new Hashtable();
        m_fIsResponseFileSpecified = false;
        m_lcSwitcher = null;
        m_fIsHelpSpecified = false;
        m_lwspjgdAllJobDatas = new Vector<WSProfileJobGroupData>();
        m_lwspjAllJobs = new Vector<WSProfileJob>();
        m_lsHelpMessage = new Vector<String>();
        m_htValidationMessages = new Hashtable();
        m_htDisabledActions = new Hashtable();
        LOGGER.exiting(S_CLASS_NAME, "initialize");
    }

    public static void setDisabledActions(String absTemplatePath, String[] disabledActions) {
        if (m_htDisabledActions == null) {
            m_htDisabledActions = new Hashtable();
        }
        m_htDisabledActions.put(absTemplatePath, disabledActions);
    }

    public static String[] getDisabledActions(String absTemplatePath) {
        return m_htDisabledActions.get(absTemplatePath);
    }

    public static void setIncomingArgs(String[] saIncomingArgs) {
        LOGGER.entering(S_CLASS_NAME, "setIncomingArgs");
        if (saIncomingArgs != null) {
            WSProfileDataStore.setIncomingArgs(CommandLineArgumentsUtils.convertCommandLineToHashtable(saIncomingArgs));
        } else {
            WSProfileDataStore.setIncomingArgs(new Hashtable<String, List>());
        }
        LOGGER.exiting(S_CLASS_NAME, "setIncomingArgs");
    }

    public static void setIncomingArgs(Map<String, List> mIncomingArgs) {
        LOGGER.entering(S_CLASS_NAME, "setIncomingArgs");
        ProfilesCryptoI pci = WSProfileUtils.getCryptoHelper();
        Map<String, List> decryptedIncomingArgs = pci.getDecryptedMap(mIncomingArgs, false);
        WSProfileCLIModeInvoker wspclimi = WSProfileDataStore.getIncomingModeInvoker();
        if (wspclimi != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setIncomingArgs", "Updating mode invoker arguments ...");
            wspclimi.setIncomingCommandLineArguments(CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(decryptedIncomingArgs));
        }
        m_htIncomingArgs = mIncomingArgs != null ? (Hashtable)WSProfileUtils.cloneMap(decryptedIncomingArgs) : new Hashtable();
        LOGGER.exiting(S_CLASS_NAME, "setIncomingArgs");
    }

    public static void setFlowControllingArgs(String[] saFlowControllingArgs) {
        LOGGER.entering(S_CLASS_NAME, "setFlowControllingArgs");
        if (saFlowControllingArgs != null) {
            WSProfileDataStore.setFlowControllingArgs(CommandLineArgumentsUtils.convertCommandLineToHashtable(saFlowControllingArgs));
        } else {
            WSProfileDataStore.setFlowControllingArgs(new Hashtable<String, List>());
        }
        LOGGER.exiting(S_CLASS_NAME, "setFlowControllingArgs");
    }

    public static void setFlowControllingArgs(Map<String, List> mFlowControllingArgs) {
        LOGGER.entering(S_CLASS_NAME, "setFlowControllingArgs");
        WSProfileCLIModeInvoker wspclimi = WSProfileDataStore.getFlowControllingModeInvoker();
        if (wspclimi != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setFlowControllingArgs", "Updating mode invoker arguments ...");
            wspclimi.setIncomingCommandLineArguments(CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(mFlowControllingArgs));
        }
        if (m_fIsResponseFileSpecified) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setFlowControllingArgs", "Updating response file arguments ...");
            WSProfileDataStore.setResponseFileArgs(mFlowControllingArgs);
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setFlowControllingArgs", "Updating incoming arguments ...");
            WSProfileDataStore.setIncomingArgs(mFlowControllingArgs);
        }
        LOGGER.exiting(S_CLASS_NAME, "setFlowControllingArgs");
    }

    public static String[] getIncomingArgsAsArray() {
        LOGGER.entering(S_CLASS_NAME, "getIncomingArgsAsArray");
        if (m_htIncomingArgs == null) {
            LOGGER.exiting(S_CLASS_NAME, "getIncomingArgsAsArray");
            return new String[0];
        }
        LOGGER.exiting(S_CLASS_NAME, "getIncomingArgsAsArray");
        return WSProfileUtils.getMapAsStringArray(m_htIncomingArgs);
    }

    public static Map<String, List> getIncomingArgsAsMap() {
        LOGGER.entering(S_CLASS_NAME, "getIncomingArgsAsMap");
        if (m_htIncomingArgs == null) {
            LOGGER.exiting(S_CLASS_NAME, "getIncomingArgsAsMap");
            return new Hashtable<String, List>();
        }
        LOGGER.exiting(S_CLASS_NAME, "getIncomingArgsAsMap");
        return WSProfileUtils.cloneMap(m_htIncomingArgs);
    }

    public static void setCurrentLoggerContext(LoggerContext lcCurrent) {
        LOGGER.entering(S_CLASS_NAME, "setCurrentLoggerContext");
        m_lcSwitcher = lcCurrent;
        LOGGER.exiting(S_CLASS_NAME, "setCurrentLoggerContext");
    }

    public static LoggerContext getCurrentLoggerContext() {
        LOGGER.entering(S_CLASS_NAME, "getCurrentLoggerContext");
        LOGGER.exiting(S_CLASS_NAME, "getCurrentLoggerContext");
        return m_lcSwitcher;
    }

    public static void setIncomingModeInvoker() {
        LOGGER.entering(S_CLASS_NAME, "setIncomingModeInvoker");
        m_wspclimiIncoming = WSProfileCLIModeInvoker.findModeInvoker(WSProfileDataStore.getIncomingArgsAsArray());
        LOGGER.exiting(S_CLASS_NAME, "setIncomingModeInvoker");
    }

    public static WSProfileCLIModeInvoker getIncomingModeInvoker() {
        LOGGER.entering(S_CLASS_NAME, "getIncomingModeInvoker");
        LOGGER.exiting(S_CLASS_NAME, "getIncomingModeInvoker");
        return m_wspclimiIncoming;
    }

    public static void addValidationErrorMessages(Map<String, List> mErrorMessages) {
        LOGGER.entering(S_CLASS_NAME, "addValidationErrorMessages");
        if (mErrorMessages != null) {
            m_htValidationMessages.putAll(new Hashtable<String, List>(mErrorMessages));
        }
        LOGGER.exiting(S_CLASS_NAME, "addValidationErrorMessages");
    }

    public static Map getAllValidationErrorMessages() {
        LOGGER.entering(S_CLASS_NAME, "getAllValidationErrorMessages");
        if (m_htValidationMessages != null) {
            LOGGER.exiting(S_CLASS_NAME, "getAllValidationErrorMessages");
            return (Hashtable)m_htValidationMessages.clone();
        }
        LOGGER.exiting(S_CLASS_NAME, "getAllValidationErrorMessages");
        return new Hashtable();
    }

    public static void addJobToStore(WSProfileJob wspjNewJob) {
        LOGGER.entering(S_CLASS_NAME, "addJobToStore");
        if (wspjNewJob != null) {
            m_lwspjAllJobs.add(wspjNewJob);
        }
        LOGGER.exiting(S_CLASS_NAME, "addJobToStore");
    }

    public static void addJobsToStore(List<WSProfileJob> lwspjNewJobs) {
        LOGGER.entering(S_CLASS_NAME, "addJobToStore");
        if (lwspjNewJobs != null) {
            m_lwspjAllJobs.addAll(lwspjNewJobs);
        }
        LOGGER.exiting(S_CLASS_NAME, "addJobToStore");
    }

    public static List<WSProfileJob> getAllStoredJobs() {
        LOGGER.entering(S_CLASS_NAME, "getAllStoredJobs");
        if (m_lwspjAllJobs != null) {
            LOGGER.exiting(S_CLASS_NAME, "getAllStoredJobs");
            return m_lwspjAllJobs;
        }
        LOGGER.exiting(S_CLASS_NAME, "getAllStoredJobs");
        return new Vector<WSProfileJob>();
    }

    public static void setHelpMessages(List<String> lsHelpMessages) {
        LOGGER.entering(S_CLASS_NAME, "setHelpMessages");
        if (m_lsHelpMessage != null && m_lsHelpMessage.size() == 0 || m_lsHelpMessage == null) {
            m_lsHelpMessage = lsHelpMessages;
        } else {
            m_lsHelpMessage.addAll(lsHelpMessages);
        }
        LOGGER.exiting(S_CLASS_NAME, "setHelpMessages");
    }

    public static List<String> getHelpMessages() {
        LOGGER.entering(S_CLASS_NAME, "getHelpMessages");
        if (m_lsHelpMessage != null) {
            LOGGER.exiting(S_CLASS_NAME, "getHelpMessages");
            return new Vector<String>(m_lsHelpMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "getHelpMessages");
        return new Vector<String>();
    }

    public static void setHelpRequestedFlag(boolean fHelpRequested) {
        LOGGER.entering(S_CLASS_NAME, "setHelpRequestedFlag");
        m_fIsHelpSpecified = fHelpRequested;
        LOGGER.exiting(S_CLASS_NAME, "setHelpRequestedFlag");
    }

    public static boolean isHelpRequested() {
        LOGGER.entering(S_CLASS_NAME, "isHelpRequested");
        LOGGER.exiting(S_CLASS_NAME, "isHelpRequested");
        return m_fIsHelpSpecified;
    }

    public static void addJobGroup(WSProfileJobGroupData wspjgdNew) {
        LOGGER.entering(S_CLASS_NAME, "addJobGroup");
        if (wspjgdNew != null) {
            m_lwspjgdAllJobDatas.add(wspjgdNew);
        }
        LOGGER.exiting(S_CLASS_NAME, "addJobGroup");
    }

    public static WSProfileJobGroupData getJobGroup(int nJGDIndex) {
        LOGGER.entering(S_CLASS_NAME, "getJobGroup");
        int size = m_lwspjgdAllJobDatas.size();
        if (nJGDIndex > size || nJGDIndex == 0 && size == 0) {
            LOGGER.exiting(S_CLASS_NAME, "getJobGroup");
            return null;
        }
        LOGGER.exiting(S_CLASS_NAME, "getJobGroup");
        return m_lwspjgdAllJobDatas.get(nJGDIndex);
    }

    public static int getNumberOfJobGroupsInDataStore() {
        LOGGER.entering(S_CLASS_NAME, "getNumberOfJobGroupsInDataStore");
        if (m_lwspjgdAllJobDatas != null) {
            LOGGER.exiting(S_CLASS_NAME, "getNumberOfJobGroupsInDataStore");
            return m_lwspjgdAllJobDatas.size();
        }
        LOGGER.exiting(S_CLASS_NAME, "getNumberOfJobGroupsInDataStore");
        return 0;
    }

    public static void setResponseFileIsSpecifiedArg(boolean fResponseFileIsSpecified) {
        LOGGER.entering(S_CLASS_NAME, "setResponseFileIsSpecifiedArg");
        m_fIsResponseFileSpecified = fResponseFileIsSpecified;
        LOGGER.exiting(S_CLASS_NAME, "setResponseFileIsSpecifiedArg");
    }

    public static boolean isResponseFileSpecified() {
        LOGGER.entering(S_CLASS_NAME, "isResponseFileSpecified");
        LOGGER.exiting(S_CLASS_NAME, "isResponseFileSpecified");
        return m_fIsResponseFileSpecified;
    }

    public static void setResponseFileArgs(String[] saResponseFileArgs) {
        LOGGER.entering(S_CLASS_NAME, "setResponseFileArgs");
        if (saResponseFileArgs != null) {
            WSProfileDataStore.setResponseFileArgs(CommandLineArgumentsUtils.convertCommandLineToHashtable(saResponseFileArgs));
        } else {
            WSProfileDataStore.setResponseFileArgs(new Hashtable<String, List>());
        }
        LOGGER.exiting(S_CLASS_NAME, "setResponseFileArgs");
    }

    public static void setResponseFileArgs(Map<String, List> mapResponseFileArgs) {
        LOGGER.entering(S_CLASS_NAME, "setResponseFileArgs");
        ProfilesCryptoI pci = WSProfileUtils.getCryptoHelper();
        Map<String, List> decryptedMapResponseFileArgs = pci.getDecryptedMap(mapResponseFileArgs, true);
        m_htArgsInResponseFile = mapResponseFileArgs != null ? (Hashtable)WSProfileUtils.cloneMap(decryptedMapResponseFileArgs) : new Hashtable();
        LOGGER.exiting(S_CLASS_NAME, "setResponseFileArgs");
    }

    public static String[] getResponseFileArgsAsArray() {
        LOGGER.entering(S_CLASS_NAME, "getResponseFileArgsAsArray");
        if (m_htArgsInResponseFile == null) {
            LOGGER.exiting(S_CLASS_NAME, "getResponseFileArgsAsArray");
            return new String[0];
        }
        LOGGER.exiting(S_CLASS_NAME, "getResponseFileArgsAsArray");
        return WSProfileUtils.getMapAsStringArray(m_htArgsInResponseFile);
    }

    public static Map<String, List> getResponseFileArgsAsMap() {
        LOGGER.entering(S_CLASS_NAME, "getResponseFileArgsAsMap");
        if (m_htArgsInResponseFile == null) {
            LOGGER.exiting(S_CLASS_NAME, "getResponseFileArgsAsMap");
            return new Hashtable<String, List>();
        }
        LOGGER.exiting(S_CLASS_NAME, "getResponseFileArgsAsMap");
        return WSProfileUtils.cloneMap(m_htArgsInResponseFile);
    }

    public static void setFlowControllingModeInvoker() {
        LOGGER.entering(S_CLASS_NAME, "setFlowControllingModeInvoker");
        m_wspclimiFlowControlling = WSProfileCLIModeInvoker.findModeInvoker(WSProfileDataStore.getFlowControllingArgsAsArray());
        LOGGER.exiting(S_CLASS_NAME, "setFlowControllingModeInvoker");
    }

    public static WSProfileCLIModeInvoker getFlowControllingModeInvoker() {
        LOGGER.entering(S_CLASS_NAME, "getFlowControllingModeInvoker");
        LOGGER.exiting(S_CLASS_NAME, "getFlowControllingModeInvoker");
        return m_wspclimiFlowControlling;
    }

    public static Map<String, List> getFlowControllingArgsAsMap() {
        LOGGER.entering(S_CLASS_NAME, "getFlowControllingArgsAsMap");
        if (m_fIsResponseFileSpecified && !WSProfileDataStore.getIncomingArgsAsMap().containsKey("help")) {
            LOGGER.exiting(S_CLASS_NAME, "getFlowControllingArgsAsMap");
            return WSProfileDataStore.getResponseFileArgsAsMap();
        }
        LOGGER.exiting(S_CLASS_NAME, "getFlowControllingArgsAsMap");
        return WSProfileDataStore.getIncomingArgsAsMap();
    }

    public static String[] getFlowControllingArgsAsArray() {
        LOGGER.entering(S_CLASS_NAME, "getFlowControllingArgsAsArray");
        if (m_fIsResponseFileSpecified && !WSProfileDataStore.getIncomingArgsAsMap().containsKey("help")) {
            LOGGER.exiting(S_CLASS_NAME, "getFlowControllingArgsAsArray");
            return WSProfileDataStore.getResponseFileArgsAsArray();
        }
        LOGGER.exiting(S_CLASS_NAME, "getFlowControllingArgsAsArray");
        return WSProfileDataStore.getIncomingArgsAsArray();
    }

    public static final String getFlowControllingArgumentValue(String sKey) {
        LOGGER.entering(S_CLASS_NAME, "getFlowControllingArgumentValue");
        Map<String, List> mapArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        if (mapArgs.containsKey(sKey)) {
            List listArgValues = mapArgs.get(sKey);
            String sValue = "";
            if (listArgValues.size() > 0) {
                sValue = (String)listArgValues.get(0);
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getArgumentValue", sKey + " was resolved to " + sValue);
            LOGGER.exiting(S_CLASS_NAME, "getFlowControllingArgumentValue");
            return sValue;
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getArgumentValue", "Could not resolve " + sKey + " from command line");
        LOGGER.exiting(S_CLASS_NAME, "getFlowControllingArgumentValue");
        return null;
    }

    public static boolean isArgSpecified(String sArg) {
        LOGGER.entering(S_CLASS_NAME, "isArgSpecified");
        String[] saFlowControllingArgs = WSProfileDataStore.getFlowControllingArgsAsArray();
        for (int i = 0; i < saFlowControllingArgs.length; ++i) {
            if (!saFlowControllingArgs[i].equals("-" + sArg)) continue;
            LOGGER.exiting(S_CLASS_NAME, "isArgSpecified");
            return true;
        }
        LOGGER.exiting(S_CLASS_NAME, "isArgSpecified");
        return false;
    }

    public static void setValidationResult(boolean fValidationResult) {
        LOGGER.entering(S_CLASS_NAME, "setValidationResult");
        m_fValidationResult = fValidationResult;
        LOGGER.exiting(S_CLASS_NAME, "setValidationResult");
    }

    public static boolean didValidationPass() {
        LOGGER.entering(S_CLASS_NAME, "didValidationPass");
        LOGGER.exiting(S_CLASS_NAME, "didValidationPass");
        return m_fValidationResult;
    }

    public static boolean isAllMode() {
        LOGGER.entering(WSProfile.class.getName(), "isAllMode");
        String sMode = WSProfileDataStore.getFlowControllingModeInvoker().getModeFlag();
        for (int i = 0; i < WSProfileConstants.S_ALL_TYPE_MODES.length; ++i) {
            if (!WSProfileConstants.S_ALL_TYPE_MODES[i].equals(sMode)) continue;
            LOGGER.exiting(WSProfile.class.getName(), "isAllMode");
            return true;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isAllMode");
        return false;
    }
}

