/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIDeleteAllProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("deleteAll", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIDeleteAllProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIDeleteAllProfileInvoker.class.getName();

    public WSProfileCLIDeleteAllProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIDeleteAllProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIDeleteAllProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIDeleteAllProfileInvoker.failureMessage";
    }

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "deleteAll";
    }

    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return true;
    }

    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return false;
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        int nReturnCode = 1;
        try {
            nReturnCode = WSProfile.deleteAll(CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    public boolean isPublicMode() {
        return this.fIsPublic;
    }
}

