/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.DisabledActionsUtil;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLICreateProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("create", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("templatePath", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profilePath", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("isDefault", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("omitAction", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    protected static final String S_ABOUT_THIS_PROFILE_TXT = "/logs/AboutThisProfile.txt";
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLICreateProfileInvoker.successMessage";
    private static final String S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLICreateProfileInvoker.partialSuccessMessage";
    private static final String S_FAILURE_KEY = "WSProfile.WSProfileCLICreateProfileInvoker.failureMessage";
    private static final String S_CELL_CREATION_SPECIFIC_HELP = "WSProfile.WSProfileCLICreateProfileInvoker.cellCreationSpecificHelp";
    private static final String S_NL = "\n";
    private static final String S_INVALID_PROFILE_CREATION_TEMPLATE = "WSProfile.WSProfileCLICreateProfileInvoker.invalidProfileCreationTemplate";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLICreateProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLICreateProfileInvoker.class.getName();

    @Override
    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "create";
    }

    @Override
    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return true;
    }

    @Override
    public boolean isDefaultingAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isDefaultingAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isDefaultingAllowed");
        return true;
    }

    @Override
    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return true;
    }

    @Override
    public Map<String, List> generateJobArgs(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack, int nJobNumber) {
        LOGGER.entering(this.getClass().getName(), "generateJobArgs");
        Map<String, List> mBrokenDownArgs = WSProfileUtils.cloneMap(mJobGroupArgs);
        if (nJobNumber > 0) {
            mBrokenDownArgs.remove("create");
            mBrokenDownArgs.put("augment", new Vector());
        }
        LOGGER.exiting(this.getClass().getName(), "generateJobArgs");
        return super.generateJobArgs(mBrokenDownArgs, lwsptTemplateStack, nJobNumber);
    }

    @Override
    public void printOutExecutionResult(int nReturnCode, Map<String, List> mapArgs) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getExecutionResultMessage");
        String sReturnMessageKey = "";
        String sExecutionMessage = "";
        String sProfileName = "";
        String sProfilePath = "";
        if (nReturnCode == 1) {
            sReturnMessageKey = S_FAILURE_KEY;
            sExecutionMessage = ResourceBundleUtils.getLocaleString(sReturnMessageKey, LoggerFactoryConstants.getGlobalLogFilePath());
        } else if (nReturnCode == 2) {
            sReturnMessageKey = S_PARTIAL_SUCCESS_KEY;
            sExecutionMessage = ResourceBundleUtils.getLocaleString(sReturnMessageKey, LoggerFactoryConstants.getGlobalLogFilePath());
        } else if (nReturnCode == 0) {
            sReturnMessageKey = S_SUCCESS_KEY;
            if (mapArgs.get("profileName") != null && mapArgs.get("profileName").size() > 0) {
                sProfileName = (String)mapArgs.get("profileName").get(0);
            } else {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, sExecutionMessage, "A value for the parameter: profileName can not be found.");
            }
            if (mapArgs.get("profilePath") != null && mapArgs.get("profilePath").size() > 0) {
                sProfilePath = (String)mapArgs.get("profilePath").get(0);
            } else {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, sExecutionMessage, "A value for the parameter: profilePath can not be found.");
            }
            if (sProfileName.length() > 0 && sProfilePath.length() > 0) {
                sProfilePath = FileUtils.getNormalizedPath(sProfilePath + S_ABOUT_THIS_PROFILE_TXT);
                sExecutionMessage = MessageFormat.format(ResourceBundleUtils.getLocaleString(sReturnMessageKey), sProfileName, sProfilePath);
            } else {
                sExecutionMessage = sReturnMessageKey;
            }
        }
        if (!sExecutionMessage.equals(sReturnMessageKey)) {
            OutputStreamHandler.println(sExecutionMessage);
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, sExecutionMessage, "A message for the key " + sReturnMessageKey + " does not exist in the resource bundle.");
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getExecutionResultMessage");
    }

    @Override
    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        String sProfilePath = this.getArgumentValue("profilePath");
        String sTemplatePath = this.getArgumentValue("templatePath");
        String sNodeName = this.getArgumentValue("nodeName");
        String sCellName = this.getArgumentValue("cellName");
        String sHostName = this.getArgumentValue("hostName");
        int nReturnCode = 1;
        try {
            nReturnCode = WSProfile.create(sProfileName, new File(sProfilePath).getAbsoluteFile(), new File(sTemplatePath).getAbsoluteFile(), sNodeName, sCellName, sHostName, CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            String sSuccessMessage = MessageFormat.format(ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY), this.getArgumentValue("profileName"), this.getArgumentValue("profilePath"));
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", sSuccessMessage);
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        if (sIncomingProfileTemplatePath != null) {
            Vector<WSProfileTemplate> v_wsptProfileTemplates = new Vector<WSProfileTemplate>();
            v_wsptProfileTemplates.addAll(PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(sIncomingProfileTemplatePath));
            DisabledActionsUtil dau = new DisabledActionsUtil();
            v_wsptProfileTemplates = dau.decorateProfileTemplatesWithDisabledActions(v_wsptProfileTemplates);
            for (int i = 0; i < v_wsptProfileTemplates.size(); ++i) {
                File fileThisTemplate = v_wsptProfileTemplates.get(i).getProfileTemplatePath();
                Vector<String> v_disabledActions = v_wsptProfileTemplates.get(i).getDisabledActions();
                Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(fileThisTemplate.getAbsoluteFile(), "actionRegistry.xml").getAbsolutePath());
                String disabledActions = dau.buildDisabledActionsProperty(v_disabledActions);
                if (disabledActions != null) {
                    System.setProperty("WS_CMT_DISABLED_ACTIONS", disabledActions);
                }
                List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(fileThisTemplate.getAbsolutePath()));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
                this.resetJavaSystemProperties(propertiesCurrentSystem);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        if (sIncomingProfileTemplatePath != null) {
            Vector<WSProfileTemplate> v_wsptProfileTemplates = new Vector<WSProfileTemplate>();
            v_wsptProfileTemplates.addAll(PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(sIncomingProfileTemplatePath));
            for (int i = 0; i < v_wsptProfileTemplates.size(); ++i) {
                File fileThisTemplate = ((WSProfileTemplate)v_wsptProfileTemplates.get(i)).getProfileTemplatePath();
                Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(fileThisTemplate.getAbsoluteFile(), "actionRegistry.xml").getAbsolutePath());
                List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(fileThisTemplate.getAbsolutePath()));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
                this.resetJavaSystemProperties(propertiesCurrentSystem);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected void doHelp() {
        LOGGER.entering(WSProfileCLICreateProfileInvoker.class.getName(), "doHelp");
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        if (sIncomingProfileTemplatePath != null && !sIncomingProfileTemplatePath.equals("")) {
            try {
                WSProfileTemplate wsptThis = new WSProfileTemplate(sIncomingProfileTemplatePath);
                Vector v_wsptPrereqs = (Vector)PrereqTemplateUtils.getTemplatesForStackCreation(wsptThis);
                PrereqTemplateUtils.validateListForCreation(v_wsptPrereqs);
                if (wsptThis.getType().equals("cell.dmgr") || wsptThis.getType().equals("cell.node") || wsptThis.getType().equals("cell")) {
                    OutputStreamHandler.println(S_NL + ResourceBundleUtils.getLocaleString(S_CELL_CREATION_SPECIFIC_HELP) + S_NL);
                }
                super.doHelp();
            }
            catch (WSProfileException e) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "doHelp", "Could not build a list of prerequisite profile templates for profile template " + sIncomingProfileTemplatePath);
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_CREATION_TEMPLATE, sIncomingProfileTemplatePath));
            }
        } else {
            super.doHelp();
        }
        LOGGER.exiting(WSProfileCLICreateProfileInvoker.class.getName(), "doHelp");
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }

    @Override
    public String getRegistryName() {
        return "actionRegistry.xml";
    }
}

