/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLICheckProfileRegistryIntegrityInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("validateRegistry", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_REGISTRY_CORRUPT = "WSProfile.WSProfileCLICheckProfileRegistryIntegrityInvoker.registryCorrupt";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLICheckProfileRegistryIntegrityInvoker.class);
    private static final String S_REGISTRY_VALID = "WSProfile.WSProfileCLICheckProfileRegistryIntegrityInvoker.noInvalidProfiles";
    private static final String S_REGISTRY_INVALID = "WSProfile.WSProfileCLICheckProfileRegistryIntegrityInvoker.someInvalidProfiles";

    @Override
    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "validateRegistry";
    }

    @Override
    public void printOutExecutionResult(int nReturnCode, Map<String, List> mapArgs) {
    }

    @Override
    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        int nReturnCode = 0;
        try {
            List listprofilesInvalid = WSProfile.validateRegistry(this.getProfileRegistryPath());
            if (listprofilesInvalid.size() == 0) {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_VALID));
            } else {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_INVALID));
                this.printProfileList(listprofilesInvalid);
            }
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    private void printProfileList(List listprofiles) {
        Vector<String> vsProfileNames = new Vector<String>();
        for (int i = 0; i < listprofiles.size(); ++i) {
            Profile profileThis = (Profile)listprofiles.get(i);
            vsProfileNames.add(profileThis.getName());
        }
        OutputStreamHandler.println("profileList", vsProfileNames);
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }
}

