/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Native2AsciiAntTask
extends Task {
    private String m_sInFile = null;
    private String m_sOutFile = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(Native2AsciiAntTask.class);
    private static final String S_CLASS_NAME = Native2AsciiAntTask.class.getName();
    private static final String S_NO_INFILE = "Missing inFile property";
    private static final String S_NO_OUTFILE = "Missing outFile property";

    public void init() throws BuildException {
        LOGGER.entering(Native2AsciiAntTask.class.getName(), "init");
        super.init();
        this.m_sInFile = null;
        this.m_sOutFile = null;
        LOGGER.exiting(Native2AsciiAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(Native2AsciiAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the Native2AsciiAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String encoding = Charset.defaultCharset().name();
        String inputfile = this.m_sInFile;
        String outputfile = this.m_sOutFile;
        try {
            String line;
            InputStream in = inputfile != null ? new FileInputStream(inputfile) : System.in;
            OutputStream out = outputfile != null ? new FileOutputStream(outputfile) : System.out;
            BufferedReader r = new BufferedReader(new InputStreamReader(in, encoding));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));
            while ((line = r.readLine()) != null) {
                String outline = "";
                char[] ca = line.toCharArray();
                for (int i = 0; i < ca.length; ++i) {
                    char a = ca[i];
                    outline = a > '\u00ff' ? outline + "\\u" + Integer.toHexString(a) : (a > '\u007f' ? outline + "\\u00" + Integer.toHexString(a) : outline + a);
                }
                w.write(outline);
                w.newLine();
            }
            w.flush();
            w.close();
            r.close();
        }
        catch (IOException exc) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "I/O error writing to " + this.m_sOutFile);
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        LOGGER.exiting(Native2AsciiAntTask.class.getName(), "execute");
    }

    public void setInfile(String sInFile) {
        LOGGER.entering(Native2AsciiAntTask.class.getName(), "setInfile");
        this.m_sInFile = sInFile;
        LOGGER.exiting(Native2AsciiAntTask.class.getName(), "setInfile");
    }

    public void setOutfile(String sOutFile) {
        LOGGER.entering(Native2AsciiAntTask.class.getName(), "setOutFile");
        this.m_sOutFile = sOutFile;
        LOGGER.exiting(Native2AsciiAntTask.class.getName(), "setOutFile");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(Native2AsciiAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sInFile == null) {
            this.m_sErrorMessage = S_NO_INFILE;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(Native2AsciiAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sOutFile == null) {
            this.m_sErrorMessage = S_NO_OUTFILE;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(Native2AsciiAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(Native2AsciiAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

