/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.validators.NoInvalidCharactersValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASUtilities {
    private static final Logger LOGGER = LoggerFactory.createLogger(WASUtilities.class);
    private static final String S_CLASS_NAME = WASUtilities.class.getName();
    public static final String S_WINDOWS = "Windows";
    public static final String S_LINUX = "Linux";
    public static final String S_SOLARIS = "Solaris";
    public static final String S_SUN_OS = "SUN OS";
    public static final String S_HP_UX = "HP UX";
    public static final String S_AIX = "AIX";
    public static final String S_PASSWD_HIDE = "**********";
    public static final String S_LOCALHOST = "localhost";
    private static final String S_EMPTY = "";

    public static String getWASProperty(String property) throws IOException {
        String prop = S_EMPTY;
        if (property != null && !property.equals(S_EMPTY)) {
            WSProfileProperties m_wspp = new WSProfileProperties();
            prop = m_wspp.getProperty(property);
        }
        return prop;
    }

    public static String getSystemPropertyValue(String propertyName) {
        if (propertyName == null || S_EMPTY.equals(propertyName)) {
            return propertyName;
        }
        String value = System.getProperty(propertyName);
        if (value == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getSystemPropertyValue", propertyName + " was not set in the system properties");
        }
        return value;
    }

    public static boolean isWindows() {
        return PlatformConstants.isCurrentPlatformWindows();
    }

    public static boolean isUnix() {
        return PlatformConstants.isCurrentPlatformUNIX();
    }

    public static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.equals(S_LINUX);
    }

    public static String printArrayToString(String[] sa) {
        String sComma = " , ";
        String s = "[";
        for (int i = 0; i < sa.length; ++i) {
            s = s.equals("[") ? s + sa[i] : s + sComma + sa[i];
        }
        s = s + "]";
        return s;
    }

    public static String hideArgValueIfNecessary(String validatorArg, String validatorArgVal, String[] sMaskableArguments) {
        String sArgValue = validatorArgVal;
        for (int maskCount = 0; maskCount < sMaskableArguments.length; ++maskCount) {
            if (!validatorArg.equals(sMaskableArguments[maskCount])) continue;
            sArgValue = S_PASSWD_HIDE;
            break;
        }
        return sArgValue;
    }

    public static boolean runAdministrativeSecurityNonSAFValidator() {
        String sAdminSecurityCheckArg = System.getProperty("enableAdminSecurity");
        String sUseSAFSecurityArg = System.getProperty("useSAFSecurity");
        if (sUseSAFSecurityArg != null && sUseSAFSecurityArg.equals("true")) {
            return false;
        }
        return sAdminSecurityCheckArg != null && sAdminSecurityCheckArg.equals("true");
    }

    public static boolean runAdministrativeSecurityValidator() {
        String sAdminSecurityCheckArg = System.getProperty("enableAdminSecurity");
        return sAdminSecurityCheckArg != null && sAdminSecurityCheckArg.equals("true");
    }

    public static String getEnvironmentVariable(String sVarName) {
        if (WASUtilities.isWindows()) {
            String sValue = null;
            Process process = null;
            try {
                String line;
                process = Runtime.getRuntime().exec("cmd /C set");
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputstreamreader = new InputStreamReader(inputStream);
                BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
                while ((line = bufferedreader.readLine()) != null) {
                    if (line.indexOf(sVarName) != 0) continue;
                    int rEquals = line.indexOf("=");
                    sValue = line.substring(rEquals + 1, line.length());
                    break;
                }
                inputStream.close();
                inputstreamreader.close();
                bufferedreader.close();
            }
            catch (IOException e) {
                sValue = null;
            }
            return sValue;
        }
        return null;
    }

    public static String getShortHostName(String sHostName) {
        boolean f_isHostNameGood;
        if (sHostName == null || sHostName.length() == 0) {
            return S_LOCALHOST;
        }
        int delimiter = sHostName.indexOf(46);
        if (delimiter != -1) {
            sHostName = sHostName.substring(0, delimiter);
        }
        if (f_isHostNameGood = WASUtilities.checkIfPatternMatchesString(sHostName, NoInvalidCharactersValidator.saINVALID_PATTERNS)) {
            return sHostName;
        }
        try {
            sHostName = WASUtilities.findShortHostName();
        }
        catch (UnknownHostException e) {
            sHostName = S_LOCALHOST;
        }
        return sHostName;
    }

    public static boolean checkIfPatternMatchesString(String sCandidate, String[] saPatterns) {
        int i;
        Pattern[] pattern = new Pattern[saPatterns.length];
        Matcher[] matcher = new Matcher[saPatterns.length];
        for (i = 0; i < saPatterns.length; ++i) {
            pattern[i] = Pattern.compile(saPatterns[i]);
            matcher[i] = pattern[i].matcher(sCandidate);
        }
        for (i = 0; i < matcher.length; ++i) {
            if (!matcher[i].find()) continue;
            return false;
        }
        return true;
    }

    public static String findShortHostName() throws UnknownHostException {
        String tmp;
        InetAddress addr;
        String shortHostName;
        block6: {
            shortHostName = null;
            addr = null;
            tmp = null;
            if (PlatformConstants.isCurrentPlatformOS400()) {
                try {
                    addr = InetAddress.getLocalHost();
                    tmp = addr.getHostAddress();
                    if (tmp == null) {
                        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "findShortHostName", "Unable to retieve short host name, returning LOOPBACK");
                        shortHostName = "LOOPBACK";
                        return shortHostName;
                    }
                    break block6;
                }
                catch (UnknownHostException uhe) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "findShortHostName", "Unable to retieve short host name, returning LOOPBACK");
                    shortHostName = "LOOPBACK";
                    return shortHostName;
                }
            }
            addr = InetAddress.getLocalHost();
            tmp = addr.getHostAddress();
        }
        String fullHostName = S_EMPTY;
        String machineHostName = InetAddress.getByName(tmp).getHostName();
        if (tmp.equals(machineHostName)) {
            String result;
            String tmpHost = addr.toString();
            fullHostName = result = tmpHost.substring(0, tmpHost.indexOf("/"));
        } else {
            fullHostName = machineHostName;
        }
        int delimiter = fullHostName.indexOf(46);
        shortHostName = delimiter != -1 ? fullHostName.substring(0, delimiter) : fullHostName;
        return shortHostName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findHostName() throws UnknownHostException {
        String machineHostName;
        String fullHostName = S_EMPTY;
        if (PlatformConstants.isCurrentPlatformOS400()) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                fullHostName = addr.getHostName();
                if (fullHostName != null) return fullHostName;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "findHostName", "Unable to retieve host name, returning LOOPBACK");
                return "LOOPBACK";
            }
            catch (UnknownHostException uhe) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "findHostName", "Unable to retieve host name, returning LOOPBACK");
                return "LOOPBACK";
            }
        }
        InetAddress addr = InetAddress.getLocalHost();
        String tmp = addr.getHostAddress();
        if (tmp.equals(machineHostName = InetAddress.getByName(tmp).getHostName())) {
            String result;
            String tmpHost = addr.toString();
            fullHostName = result = tmpHost.substring(0, tmpHost.indexOf("/"));
        } else {
            fullHostName = machineHostName;
        }
        Pattern pattern = Pattern.compile("^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+localdomain");
        Matcher matcher = pattern.matcher(fullHostName);
        if (!matcher.matches()) return fullHostName;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "findHostName", "Hostname returned is:" + fullHostName + " -> converting to short hostname form");
        return WASUtilities.findShortHostName();
    }
}

