/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.aggregation.tags.InitTag;
import com.ibm.ws.portletcontainer.aggregation.tags.PortletStateHashtable;
import com.ibm.ws.portletcontainer.aggregation.tags.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class StateTag
extends TagSupport {
    private static final long serialVersionUID = -401890605736727354L;
    private static final String CLASS_NAME = StateTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private ResourceBundle bundle = logger.getResourceBundle();
    protected String url;
    protected String windowId;
    protected String var;
    protected String scope;
    protected String portletMode;
    protected String portletWindowState;
    private String action;
    protected Map<String, String[]> urlParams;
    protected InitTag parent = null;

    public StateTag() {
        this.init();
    }

    protected void init() {
        this.action = null;
        this.portletWindowState = null;
        this.portletMode = null;
        this.scope = null;
        this.var = null;
        this.windowId = null;
        this.url = null;
        this.urlParams = new HashMap<String, String[]>();
    }

    public int doStartTag() throws JspException {
        this.parent = (InitTag)StateTag.findAncestorWithClass(this, InitTag.class);
        if (this.parent == null) {
            throw new JspTagException(this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.init.tag"));
        }
        String key = PortletStateHashtable.createKey(this.url, this.windowId);
        Map stateHashtable = (Map)this.pageContext.getSession().getAttribute(key);
        String modeValue = null;
        String stateValue = null;
        if (stateHashtable != null) {
            modeValue = (String)stateHashtable.get(Utils.modeSuffix);
            stateValue = (String)stateHashtable.get(Utils.stateSuffix);
        }
        if (this.portletMode == null) {
            this.portletMode = modeValue;
        }
        if (this.portletWindowState == null) {
            this.portletWindowState = stateValue;
        }
        this.urlParams = new HashMap<String, String[]>();
        return 1;
    }

    public int doEndTag() throws JspException {
        boolean actionState = "true".equalsIgnoreCase(this.action);
        String targetUrl = Utils.assembleURL(this.parent.getPortletURLPrefix(), this.url, this.windowId, this.parent.getURLVersion(), actionState, false, this.portletMode, this.portletWindowState, this.urlParams, this.parent.getPortletURLSuffix(), this.parent.getPortletURLQueryParams(), null);
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, targetUrl, Utils.getScope(this.scope));
        } else {
            try {
                this.pageContext.getOut().print(targetUrl);
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.portletcontainer.aggregation.tags.StateTag.doEndTag", (String)"66", (Object)this);
                this.init();
                throw new JspTagException(ex.toString(), ex);
            }
        }
        this.init();
        return 6;
    }

    public void release() {
        this.init();
    }

    public void setUrl(String urlArg) {
        this.url = urlArg;
    }

    public void setWindowId(String windowIdArg) {
        this.windowId = windowIdArg;
    }

    public void setVar(String varArg) {
        this.var = varArg;
    }

    public void setScope(String scopeArg) {
        this.scope = scopeArg;
    }

    public void setPortletMode(String portletModeArg) {
        this.portletMode = portletModeArg;
    }

    public void setPortletWindowState(String portletWindowStateArg) {
        this.portletWindowState = portletWindowStateArg;
    }

    public void setAction(String actionArg) {
        this.action = actionArg;
    }

    protected void addUrlParam(String key, String value) {
        if (key != null && value != null) {
            String[] vals = this.urlParams.get(key);
            String[] newVals = null;
            if (vals != null) {
                newVals = new String[vals.length + 1];
                for (int i = 0; i < vals.length; ++i) {
                    newVals[i] = vals[i];
                }
                newVals[vals.length] = value;
            } else {
                newVals = new String[]{value};
            }
            this.urlParams.put(key, newVals);
        }
    }

    public String toString() {
        String separatorString = System.getProperty("line.separator");
        String retString = null;
        retString = separatorString + "url =                       [" + this.url + "]" + separatorString + "windowId =                  [" + this.windowId + "]" + separatorString + "var =                       [" + this.var + "]" + separatorString + "scope =                     [" + this.scope + "]" + separatorString + "portletMode =               [" + this.portletMode + "]" + separatorString + "portletWindowState =        [" + this.portletWindowState + "]" + separatorString + "action =                    [" + this.action + "]" + separatorString + "urlParams =                 [" + this.urlParams + "]";
        return retString;
    }
}

