/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.portletcontainer.aggregation.tags.Utils;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletStateHashtable {
    private static final long serialVersionUID = -2710128832326641518L;

    public static String createKey(String url, String windowId) {
        StringBuffer sb = new StringBuffer();
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        sb.append(url);
        if (windowId != null) {
            sb.append('/');
            sb.append(windowId);
        } else {
            sb.append('/');
            sb.append("default");
        }
        return sb.toString();
    }

    public static String createKey(String context, String portletName, String windowId) {
        StringBuffer sb = new StringBuffer();
        sb.append(context);
        sb.append('/');
        sb.append(portletName);
        return PortletStateHashtable.createKey(sb.toString(), windowId);
    }

    public static Map<String, Object> createStateHashtable(String modeValue, String stateValue, Map rparamsArg) {
        HashMap<String, Object> stateHashtable = new HashMap<String, Object>();
        if (modeValue != null) {
            stateHashtable.put(Utils.modeSuffix, modeValue);
        }
        if (stateValue != null) {
            stateHashtable.put(Utils.stateSuffix, stateValue);
        }
        if (rparamsArg != null) {
            HashMap rparams = new HashMap();
            for (String currentParameter : rparamsArg.keySet()) {
                rparams.put(currentParameter, rparamsArg.get(currentParameter));
            }
            stateHashtable.put(Utils.rparamSuffix, rparams);
        }
        return stateHashtable;
    }

    public static String createKey(PortletWindowIdentifier windowId) {
        StringBuffer sb = new StringBuffer();
        String contextRoot = windowId.getContextRoot();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        sb.append(contextRoot);
        sb.append("/");
        sb.append(windowId.getPortletName());
        if (windowId.getId(IdentifierNamespace.SESSION) != null) {
            sb.append('/');
            ObjectID windowoid = windowId.getId(IdentifierNamespace.SESSION);
            String oid = windowoid.toString();
            String realid = oid.substring(oid.indexOf("_") + 1);
            sb.append(realid);
        } else {
            sb.append('/');
            sb.append("default");
        }
        return sb.toString();
    }

    public static void setPortletMode(HttpSession session, PortletWindowIdentifier windowId, PortletMode mode) {
        String key = PortletStateHashtable.createKey(windowId);
        Map<String, Object> stateHashtable = (Map<String, Object>)session.getAttribute(key);
        if (stateHashtable == null) {
            stateHashtable = PortletStateHashtable.createStateHashtable(mode.toString(), null, null);
        } else {
            stateHashtable.put(Utils.modeSuffix, mode.toString());
            session.removeAttribute(key);
        }
        session.setAttribute(key, stateHashtable);
    }

    public static void setWindowState(HttpSession session, PortletWindowIdentifier windowId, WindowState state) {
        String key = PortletStateHashtable.createKey(windowId);
        Map<String, Object> stateHashtable = (Map<String, Object>)session.getAttribute(key);
        if (stateHashtable == null) {
            stateHashtable = PortletStateHashtable.createStateHashtable(null, state.toString(), null);
        } else {
            stateHashtable.put(Utils.stateSuffix, state.toString());
            session.removeAttribute(key);
        }
        session.setAttribute(key, stateHashtable);
    }

    public static void setRenderParameter(HttpSession session, PortletWindowIdentifier windowId, Map<String, String[]> parameters) {
        String key = PortletStateHashtable.createKey(windowId);
        Map<String, Object> stateHashtable = (Map<String, Object>)session.getAttribute(key);
        if (stateHashtable == null) {
            stateHashtable = PortletStateHashtable.createStateHashtable(null, null, parameters);
        } else {
            HashMap<String, String[]> rparams = new HashMap<String, String[]>();
            rparams.putAll(parameters);
            stateHashtable.put(Utils.rparamSuffix, rparams);
            session.removeAttribute(key);
        }
        session.setAttribute(key, stateHashtable);
    }

    public static PortletMode getPortletMode(HttpSession session, PortletWindowIdentifier windowId) {
        Map stateHashtable = (Map)session.getAttribute(PortletStateHashtable.createKey(windowId));
        if (stateHashtable == null) {
            return null;
        }
        String mode = (String)stateHashtable.get(Utils.modeSuffix);
        if (PortletMode.VIEW.toString().equals(mode)) {
            return PortletMode.VIEW;
        }
        if (PortletMode.EDIT.toString().equals(mode)) {
            return PortletMode.EDIT;
        }
        if (PortletMode.HELP.toString().equals(mode)) {
            return PortletMode.HELP;
        }
        return null;
    }

    public static WindowState getWindowState(HttpSession session, PortletWindowIdentifier windowId) {
        Map stateHashtable = (Map)session.getAttribute(PortletStateHashtable.createKey(windowId));
        if (stateHashtable == null) {
            return null;
        }
        String state = (String)stateHashtable.get(Utils.stateSuffix);
        if (WindowState.NORMAL.toString().equals(state)) {
            return WindowState.NORMAL;
        }
        if (WindowState.MAXIMIZED.toString().equals(state)) {
            return WindowState.MAXIMIZED;
        }
        if (WindowState.MINIMIZED.toString().equals(state)) {
            return WindowState.MINIMIZED;
        }
        return null;
    }

    public static Map<String, String[]> getRenderParameters(HttpSession session, PortletWindowIdentifier windowId) {
        Map stateHashtable = (Map)session.getAttribute(PortletStateHashtable.createKey(windowId));
        if (stateHashtable == null) {
            return null;
        }
        Map rparams = (Map)stateHashtable.get(Utils.rparamSuffix);
        return rparams;
    }
}

