/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.client.PerfLevelSpec;

public class PerfLevelDescriptor
implements PerfLevelSpec,
PmiConstants {
    private static final long serialVersionUID = -5934872678821227124L;
    static final int MODULE_INDEX = 1;
    static final int SUBMODULE_INDEX = 3;
    String[] path;
    int level;
    static final String pmiroot = "pmi";
    private String moduleID;

    public PerfLevelDescriptor(String[] stringArray, int n, String string) {
        this(stringArray, n);
        this.moduleID = string;
    }

    public PerfLevelDescriptor(String[] stringArray, int n) {
        if (n == 2) {
            n = 0;
        }
        this.level = n;
        if (stringArray == null) {
            this.path = new String[]{pmiroot};
        } else if (stringArray[0].equals(pmiroot)) {
            this.path = stringArray;
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = pmiroot;
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            this.path = stringArray2;
        }
        if (this.path.length > 3) {
            if (this.path[3].equals("methods")) {
                this.path[3] = "beanModule.methods";
            } else if (this.path[3].equals("servlets")) {
                this.path[3] = "webAppModule.servlets";
            }
        }
    }

    public String[] getPath() {
        return this.path;
    }

    public String[] getShortPath() {
        if (this.path == null || this.path.length == 0) {
            return null;
        }
        int n = 0;
        if (this.path[0].equals(pmiroot)) {
            n = 1;
        }
        if (n == 0) {
            return this.path;
        }
        String[] stringArray = new String[this.path.length - n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.path[i + n];
        }
        return stringArray;
    }

    public int comparePath(PerfLevelSpec perfLevelSpec) {
        return this.comparePath(perfLevelSpec.getPath());
    }

    public int comparePath(String[] stringArray) {
        if (this.path == null) {
            return -1;
        }
        if (stringArray == null) {
            return 1;
        }
        int n = this.path.length < stringArray.length ? this.path.length : stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.path[i].compareTo(stringArray[i]);
            if (n2 == 0) continue;
            return n2;
        }
        return this.path.length - stringArray.length;
    }

    public boolean isSubPath(PerfLevelSpec perfLevelSpec) {
        return this.isSubPath(perfLevelSpec.getPath());
    }

    public boolean isSubPath(String[] stringArray) {
        if (this.path == null || stringArray == null) {
            return false;
        }
        if (this.path.length >= stringArray.length) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            int n = this.path[i].compareTo(stringArray[i]);
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    public String getModuleName() {
        if (this.moduleID != null) {
            return this.moduleID;
        }
        if (this.path != null && this.path.length > 1) {
            return this.path[1];
        }
        return null;
    }

    public String getSubmoduleName() {
        if (this.path != null && this.path.length > 3) {
            return this.path[3];
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public String toString() {
        if (this.path == null || this.path.length == 0) {
            return "null=" + this.level;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.path.length; ++i) {
            stringBuffer.append(this.path[i]).append(",");
        }
        stringBuffer.append("=").append(this.level);
        return stringBuffer.toString();
    }

    public String getWCCMType() {
        if (this.path == null) {
            return "";
        }
        String string = this.getModuleName();
        if (string == null) {
            return "";
        }
        if (string.equals("beanModule")) {
            if (this.path.length > 5) {
                return string + "#" + "beanModule.methods";
            }
            return string + "#";
        }
        if (string.equals("jvmRuntimeModule")) {
            if (this.path.length > 2) {
                return this.path[1] + "#" + this.path[2];
            }
            return this.path[1] + "#";
        }
        if (this.path.length == 2) {
            return string;
        }
        if (this.path.length > 3) {
            return string + "#" + this.getSubmoduleName();
        }
        return string + "#";
    }
}

